/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.RuntimeDroolsException;
import org.drools.base.ValueType;
import org.drools.spi.WriteAccessor;
import org.drools.util.asm.ClassFieldInspector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseClassFieldWriter
implements WriteAccessor {
    private int index;
    private Class<?> fieldType;
    private ValueType valueType;

    public BaseClassFieldWriter() {
    }

    protected BaseClassFieldWriter(int index, Class<?> fieldType, ValueType valueType) {
        this.index = index;
        this.fieldType = fieldType;
        this.valueType = valueType;
    }

    public BaseClassFieldWriter(Class<?> clazz, String fieldName) {
        try {
            ClassFieldInspector inspector = new ClassFieldInspector(clazz);
            this.index = inspector.getFieldNames().get(fieldName);
            this.fieldType = inspector.getFieldTypes().get(fieldName);
            this.valueType = ValueType.determineValueType(this.fieldType);
        }
        catch (Exception e) {
            throw new RuntimeDroolsException(e);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.index = in.readInt();
        this.fieldType = (Class)in.readObject();
        this.valueType = (ValueType)in.readObject();
        if (this.valueType != null) {
            this.valueType = ValueType.determineValueType(this.valueType.getClassType());
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.index);
        out.writeObject(this.fieldType);
        out.writeObject(this.valueType);
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public Class<?> getFieldType() {
        return this.fieldType;
    }

    @Override
    public ValueType getValueType() {
        return this.valueType;
    }

    public int hashCode() {
        int PRIME = 31;
        int result = 1;
        result = 31 * result + this.fieldType.hashCode();
        result = 31 * result + this.index;
        result = 31 * result + this.valueType.hashCode();
        return result;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof BaseClassFieldWriter)) {
            return false;
        }
        BaseClassFieldWriter other = (BaseClassFieldWriter)object;
        return this.fieldType == other.fieldType && this.index == other.index && this.valueType.equals(other.valueType);
    }
}

