/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import org.drools.PackageIntegrationException;
import org.drools.RuleBaseConfiguration;
import org.drools.RuntimeDroolsException;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.common.DroolsObjectInput;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.definition.process.Process;
import org.drools.event.RuleBaseEventListener;
import org.drools.event.RuleBaseEventSupport;
import org.drools.marshalling.Marshaller;
import org.drools.rule.CompositeClassLoader;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.FactType;
import org.drools.rule.Function;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.spi.FactHandleFactory;
import org.drools.util.ObjectHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractRuleBase
implements InternalRuleBase,
Externalizable {
    protected String id;
    protected int workingMemoryCounter;
    protected RuleBaseConfiguration config;
    protected Map<String, Package> pkgs;
    protected Map processes;
    protected Map agendaGroupRuleTotals;
    protected transient CompositeClassLoader rootClassLoader;
    protected FactHandleFactory factHandleFactory;
    protected Map<String, Class> globals;
    private ReloadPackageCompilationData reloadPackageCompilationData = null;
    private RuleBaseEventSupport eventSupport = new RuleBaseEventSupport(this);
    protected transient ObjectHashSet statefulSessions;
    InternalWorkingMemory[] wms;
    int lastAquiredLock;
    protected ReentrantLock lock = new ReentrantLock();
    private int additionsSinceLock;
    private int removalsSinceLock;
    private transient Map<Class<?>, TypeDeclaration> classTypeDeclaration;
    private List<RuleBasePartitionId> partitionIDs;
    private ClassFieldAccessorCache classFieldAccessorCache;

    public AbstractRuleBase() {
    }

    @Override
    public synchronized int nextWorkingMemoryCounter() {
        return this.workingMemoryCounter++;
    }

    public AbstractRuleBase(String id, RuleBaseConfiguration config, FactHandleFactory factHandleFactory) {
        this.id = id != null ? id : "default";
        this.config = config != null ? config : new RuleBaseConfiguration();
        this.config.makeImmutable();
        this.factHandleFactory = factHandleFactory;
        if (this.config.isSequential()) {
            this.agendaGroupRuleTotals = new HashMap();
        }
        this.rootClassLoader = new CompositeClassLoader(this.config.getClassLoader());
        this.pkgs = new HashMap<String, Package>();
        this.processes = new HashMap();
        this.globals = new HashMap<String, Class>();
        this.statefulSessions = new ObjectHashSet();
        this.classTypeDeclaration = new HashMap();
        this.partitionIDs = new ArrayList<RuleBasePartitionId>();
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ByteArrayOutputStream bytes;
        ObjectOutput droolsStream;
        boolean isDrools = out instanceof DroolsObjectOutputStream;
        if (isDrools) {
            droolsStream = out;
            bytes = null;
        } else {
            bytes = new ByteArrayOutputStream();
            droolsStream = new DroolsObjectOutputStream(bytes);
        }
        droolsStream.writeObject(this.config);
        droolsStream.writeObject(this.pkgs);
        droolsStream.writeObject(this.id);
        droolsStream.writeInt(this.workingMemoryCounter);
        droolsStream.writeObject(this.processes);
        droolsStream.writeObject(this.agendaGroupRuleTotals);
        droolsStream.writeUTF(this.factHandleFactory.getClass().getName());
        droolsStream.writeObject(this.globals);
        droolsStream.writeObject(this.partitionIDs);
        this.eventSupport.removeEventListener(RuleBaseEventListener.class);
        droolsStream.writeObject(this.eventSupport);
        if (!isDrools) {
            bytes.close();
            out.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        DroolsObjectInput droolsStream = null;
        boolean isDrools = in instanceof DroolsObjectInput;
        droolsStream = isDrools ? (DroolsObjectInput)in : new DroolsObjectInputStream((ObjectInputStream)in);
        this.rootClassLoader = new CompositeClassLoader(droolsStream.getParentClassLoader());
        droolsStream.setClassLoader(this.rootClassLoader);
        droolsStream.setRuleBase(this);
        this.classFieldAccessorCache = new ClassFieldAccessorCache(this.rootClassLoader);
        this.config = (RuleBaseConfiguration)droolsStream.readObject();
        this.config.setClassLoader(droolsStream.getParentClassLoader());
        this.pkgs = (Map)droolsStream.readObject();
        for (Package object : this.pkgs.values()) {
            object.getDialectRuntimeRegistry().onAdd(this.rootClassLoader);
        }
        this.id = (String)droolsStream.readObject();
        this.workingMemoryCounter = droolsStream.readInt();
        this.processes = (Map)droolsStream.readObject();
        this.agendaGroupRuleTotals = (Map)droolsStream.readObject();
        Class<?> cls = null;
        try {
            cls = droolsStream.getParentClassLoader().loadClass(droolsStream.readUTF());
            this.factHandleFactory = (FactHandleFactory)cls.newInstance();
        }
        catch (InstantiationException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        catch (IllegalAccessException e) {
            DroolsObjectInputStream.newInvalidClassException(cls, e);
        }
        for (Package object : this.pkgs.values()) {
            object.getDialectRuntimeRegistry().onBeforeExecute();
            object.getClassFieldAccessorStore().setClassFieldAccessorCache(this.classFieldAccessorCache);
            object.getClassFieldAccessorStore().wire();
        }
        this.populateTypeDeclarationMaps();
        this.globals = (Map)droolsStream.readObject();
        this.partitionIDs = (List)droolsStream.readObject();
        this.eventSupport = (RuleBaseEventSupport)droolsStream.readObject();
        this.eventSupport.setRuleBase(this);
        this.statefulSessions = new ObjectHashSet();
        if (!isDrools) {
            droolsStream.close();
        }
    }

    private void populateTypeDeclarationMaps() throws ClassNotFoundException {
        this.classTypeDeclaration = new HashMap();
        for (Package pkg : this.pkgs.values()) {
            for (TypeDeclaration type : pkg.getTypeDeclarations().values()) {
                type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                this.classTypeDeclaration.put(type.getTypeClass(), type);
            }
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public StatefulSession newStatefulSession() {
        return this.newStatefulSession(new SessionConfiguration());
    }

    @Override
    public synchronized void disposeStatefulSession(StatefulSession statefulSession) {
        this.statefulSessions.remove(statefulSession);
        Iterator it = statefulSession.getRuleBaseUpdateListeners().iterator();
        while (it.hasNext()) {
            this.removeEventListener((RuleBaseEventListener)it.next());
        }
    }

    @Override
    public StatefulSession readStatefulSession(InputStream stream, Marshaller marshaller) throws IOException, ClassNotFoundException {
        return this.readStatefulSession(stream, true, marshaller);
    }

    public FactHandleFactory getFactHandleFactory() {
        return this.factHandleFactory;
    }

    @Override
    public FactHandleFactory newFactHandleFactory() {
        return this.factHandleFactory.newInstance();
    }

    @Override
    public FactHandleFactory newFactHandleFactory(int id, long counter) {
        return this.factHandleFactory.newInstance(id, counter);
    }

    @Override
    public org.drools.process.core.Process[] getProcesses() {
        return this.processes.values().toArray(new org.drools.process.core.Process[this.processes.size()]);
    }

    @Override
    public Package[] getPackages() {
        return this.pkgs.values().toArray(new Package[this.pkgs.size()]);
    }

    @Override
    public Map<String, Package> getPackagesMap() {
        return this.pkgs;
    }

    @Override
    public Map getGlobals() {
        return this.globals;
    }

    @Override
    public Map getAgendaGroupRuleTotals() {
        return this.agendaGroupRuleTotals;
    }

    @Override
    public int getAdditionsSinceLock() {
        return this.additionsSinceLock;
    }

    @Override
    public int getRemovalsSinceLock() {
        return this.removalsSinceLock;
    }

    @Override
    public void lock() {
        this.additionsSinceLock = 0;
        this.removalsSinceLock = 0;
        this.eventSupport.fireBeforeRuleBaseLocked();
        this.lock.lock();
        this.lastAquiredLock = 0;
        this.wms = this.getWorkingMemories();
        this.lastAquiredLock = 0;
        while (this.lastAquiredLock < this.wms.length) {
            this.wms[this.lastAquiredLock].getLock().lock();
            ++this.lastAquiredLock;
        }
        this.eventSupport.fireAfterRuleBaseLocked();
    }

    @Override
    public void unlock() {
        this.eventSupport.fireBeforeRuleBaseUnlocked();
        --this.lastAquiredLock;
        while (this.lastAquiredLock > -1) {
            this.wms[this.lastAquiredLock].getLock().unlock();
            --this.lastAquiredLock;
        }
        this.lock.unlock();
        this.eventSupport.fireAfterRuleBaseUnlocked();
        this.wms = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addPackages(Collection<Package> newPkgs) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            boolean doUnlock = false;
            if (!(this.lock.isHeldByCurrentThread() || this.wms != null && this.wms.length != 0)) {
                this.lock();
                doUnlock = true;
            }
            try {
                Package pkg;
                for (Package newPkg : newPkgs) {
                    newPkg.checkValidity();
                    ++this.additionsSinceLock;
                    this.eventSupport.fireBeforePackageAdded(newPkg);
                    pkg = this.pkgs.get(newPkg.getName());
                    if (pkg == null) {
                        pkg = new Package(newPkg.getName());
                        pkg.setClassFieldAccessorCache(this.classFieldAccessorCache);
                        this.pkgs.put(pkg.getName(), pkg);
                    }
                    pkg.getDialectRuntimeRegistry().merge(newPkg.getDialectRuntimeRegistry(), this.rootClassLoader);
                }
                for (Package newPkg : newPkgs) {
                    pkg = this.pkgs.get(newPkg.getName());
                    if (newPkg.getFunctions() != null) {
                        for (Map.Entry<String, Function> entry : newPkg.getFunctions().entrySet()) {
                            pkg.addFunction(entry.getValue());
                        }
                    }
                    pkg.getClassFieldAccessorStore().merge(newPkg.getClassFieldAccessorStore());
                    pkg.getDialectRuntimeRegistry().onBeforeExecute();
                    TypeDeclaration lastType = null;
                    try {
                        if (newPkg.getTypeDeclarations() != null) {
                            Iterator<TypeDeclaration> i$ = newPkg.getTypeDeclarations().values().iterator();
                            while (i$.hasNext()) {
                                TypeDeclaration type;
                                lastType = type = i$.next();
                                type.setTypeClass(this.rootClassLoader.loadClass(type.getTypeClassName()));
                                if (this.classTypeDeclaration.containsKey(type.getTypeClass())) continue;
                                this.classTypeDeclaration.put(type.getTypeClass(), type);
                            }
                        }
                    }
                    catch (ClassNotFoundException e) {
                        throw new RuntimeDroolsException("unable to resolve Type Declaration class '" + lastType.getTypeName() + "'");
                    }
                    this.mergePackage(pkg, newPkg);
                    Rule[] rules = newPkg.getRules();
                    for (int i = 0; i < rules.length; ++i) {
                        this.addRule(newPkg, rules[i]);
                    }
                    if (newPkg.getRuleFlows() != null) {
                        Map<String, Process> flows = newPkg.getRuleFlows();
                        Iterator<Map.Entry<String, Process>> i$ = newPkg.getRuleFlows().entrySet().iterator();
                        while (i$.hasNext()) {
                            Map.Entry<String, Process> object;
                            Map.Entry<String, Process> flow = object = i$.next();
                            this.processes.put(flow.getKey(), flow.getValue());
                        }
                    }
                    this.eventSupport.fireAfterPackageAdded(newPkg);
                }
            }
            finally {
                if (doUnlock) {
                    this.unlock();
                }
            }
        }
    }

    private void mergePackage(Package pkg, Package newPkg) {
        Map<String, ImportDeclaration> imports = pkg.getImports();
        imports.putAll(newPkg.getImports());
        String lastType = null;
        try {
            if (newPkg.getGlobals() != null && newPkg.getGlobals() != Collections.EMPTY_MAP) {
                Map<String, String> globals = pkg.getGlobals();
                for (Map.Entry<String, String> entry : newPkg.getGlobals().entrySet()) {
                    String type;
                    String string = entry.getKey();
                    lastType = type = entry.getValue();
                    if (globals.containsKey(string) && !globals.get(string).equals(type)) {
                        throw new PackageIntegrationException(pkg);
                    }
                    pkg.addGlobal(string, this.rootClassLoader.loadClass(type));
                    this.globals.put(string, this.rootClassLoader.loadClass(type));
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeDroolsException("Unable to resolve class '" + lastType + "'");
        }
        if (newPkg.getTypeDeclarations() != null) {
            for (TypeDeclaration type : newPkg.getTypeDeclarations().values()) {
                if (pkg.getTypeDeclarations().containsKey(type.getTypeName())) continue;
                pkg.addTypeDeclaration(type);
            }
        }
        Rule[] newRules = newPkg.getRules();
        for (int i = 0; i < newRules.length; ++i) {
            Rule newRule = newRules[i];
            if (pkg.getRule(newRule.getName()) != null) {
                this.removeRule(pkg, pkg.getRule(newRule.getName()));
            }
            pkg.addRule(newRule);
        }
        if (newPkg.getRuleFlows() != null) {
            Map<String, Process> flows = newPkg.getRuleFlows();
            for (org.drools.process.core.Process process : flows.values()) {
                pkg.addProcess(process);
            }
        }
    }

    @Override
    public TypeDeclaration getTypeDeclaration(Class<?> clazz) {
        return this.classTypeDeclaration.get(clazz);
    }

    @Override
    public Collection<TypeDeclaration> getTypeDeclarations() {
        return this.classTypeDeclaration.values();
    }

    public synchronized void addRule(Package pkg, Rule rule) throws InvalidPatternException {
        this.eventSupport.fireBeforeRuleAdded(pkg, rule);
        this.addRule(rule);
        this.eventSupport.fireAfterRuleAdded(pkg, rule);
    }

    protected abstract void addRule(Rule var1) throws InvalidPatternException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePackage(String packageName) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            boolean doUnlock = false;
            if (!(this.lock.isHeldByCurrentThread() || this.wms != null && this.wms.length != 0)) {
                this.lock();
                doUnlock = true;
            }
            try {
                ++this.removalsSinceLock;
                this.eventSupport.fireBeforePackageRemoved(pkg);
                Rule[] rules = pkg.getRules();
                for (int i = 0; i < rules.length; ++i) {
                    this.removeRule(pkg, rules[i]);
                }
                HashSet<String> referencedGlobals = new HashSet<String>();
                for (Package pkgref : this.pkgs.values()) {
                    if (pkgref == pkg) continue;
                    referencedGlobals.addAll(pkgref.getGlobals().keySet());
                }
                for (String globalName : pkg.getGlobals().keySet()) {
                    if (referencedGlobals.contains(globalName)) continue;
                    this.globals.remove(globalName);
                }
                Map<String, Process> flows = pkg.getRuleFlows();
                Iterator<String> iter = flows.keySet().iterator();
                while (iter.hasNext()) {
                    this.removeProcess(iter.next());
                }
                this.pkgs.remove(pkg.getName());
                pkg.getDialectRuntimeRegistry().onRemove();
                pkg.clear();
                this.eventSupport.fireAfterPackageRemoved(pkg);
            }
            finally {
                if (doUnlock) {
                    this.unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeRule(String packageName, String ruleName) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            Rule rule = pkg.getRule(ruleName);
            if (rule == null) {
                throw new IllegalArgumentException("Rule name '" + ruleName + "' does not exist in the Package '" + packageName + "'.");
            }
            boolean doUnlock = false;
            if (!(this.lock.isHeldByCurrentThread() || this.wms != null && this.wms.length != 0)) {
                this.lock();
                doUnlock = true;
            }
            ++this.removalsSinceLock;
            this.removeRule(pkg, rule);
            pkg.removeRule(rule);
            if (this.reloadPackageCompilationData == null) {
                this.reloadPackageCompilationData = new ReloadPackageCompilationData();
            }
            this.reloadPackageCompilationData.addDialectDatas(pkg.getDialectRuntimeRegistry());
            if (doUnlock) {
                this.unlock();
            }
        }
    }

    public void removeRule(Package pkg, Rule rule) {
        this.eventSupport.fireBeforeRuleRemoved(pkg, rule);
        this.removeRule(rule);
        this.eventSupport.fireAfterRuleRemoved(pkg, rule);
    }

    protected abstract void removeRule(Rule var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeFunction(String packageName, String functionName) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            Package pkg = this.pkgs.get(packageName);
            if (pkg == null) {
                throw new IllegalArgumentException("Package name '" + packageName + "' does not exist for this Rule Base.");
            }
            this.eventSupport.fireBeforeFunctionRemoved(pkg, functionName);
            if (!pkg.getFunctions().containsKey(functionName)) {
                throw new IllegalArgumentException("function name '" + packageName + "' does not exist in the Package '" + packageName + "'.");
            }
            pkg.removeFunction(functionName);
            if (this.reloadPackageCompilationData == null) {
                this.reloadPackageCompilationData = new ReloadPackageCompilationData();
            }
            this.reloadPackageCompilationData.addDialectDatas(pkg.getDialectRuntimeRegistry());
            this.eventSupport.fireAfterFunctionRemoved(pkg, functionName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addProcess(org.drools.process.core.Process process) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            this.processes.put(process.getId(), process);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void removeProcess(String id) {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            this.processes.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public org.drools.process.core.Process getProcess(String id) {
        org.drools.process.core.Process process = null;
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            process = (org.drools.process.core.Process)this.processes.get(id);
        }
        return process;
    }

    protected synchronized void addStatefulSession(StatefulSession statefulSession) {
        this.statefulSessions.add(statefulSession);
    }

    @Override
    public Package getPackage(String name) {
        return this.pkgs.get(name);
    }

    @Override
    public StatefulSession[] getStatefulSessions() {
        return (StatefulSession[])this.statefulSessions.toArray(new StatefulSession[this.statefulSessions.size()]);
    }

    @Override
    public InternalWorkingMemory[] getWorkingMemories() {
        return (InternalWorkingMemory[])this.statefulSessions.toArray(new InternalWorkingMemory[this.statefulSessions.size()]);
    }

    @Override
    public RuleBaseConfiguration getConfiguration() {
        return this.config;
    }

    @Override
    public CompositeClassLoader getRootClassLoader() {
        return this.rootClassLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void executeQueuedActions() {
        Map<String, Package> map = this.pkgs;
        synchronized (map) {
            if (this.reloadPackageCompilationData != null) {
                this.reloadPackageCompilationData.execute(this);
                this.reloadPackageCompilationData = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RuleBasePartitionId createNewPartitionId() {
        RuleBasePartitionId p = null;
        List<RuleBasePartitionId> list = this.partitionIDs;
        synchronized (list) {
            p = new RuleBasePartitionId("P-" + this.partitionIDs.size());
            this.partitionIDs.add(p);
        }
        return p;
    }

    @Override
    public List<RuleBasePartitionId> getPartitionIds() {
        return this.partitionIDs;
    }

    @Override
    public void addEventListener(RuleBaseEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    @Override
    public void removeEventListener(RuleBaseEventListener listener) {
        this.eventSupport.removeEventListener(listener);
    }

    @Override
    public List<RuleBaseEventListener> getRuleBaseEventListeners() {
        return this.eventSupport.getEventListeners();
    }

    public boolean isEvent(Class clazz) {
        for (Package pkg : this.pkgs.values()) {
            if (!pkg.isEvent(clazz)) continue;
            return true;
        }
        return false;
    }

    @Override
    public FactType getFactType(String name) {
        for (Package pkg : this.pkgs.values()) {
            FactType type = pkg.getFactType(name);
            if (type == null) continue;
            return type;
        }
        return null;
    }

    public ClassFieldAccessorCache getClassFieldAccessorCache() {
        return this.classFieldAccessorCache;
    }

    public static interface RuleBaseAction
    extends Externalizable {
        public void execute(InternalRuleBase var1);
    }

    public static class ReloadPackageCompilationData
    implements RuleBaseAction {
        private static final long serialVersionUID = 1L;
        private Set<DialectRuntimeRegistry> set;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.set = (Set)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.set);
        }

        public void addDialectDatas(DialectRuntimeRegistry registry) {
            if (this.set == null) {
                this.set = new HashSet<DialectRuntimeRegistry>();
            }
            if (!this.set.contains(registry)) {
                this.set.add(registry);
            }
        }

        public void execute(InternalRuleBase ruleBase) {
            for (DialectRuntimeRegistry registry : this.set) {
                registry.onBeforeExecute();
            }
        }
    }
}

