/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.EventSupport;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleFlowGroup;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleFlowGroupListener;
import org.drools.common.RuleFlowGroupNode;
import org.drools.common.WorkingMemoryAction;
import org.drools.marshalling.MarshallerReaderContext;
import org.drools.marshalling.MarshallerWriteContext;
import org.drools.spi.Activation;
import org.drools.util.Iterator;
import org.drools.util.LinkedList;

public class RuleFlowGroupImpl
implements InternalRuleFlowGroup {
    private static final long serialVersionUID = 400L;
    private InternalWorkingMemory workingMemory;
    private String name;
    private boolean active = false;
    private boolean autoDeactivate = true;
    private LinkedList list;
    private List<RuleFlowGroupListener> listeners;

    public RuleFlowGroupImpl() {
    }

    public RuleFlowGroupImpl(String name) {
        this.name = name;
        this.list = new LinkedList();
    }

    public RuleFlowGroupImpl(String name, boolean active, boolean autoDeactivate) {
        this.name = name;
        this.active = active;
        this.autoDeactivate = autoDeactivate;
        this.list = new LinkedList();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.name = (String)in.readObject();
        this.active = in.readBoolean();
        this.list = (LinkedList)in.readObject();
        this.autoDeactivate = in.readBoolean();
        this.listeners = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeObject(this.name);
        out.writeBoolean(this.active);
        out.writeObject(this.list);
        out.writeBoolean(this.autoDeactivate);
        out.writeObject(this.listeners);
    }

    public String getName() {
        return this.name;
    }

    public void setWorkingMemory(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    public InternalWorkingMemory getWorkingMemory() {
        return this.workingMemory;
    }

    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (active) {
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireBeforeRuleFlowGroupActivated(this, this.workingMemory);
            if (this.list.isEmpty()) {
                if (this.autoDeactivate) {
                    DeactivateCallback action = new DeactivateCallback(this);
                    this.workingMemory.queueWorkingMemoryAction(action);
                }
            } else {
                this.triggerActivations();
            }
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireAfterRuleFlowGroupActivated(this, this.workingMemory);
        } else {
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireBeforeRuleFlowGroupDeactivated(this, this.workingMemory);
            Iterator it = this.list.iterator();
            RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
            while (node != null) {
                Activation activation = node.getActivation();
                activation.remove();
                if (activation.getActivationGroupNode() != null) {
                    activation.getActivationGroupNode().getActivationGroup().removeActivation(activation);
                }
                node = (RuleFlowGroupNode)it.next();
            }
            this.notifyRuleFlowGroupListeners();
            ((EventSupport)((Object)this.workingMemory)).getRuleFlowEventSupport().fireAfterRuleFlowGroupDeactivated(this, this.workingMemory);
        }
    }

    public boolean isActive() {
        return this.active;
    }

    public boolean isAutoDeactivate() {
        return this.autoDeactivate;
    }

    public void setAutoDeactivate(boolean autoDeactivate) {
        this.autoDeactivate = autoDeactivate;
        if (autoDeactivate && this.active && this.list.isEmpty()) {
            this.active = false;
        }
    }

    private void triggerActivations() {
        Iterator it = this.list.iterator();
        RuleFlowGroupNode node = (RuleFlowGroupNode)it.next();
        while (node != null) {
            Activation activation = node.getActivation();
            ((InternalAgendaGroup)activation.getAgendaGroup()).add(activation);
            node = (RuleFlowGroupNode)it.next();
        }
    }

    public void clear() {
        this.list.clear();
        this.active = false;
    }

    public int size() {
        return this.list.size();
    }

    public void addActivation(Activation activation) {
        RuleFlowGroupNode node = new RuleFlowGroupNode(activation, this);
        activation.setRuleFlowGroupNode(node);
        this.list.add(node);
        if (this.active) {
            ((InternalAgendaGroup)activation.getAgendaGroup()).add(activation);
        }
    }

    public void removeActivation(Activation activation) {
        RuleFlowGroupNode node = activation.getRuleFlowGroupNode();
        this.list.remove(node);
        activation.setActivationGroupNode(null);
        if (this.active && this.autoDeactivate && this.list.isEmpty()) {
            DeactivateCallback action = new DeactivateCallback(this);
            this.workingMemory.queueWorkingMemoryAction(action);
        }
    }

    public void addRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners == null) {
            this.listeners = new CopyOnWriteArrayList<RuleFlowGroupListener>();
        }
        this.listeners.add(listener);
    }

    public void removeRuleFlowGroupListener(RuleFlowGroupListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    public void notifyRuleFlowGroupListeners() {
        if (this.listeners != null) {
            java.util.Iterator<RuleFlowGroupListener> iterator = this.listeners.iterator();
            while (iterator.hasNext()) {
                iterator.next().ruleFlowGroupDeactivated();
            }
        }
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    public java.util.Iterator iterator() {
        return this.list.javaUtilIterator();
    }

    public String toString() {
        return "RuleFlowGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof RuleFlowGroupImpl)) {
            return false;
        }
        return ((RuleFlowGroupImpl)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public static class DeactivateCallback
    implements WorkingMemoryAction {
        private static final long serialVersionUID = 400L;
        private InternalRuleFlowGroup ruleFlowGroup;

        public DeactivateCallback() {
        }

        public DeactivateCallback(InternalRuleFlowGroup ruleFlowGroup) {
            this.ruleFlowGroup = ruleFlowGroup;
        }

        public DeactivateCallback(MarshallerReaderContext context) throws IOException {
        }

        public void write(MarshallerWriteContext context) throws IOException {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.ruleFlowGroup = (InternalRuleFlowGroup)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.ruleFlowGroup);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            if (this.ruleFlowGroup.isEmpty()) {
                this.ruleFlowGroup.setActive(false);
            }
        }
    }
}

