/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.drools.common.InternalWorkingMemory;
import org.drools.event.RuleFlowCompletedEvent;
import org.drools.event.RuleFlowEventListener;
import org.drools.event.RuleFlowGroupActivatedEvent;
import org.drools.event.RuleFlowGroupDeactivatedEvent;
import org.drools.event.RuleFlowNodeTriggeredEvent;
import org.drools.event.RuleFlowStartedEvent;
import org.drools.runtime.process.NodeInstance;
import org.drools.runtime.process.ProcessInstance;
import org.drools.runtime.process.WorkflowProcessInstance;
import org.drools.spi.RuleFlowGroup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RuleFlowEventSupport
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private List<RuleFlowEventListener> listeners = new CopyOnWriteArrayList<RuleFlowEventListener>();

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.listeners = (List)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.listeners);
    }

    public void addEventListener(RuleFlowEventListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeEventListener(RuleFlowEventListener listener) {
        this.listeners.remove(listener);
    }

    public List<RuleFlowEventListener> getEventListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    public int size() {
        return this.listeners.size();
    }

    public boolean isEmpty() {
        return this.listeners.isEmpty();
    }

    public void fireBeforeRuleFlowProcessStarted(org.drools.process.instance.ProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowStartedEvent event = new RuleFlowStartedEvent(instance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowStarted(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowProcessStarted(org.drools.process.instance.ProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowStartedEvent event = new RuleFlowStartedEvent(instance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowStarted(event, workingMemory);
        }
    }

    public void fireBeforeRuleFlowProcessCompleted(WorkflowProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowCompletedEvent event = new RuleFlowCompletedEvent((ProcessInstance)instance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowCompleted(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowProcessCompleted(WorkflowProcessInstance instance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowCompletedEvent event = new RuleFlowCompletedEvent((ProcessInstance)instance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowCompleted(event, workingMemory);
        }
    }

    public void fireBeforeRuleFlowGroupActivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupActivatedEvent event = new RuleFlowGroupActivatedEvent(ruleFlowGroup);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowGroupActivated(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowGroupActivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupActivatedEvent event = new RuleFlowGroupActivatedEvent(ruleFlowGroup);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowGroupActivated(event, workingMemory);
        }
    }

    public void fireBeforeRuleFlowGroupDeactivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupDeactivatedEvent event = new RuleFlowGroupDeactivatedEvent(ruleFlowGroup);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowGroupDeactivated(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowGroupDeactivated(RuleFlowGroup ruleFlowGroup, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowGroupDeactivatedEvent event = new RuleFlowGroupDeactivatedEvent(ruleFlowGroup);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowGroupDeactivated(event, workingMemory);
        }
    }

    public void fireBeforeRuleFlowNodeTriggered(NodeInstance ruleFlowNodeInstance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowNodeTriggeredEvent event = new RuleFlowNodeTriggeredEvent(ruleFlowNodeInstance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowNodeTriggered(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowNodeTriggered(NodeInstance ruleFlowNodeInstance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowNodeTriggeredEvent event = new RuleFlowNodeTriggeredEvent(ruleFlowNodeInstance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowNodeTriggered(event, workingMemory);
        }
    }

    public void fireBeforeRuleFlowNodeLeft(NodeInstance ruleFlowNodeInstance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowNodeTriggeredEvent event = new RuleFlowNodeTriggeredEvent(ruleFlowNodeInstance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.beforeRuleFlowNodeLeft(event, workingMemory);
        }
    }

    public void fireAfterRuleFlowNodeLeft(NodeInstance ruleFlowNodeInstance, InternalWorkingMemory workingMemory) {
        if (this.listeners.isEmpty()) {
            return;
        }
        RuleFlowNodeTriggeredEvent event = new RuleFlowNodeTriggeredEvent(ruleFlowNodeInstance);
        for (RuleFlowEventListener listener : this.listeners) {
            listener.afterRuleFlowNodeLeft(event, workingMemory);
        }
    }

    public void reset() {
        this.listeners.clear();
    }
}

