/*
 * Decompiled with CFR 0.152.
 */
package org.drools.io.impl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.drools.ChangeSet;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.io.InternalResource;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeNotifier;
import org.drools.io.ResourceChangeScanner;
import org.drools.io.ResourceChangeScannerConfiguration;
import org.drools.io.impl.ChangeSetImpl;
import org.drools.io.impl.ResourceChangeScannerConfigurationImpl;

public class ResourceChangeScannerImpl
implements ResourceChangeScanner {
    private Map<Resource, Set<ResourceChangeNotifier>> resources;
    private Set<Resource> directories;
    private SystemEventListener listener = SystemEventListenerFactory.getSystemEventListener();
    private Thread thread;
    private ProcessChangeSet scannerScheduler;

    public ResourceChangeScannerImpl() {
        this.resources = new HashMap<Resource, Set<ResourceChangeNotifier>>();
        this.directories = new HashSet<Resource>();
        this.scannerScheduler = new ProcessChangeSet(this.resources, this, this.listener);
        this.setInterval(60);
        this.listener.info("ResourceChangeScanner created with default interval=60");
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(ResourceChangeScannerConfiguration configuration) {
        this.setInterval(((ResourceChangeScannerConfigurationImpl)configuration).getInterval());
        this.listener.info("ResourceChangeScanner reconfigured with interval=" + this.getInterval() / 1000);
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            this.resources.notify();
        }
    }

    public ResourceChangeScannerConfiguration newResourceChangeScannerConfiguration() {
        return new ResourceChangeScannerConfigurationImpl();
    }

    public ResourceChangeScannerConfiguration newResourceChangeScannerConfiguration(Properties properties) {
        return new ResourceChangeScannerConfigurationImpl(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void subscribeNotifier(ResourceChangeNotifier notifier, Resource resource) {
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            Set<ResourceChangeNotifier> notifiers;
            if (((InternalResource)resource).isDirectory()) {
                this.directories.add(resource);
            }
            if ((notifiers = this.resources.get(resource)) == null) {
                notifiers = new HashSet<ResourceChangeNotifier>();
                this.resources.put(resource, notifiers);
            }
            this.listener.debug("ResourceChangeScanner subcribing notifier=" + notifier + " to resource=" + resource);
            notifiers.add(notifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unsubscribeNotifier(ResourceChangeNotifier notifier, Resource resource) {
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            Set<ResourceChangeNotifier> notifiers = this.resources.get(resource);
            if (notifiers == null) {
                return;
            }
            this.listener.debug("ResourceChangeScanner unsubcribing notifier=" + notifier + " to resource=" + resource);
            notifiers.remove(notifier);
            if (notifiers.isEmpty()) {
                this.listener.debug("ResourceChangeScanner resource=" + resource + " now has no subscribers");
                this.resources.remove(resource);
                this.directories.remove(resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scan() {
        this.listener.debug("ResourceChangeScanner attempt to scan " + this.resources.size() + " resources");
        Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
        synchronized (map) {
            HashMap<ResourceChangeNotifier, ChangeSetImpl> notifications = new HashMap<ResourceChangeNotifier, ChangeSetImpl>();
            ArrayList<Resource> removed = new ArrayList<Resource>();
            for (Resource resource : this.directories) {
                this.listener.debug("ResourceChangeScanner scanning directory=" + resource);
                for (Resource child : ((InternalResource)resource).listResources()) {
                    if (((InternalResource)child).isDirectory() || this.resources.containsKey(child)) continue;
                    this.listener.debug("ResourceChangeScanner new resource=" + child);
                    ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                    Set<ResourceChangeNotifier> notifiers = this.resources.get(resource);
                    for (ResourceChangeNotifier notifier : notifiers) {
                        ChangeSetImpl changeSet = (ChangeSetImpl)notifications.get(notifier);
                        if (changeSet == null) {
                            changeSet = new ChangeSetImpl();
                            notifications.put(notifier, changeSet);
                        }
                        if (changeSet.getResourcesAdded().isEmpty()) {
                            changeSet.setResourcesAdded(new ArrayList<Resource>());
                        }
                        changeSet.getResourcesAdded().add(child);
                        notifier.subscribeChildResource(resource, child);
                    }
                }
            }
            for (Map.Entry entry : this.resources.entrySet()) {
                ChangeSetImpl changeSet;
                Resource resource = (Resource)entry.getKey();
                Set notifiers = (Set)entry.getValue();
                if (((InternalResource)resource).isDirectory()) continue;
                long lastModified = ((InternalResource)resource).getLastModified();
                if (lastModified == 0L) {
                    this.listener.debug("ResourceChangeScanner removed resource=" + resource);
                    removed.add(resource);
                    for (ResourceChangeNotifier notifier : notifiers) {
                        changeSet = (ChangeSetImpl)notifications.get(notifier);
                        if (changeSet == null) {
                            changeSet = new ChangeSetImpl();
                            notifications.put(notifier, changeSet);
                        }
                        if (changeSet.getResourcesRemoved().isEmpty()) {
                            changeSet.setResourcesRemoved(new ArrayList<Resource>());
                        }
                        changeSet.getResourcesRemoved().add(resource);
                    }
                    continue;
                }
                if (((InternalResource)resource).getLastRead() >= lastModified) continue;
                this.listener.debug("ResourceChangeScanner modified resource=" + resource);
                for (ResourceChangeNotifier notifier : notifiers) {
                    changeSet = (ChangeSetImpl)notifications.get(notifier);
                    if (changeSet == null) {
                        changeSet = new ChangeSetImpl();
                        notifications.put(notifier, changeSet);
                    }
                    if (changeSet.getResourcesModified().isEmpty()) {
                        changeSet.setResourcesModified(new ArrayList<Resource>());
                    }
                    changeSet.getResourcesModified().add(resource);
                }
            }
            for (Resource resource : removed) {
                this.resources.remove(resource);
            }
            for (Map.Entry entry : notifications.entrySet()) {
                ResourceChangeNotifier notifier = (ResourceChangeNotifier)entry.getKey();
                ChangeSet changeSet = (ChangeSet)entry.getValue();
                notifier.publishChangeSet(changeSet);
            }
        }
    }

    public void setInterval(int interval) {
        this.scannerScheduler.setInterval(interval);
        if (this.scannerScheduler.isRunning()) {
            this.thread.interrupt();
        }
    }

    public int getInterval() {
        return this.scannerScheduler.getInterval();
    }

    public void start() {
        if (!this.scannerScheduler.isRunning()) {
            this.scannerScheduler.setScan(true);
            this.thread = new Thread(this.scannerScheduler);
            this.thread.start();
        }
    }

    public void stop() {
        this.scannerScheduler.setScan(false);
        this.thread.interrupt();
    }

    public void reset() {
        this.resources.clear();
        this.directories.clear();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ProcessChangeSet
    implements Runnable {
        private volatile boolean scan;
        private ResourceChangeScannerImpl scanner;
        private long interval;
        private Map<Resource, Set<ResourceChangeNotifier>> resources;
        private SystemEventListener listener;

        ProcessChangeSet(Map<Resource, Set<ResourceChangeNotifier>> resources, ResourceChangeScannerImpl scanner, SystemEventListener listener) {
            this.resources = resources;
            this.scanner = scanner;
            this.listener = listener;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public int getInterval() {
            return (int)this.interval / 1000;
        }

        public void setScan(boolean scan) {
            this.scan = scan;
        }

        public boolean isRunning() {
            return this.scan;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            ProcessChangeSet processChangeSet = this;
            synchronized (processChangeSet) {
                if (this.scan) {
                    this.listener.info("ResourceChangeNotification scanner has started");
                }
                while (this.scan) {
                    System.out.println("BEFORE : sync this.resources");
                    Map<Resource, Set<ResourceChangeNotifier>> map = this.resources;
                    synchronized (map) {
                        System.out.println("DURING : sync this.resources");
                        this.scanner.scan();
                    }
                    System.out.println("AFTER : SCAN");
                    try {
                        this.listener.debug("ResourceChangeNotification scanner thread is waiting for " + this.interval / 1000L);
                        this.wait(this.interval);
                    }
                    catch (InterruptedException e) {
                        this.listener.exception((Exception)new RuntimeException("ResourceChangeNotification ChangeSet scanning thread was interrupted", e));
                    }
                }
                this.listener.info("ResourceChangeNotification scanner has stopped");
            }
        }
    }
}

