/*
 * Decompiled with CFR 0.152.
 */
package org.drools.persistence.memory;

import java.net.Inet4Address;
import java.util.Random;
import javax.transaction.xa.Xid;
import org.drools.persistence.ByteArraySnapshotter;
import org.drools.persistence.DroolsXid;
import org.drools.persistence.Persister;
import org.drools.persistence.Transaction;
import org.drools.persistence.memory.DefaultMemoryObject;
import org.drools.persistence.memory.MemoryObject;
import org.drools.persistence.memory.MemoryXaResource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryPersister<T>
implements ByteArraySnapshotter<T>,
Persister<T> {
    ByteArraySnapshotter<T> snapshotter;
    MemoryObject lastSave;
    MemoryXaResource xaResource;
    String id;
    byte[] localIP = null;
    private int txnUniqueID = 0;
    private int tid = 1;

    public MemoryPersister(ByteArraySnapshotter<T> snapshotter) {
        this(snapshotter, new DefaultMemoryObject());
    }

    public MemoryPersister(ByteArraySnapshotter<T> snapshotter, MemoryObject memoryObject) {
        this.snapshotter = snapshotter;
        this.lastSave = memoryObject;
    }

    @Override
    public MemoryXaResource getXAResource() {
        if (this.xaResource == null) {
            this.xaResource = new MemoryXaResource(this);
        }
        return this.xaResource;
    }

    @Override
    public Transaction getTransaction() {
        return new Transaction(this.getUniqueXID(), this.getXAResource());
    }

    @Override
    public void save() {
        if (this.xaResource != null && this.xaResource.isInTransaction()) {
            throw new RuntimeException("You cannot call a persistence save point while a transaction is open");
        }
        this.lastSave.setData(this.getSnapshot(), this.id);
    }

    @Override
    public void load() {
        if (this.xaResource != null && this.xaResource.isInTransaction()) {
            throw new RuntimeException("You cannot call a persistence save point while a transaction is open");
        }
        this.loadSnapshot(this.lastSave.getData(this.id));
    }

    public boolean isInTransaction() {
        return false;
    }

    public void setLastSave(byte[] lastSave) {
        this.lastSave.setData(lastSave, this.id);
    }

    public byte[] getLastSave() {
        return this.lastSave.getData(this.id);
    }

    @Override
    public byte[] getSnapshot() {
        return this.snapshotter.getSnapshot();
    }

    @Override
    public void loadSnapshot(byte[] bytes) {
        this.snapshotter.loadSnapshot(bytes);
    }

    @Override
    public T getObject() {
        return this.snapshotter.getObject();
    }

    private Xid getUniqueXID() {
        Random rnd = new Random(System.currentTimeMillis());
        ++this.txnUniqueID;
        int txnUID = this.txnUniqueID;
        int tidID = this.tid;
        int randID = rnd.nextInt();
        byte[] gtrid = new byte[64];
        byte[] bqual = new byte[64];
        if (null == this.localIP) {
            try {
                this.localIP = Inet4Address.getLocalHost().getAddress();
            }
            catch (Exception ex) {
                this.localIP = new byte[]{1, 2, 3, 4};
            }
        }
        System.arraycopy(this.localIP, 0, gtrid, 0, 4);
        System.arraycopy(this.localIP, 0, bqual, 0, 4);
        for (int i = 0; i <= 3; ++i) {
            gtrid[i + 4] = (byte)(txnUID % 256);
            bqual[i + 4] = (byte)(txnUID % 256);
            txnUID >>= 8;
            gtrid[i + 8] = (byte)(tidID % 256);
            bqual[i + 8] = (byte)(tidID % 256);
            tidID >>= 8;
            gtrid[i + 12] = (byte)(randID % 256);
            bqual[i + 12] = (byte)(randID % 256);
            randID >>= 8;
        }
        return new DroolsXid(4660, gtrid, bqual);
    }

    @Override
    public String getUniqueId() {
        return this.id;
    }

    @Override
    public void setUniqueId(String id) {
        this.id = id;
    }
}

