/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process.command.impl;

import javax.transaction.xa.XAException;
import org.drools.StatefulSession;
import org.drools.persistence.Transaction;
import org.drools.persistence.memory.MemoryPersister;
import org.drools.persistence.session.StatefulSessionSnapshotter;
import org.drools.process.command.Command;
import org.drools.process.command.impl.AbstractInterceptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionInterceptor
extends AbstractInterceptor {
    @Override
    public <T> T execute(Command<T> command) {
        MemoryPersister<StatefulSession> persister = new MemoryPersister<StatefulSession>(new StatefulSessionSnapshotter(this.getSession()));
        persister.save();
        Transaction transaction = persister.getTransaction();
        try {
            transaction.start();
            T result = super.executeNext(command);
            transaction.commit();
            return result;
        }
        catch (Throwable t) {
            try {
                transaction.rollback();
                throw new RuntimeException("Could not execute command", t);
            }
            catch (XAException e) {
                throw new RuntimeException("Could not rollback transaction", e);
            }
        }
    }
}

