/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.ArrayList;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.RightTuple;
import org.drools.rule.Declaration;
import org.drools.spi.Activation;
import org.drools.spi.Tuple;
import org.drools.util.Entry;
import org.drools.util.LeftTupleList;

public class LeftTuple
implements Tuple,
Entry {
    private static final long serialVersionUID = 400L;
    private int index;
    private InternalFactHandle handle;
    private LeftTuple parent;
    private Activation activation;
    private long recency;
    private int hashCode;
    private RightTuple blocker;
    private LeftTuple blockedPrevious;
    private LeftTuple blockedNext;
    private LeftTuple leftParent;
    private LeftTuple leftParentPrevious;
    private LeftTuple leftParentNext;
    private RightTuple rightParent;
    private LeftTuple rightParentPrevious;
    private LeftTuple rightParentNext;
    private LeftTupleList memory;
    private Entry next;
    private Entry previous;
    private LeftTuple children;
    private LeftTupleSink sink;

    public LeftTuple() {
    }

    public LeftTuple(InternalFactHandle factHandle, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = factHandle;
        this.recency = factHandle.getRecency();
        this.hashCode = this.handle.hashCode();
        if (leftTupleMemoryEnabled) {
            LeftTuple currentFirst = this.handle.getLeftTuple();
            if (currentFirst != null) {
                currentFirst.leftParentPrevious = this;
                this.leftParentNext = currentFirst;
            }
            this.handle.setLeftTuple(this);
        }
        this.sink = sink;
    }

    public LeftTuple(LeftTuple leftTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.index = leftTuple.index;
        this.parent = leftTuple.parent;
        this.recency = leftTuple.recency;
        this.handle = leftTuple.handle;
        this.hashCode = leftTuple.hashCode();
        if (leftTupleMemoryEnabled) {
            this.leftParent = leftTuple;
            this.leftParentNext = leftTuple.children;
            if (this.leftParentNext != null) {
                this.leftParentNext.leftParentPrevious = this;
            }
            this.leftParent.children = this;
        }
        this.sink = sink;
    }

    public LeftTuple(LeftTuple leftTuple, RightTuple rightTuple, LeftTupleSink sink, boolean leftTupleMemoryEnabled) {
        this.handle = rightTuple.getFactHandle();
        this.index = leftTuple.index + 1;
        this.parent = leftTuple;
        this.recency = leftTuple.recency + this.handle.getRecency();
        this.hashCode = leftTuple.hashCode ^ this.handle.hashCode() * 31;
        if (leftTupleMemoryEnabled) {
            this.rightParent = rightTuple;
            this.rightParentNext = this.rightParent.getBetaChildren();
            if (this.rightParentNext != null) {
                this.rightParentNext.rightParentPrevious = this;
            }
            this.rightParent.setBetaChildren(this);
            this.leftParent = leftTuple;
            this.leftParentNext = leftTuple.children;
            if (this.leftParentNext != null) {
                this.leftParentNext.leftParentPrevious = this;
            }
            this.leftParent.children = this;
        }
        this.sink = sink;
    }

    public void unlinkFromLeftParent() {
        LeftTuple previous = this.leftParentPrevious;
        LeftTuple next = this.leftParentNext;
        if (previous != null && next != null) {
            this.leftParentPrevious.leftParentNext = this.leftParentNext;
            this.leftParentNext.leftParentPrevious = this.leftParentPrevious;
        } else if (next != null) {
            if (this.leftParent != null) {
                this.leftParent.children = this.leftParentNext;
            } else {
                this.handle.setLeftTuple(this.leftParentNext);
            }
            this.leftParentNext.leftParentPrevious = null;
        } else if (previous != null) {
            this.leftParentPrevious.leftParentNext = null;
        } else if (this.leftParent != null) {
            this.leftParent.children = null;
        } else {
            this.handle.setLeftTuple(null);
        }
        this.leftParent = null;
        this.leftParentPrevious = null;
        this.leftParentNext = null;
        this.blocker = null;
    }

    public void unlinkFromRightParent() {
        if (this.rightParent == null) {
            return;
        }
        LeftTuple previous = this.rightParentPrevious;
        LeftTuple next = this.rightParentNext;
        if (previous != null && next != null) {
            this.rightParentPrevious.rightParentNext = this.rightParentNext;
            this.rightParentNext.rightParentPrevious = this.rightParentPrevious;
        } else if (next != null) {
            this.rightParent.setBetaChildren(this.rightParentNext);
            this.rightParentNext.rightParentPrevious = null;
        } else if (previous != null) {
            this.rightParentPrevious.rightParentNext = null;
        } else if (this.rightParent != null) {
            this.rightParent.setBetaChildren(null);
        }
        this.blocker = null;
        this.rightParent = null;
        this.rightParentPrevious = null;
        this.rightParentNext = null;
    }

    public int getIndex() {
        return this.index;
    }

    public LeftTupleSink getLeftTupleSink() {
        return this.sink;
    }

    public LeftTuple getLeftParent() {
        return this.leftParent;
    }

    public void setLeftParent(LeftTuple leftParent) {
        this.leftParent = leftParent;
    }

    public LeftTuple getLeftParentPrevious() {
        return this.leftParentPrevious;
    }

    public void setLeftParentPrevious(LeftTuple leftParentLeft) {
        this.leftParentPrevious = leftParentLeft;
    }

    public LeftTuple getLeftParentNext() {
        return this.leftParentNext;
    }

    public void setLeftParentNext(LeftTuple leftParentright) {
        this.leftParentNext = leftParentright;
    }

    public RightTuple getRightParent() {
        return this.rightParent;
    }

    public void setRightParent(RightTuple rightParent) {
        this.rightParent = rightParent;
    }

    public LeftTuple getRightParentPrevious() {
        return this.rightParentPrevious;
    }

    public void setRightParentPrevious(LeftTuple rightParentLeft) {
        this.rightParentPrevious = rightParentLeft;
    }

    public LeftTuple getRightParentNext() {
        return this.rightParentNext;
    }

    public void setRightParentNext(LeftTuple rightParentRight) {
        this.rightParentNext = rightParentRight;
    }

    public void setBetaChildren(LeftTuple leftTuple) {
        this.children = leftTuple;
    }

    public LeftTuple getBetaChildren() {
        return this.children;
    }

    public InternalFactHandle get(int index) {
        LeftTuple entry = this;
        while (entry.index != index) {
            entry = entry.parent;
        }
        return entry.handle;
    }

    public LeftTupleList getMemory() {
        return this.memory;
    }

    public void setMemory(LeftTupleList memory) {
        this.memory = memory;
    }

    public Entry getPrevious() {
        return this.previous;
    }

    public void setPrevious(Entry previous) {
        this.previous = previous;
    }

    public void setNext(Entry next) {
        this.next = next;
    }

    public Entry getNext() {
        return this.next;
    }

    public InternalFactHandle getLastHandle() {
        return this.handle;
    }

    public InternalFactHandle get(Declaration declaration) {
        return this.get(declaration.getPattern().getOffset());
    }

    public Activation getActivation() {
        return this.activation;
    }

    public InternalFactHandle[] getFactHandles() {
        ArrayList<InternalFactHandle> list = new ArrayList<InternalFactHandle>();
        LeftTuple entry = this;
        while (entry != null) {
            list.add(entry.handle);
            entry = entry.parent;
        }
        return list.toArray(new InternalFactHandle[list.size()]);
    }

    public long getRecency() {
        return this.recency;
    }

    public void setBlocker(RightTuple blocker) {
        this.blocker = blocker;
    }

    public RightTuple getBlocker() {
        return this.blocker;
    }

    public LeftTuple getBlockedPrevious() {
        return this.blockedPrevious;
    }

    public void setBlockedPrevious(LeftTuple blockerPrevious) {
        this.blockedPrevious = blockerPrevious;
    }

    public LeftTuple getBlockedNext() {
        return this.blockedNext;
    }

    public void setBlockedNext(LeftTuple blockerNext) {
        this.blockedNext = blockerNext;
    }

    public void setActivation(Activation activation) {
        this.activation = activation;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        LeftTuple entry = this;
        while (entry != null) {
            buffer.append(entry.handle + "\n");
            entry = entry.parent;
        }
        return buffer.toString();
    }

    public boolean equals(LeftTuple other) {
        if (other == this) {
            return true;
        }
        if (this.hashCode != other.hashCode) {
            return false;
        }
        if (this.handle != other.handle) {
            return false;
        }
        if (this.parent == null) {
            return other.parent == null;
        }
        return this.parent.equals(other.parent);
    }

    public boolean equals(Object object) {
        return this.equals((LeftTuple)object);
    }

    public int size() {
        return this.index + 1;
    }

    public LeftTuple getSubTuple(int elements) {
        LeftTuple entry = this;
        if (elements < this.size()) {
            int lastindex = elements - 1;
            while (entry.index != lastindex) {
                entry = entry.parent;
            }
        }
        return entry;
    }

    public Object[] toObjectArray() {
        Object[] objects = new Object[this.index + 1];
        LeftTuple entry = this;
        while (entry != null) {
            Object object;
            objects[entry.index] = object = entry.getLastHandle().getObject();
            entry = entry.parent;
        }
        return objects;
    }

    public LeftTuple getParent() {
        return this.parent;
    }
}

