/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectSink;
import org.drools.spi.PropagationContext;

public class PartitionTaskManager {
    private PartitionTask task = null;
    private AtomicReference<ExecutorService> pool = new AtomicReference();

    public PartitionTaskManager(InternalWorkingMemory workingMemory) {
        this.task = new PartitionTask(workingMemory);
    }

    public void setPool(ExecutorService pool) {
        if (pool != null && this.pool.compareAndSet(null, pool)) {
            int size = this.task.queue.size();
            for (int i = 0; i < size; ++i) {
                this.pool.get().execute(this.task);
            }
        } else {
            this.pool.set(pool);
        }
    }

    public boolean enqueue(Action action) {
        boolean result = this.task.enqueue(action);
        assert (result) : "result must be true";
        ExecutorService service = this.pool.get();
        if (service != null) {
            service.execute(this.task);
        }
        return result;
    }

    public static class LeftTupleRetractAction
    extends LeftTupleAction {
        public LeftTupleRetractAction() {
        }

        public LeftTupleRetractAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink) {
            super(leftTuple, context, sink);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertLeftTuple(this.leftTuple, this.context, workingMemory);
        }
    }

    public static class LeftTupleAssertAction
    extends LeftTupleAction {
        public LeftTupleAssertAction() {
        }

        public LeftTupleAssertAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink) {
            super(leftTuple, context, sink);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertLeftTuple(this.leftTuple, this.context, workingMemory);
        }
    }

    public static abstract class LeftTupleAction
    implements Action,
    Externalizable {
        protected LeftTuple leftTuple;
        protected PropagationContext context;
        protected LeftTupleSink sink;

        public LeftTupleAction() {
        }

        public LeftTupleAction(LeftTuple leftTuple, PropagationContext context, LeftTupleSink sink) {
            this.leftTuple = leftTuple;
            this.context = context;
            this.sink = sink;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.leftTuple = (LeftTuple)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.sink = (LeftTupleSink)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.leftTuple);
            out.writeObject(this.context);
            out.writeObject(this.sink);
        }

        public abstract void execute(InternalWorkingMemory var1);
    }

    public static class FactAssertAction
    extends FactAction {
        private static final long serialVersionUID = -8478488926430845209L;

        FactAssertAction() {
        }

        public FactAssertAction(InternalFactHandle handle, PropagationContext context, ObjectSink sink) {
            super(handle, context, sink);
        }

        public void execute(InternalWorkingMemory workingMemory) {
            this.sink.assertObject(this.handle, this.context, workingMemory);
        }
    }

    public static abstract class FactAction
    implements Action,
    Externalizable {
        protected InternalFactHandle handle;
        protected PropagationContext context;
        protected ObjectSink sink;

        public FactAction() {
        }

        public FactAction(InternalFactHandle handle, PropagationContext context, ObjectSink sink) {
            this.handle = handle;
            this.context = context;
            this.sink = sink;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.handle = (InternalFactHandle)in.readObject();
            this.context = (PropagationContext)in.readObject();
            this.sink = (ObjectSink)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.handle);
            out.writeObject(this.context);
            out.writeObject(this.sink);
        }

        public abstract void execute(InternalWorkingMemory var1);
    }

    public static interface Action
    extends Externalizable {
        public void execute(InternalWorkingMemory var1);
    }

    public static class PartitionTask
    implements Runnable {
        private Queue<Action> queue = new ConcurrentLinkedQueue<Action>();
        private InternalWorkingMemory workingMemory;

        public PartitionTask(InternalWorkingMemory workingMemory) {
            this.workingMemory = workingMemory;
        }

        public void run() {
            Action action = this.queue.poll();
            if (action != null) {
                action.execute(this.workingMemory);
            }
        }

        public boolean enqueue(Action action) {
            return this.queue.add(action);
        }
    }
}

