/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.drools.RuntimeDroolsException;
import org.drools.common.BaseNode;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DoubleBetaConstraints;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.QuadroupleBetaConstraints;
import org.drools.common.RuleBasePartitionId;
import org.drools.common.SingleBetaConstraints;
import org.drools.common.TripleBetaConstraints;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.reteoo.builder.ReteooComponentBuilder;
import org.drools.rule.AbstractCompositeConstraint;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.ObjectType;
import org.drools.time.Interval;
import org.drools.time.TemporalDependencyMatrix;
import org.drools.time.TimeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BuildUtils {
    private final Map<Class<?>, ReteooComponentBuilder> componentBuilders = new HashMap();

    public void addBuilder(Class<?> target, ReteooComponentBuilder builder) {
        this.componentBuilders.put(target, builder);
    }

    public ReteooComponentBuilder getBuilderFor(RuleConditionElement target) {
        return this.componentBuilders.get(target.getClass());
    }

    public BaseNode attachNode(BuildContext context, BaseNode candidate) {
        BaseNode node = null;
        RuleBasePartitionId partition = null;
        if (candidate instanceof EntryPointNode) {
            EntryPointNode epn = context.getRuleBase().getRete().getEntryPointNode(((EntryPointNode)candidate).getEntryPoint());
            if (epn != null) {
                node = epn;
            }
            partition = RuleBasePartitionId.MAIN_PARTITION;
        } else if (candidate instanceof ObjectTypeNode) {
            ObjectTypeNode otn = (ObjectTypeNode)candidate;
            Map<ObjectType, ObjectTypeNode> map = context.getRuleBase().getRete().getObjectTypeNodes(context.getCurrentEntryPoint());
            if (map != null && (otn = map.get(otn.getObjectType())) != null) {
                otn.setExpirationOffset(Math.max(otn.getExpirationOffset(), ((ObjectTypeNode)candidate).getExpirationOffset()));
                node = otn;
            }
            partition = RuleBasePartitionId.MAIN_PARTITION;
        } else if (this.isSharingEnabledForNode(context, candidate)) {
            if (context.getTupleSource() != null && candidate instanceof LeftTupleSink) {
                node = context.getTupleSource().getSinkPropagator().getMatchingNode(candidate);
            } else if (context.getObjectSource() != null && candidate instanceof ObjectSink) {
                node = context.getObjectSource().getSinkPropagator().getMatchingNode(candidate);
            } else {
                throw new RuntimeDroolsException("This is a bug on node sharing verification. Please report to development team.");
            }
            if (node != null) {
                context.releaseId(candidate.getId());
            }
        }
        if (node == null) {
            node = candidate;
            if (partition == null) {
                if (context.getPartitionId() == null) {
                    context.setPartitionId(context.getRuleBase().createNewPartitionId());
                }
                partition = context.getPartitionId();
            }
            node.setPartitionId(partition);
            if (context.getWorkingMemories().length == 0) {
                node.attach();
            } else {
                node.attach(context.getWorkingMemories());
            }
            context.getNodes().add(node);
        }
        return node;
    }

    private boolean isSharingEnabledForNode(BuildContext context, BaseNode node) {
        if (node instanceof LeftTupleSource) {
            return context.getRuleBase().getConfiguration().isShareBetaNodes();
        }
        if (node instanceof ObjectSource) {
            return context.getRuleBase().getConfiguration().isShareAlphaNodes();
        }
        return false;
    }

    public BetaConstraints createBetaNodeConstraint(BuildContext context, List<BetaNodeFieldConstraint> list, boolean disableIndexing) {
        BetaConstraints constraints;
        switch (list.size()) {
            case 0: {
                constraints = EmptyBetaConstraints.getInstance();
                break;
            }
            case 1: {
                constraints = new SingleBetaConstraints(list.get(0), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 2: {
                constraints = new DoubleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 3: {
                constraints = new TripleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            case 4: {
                constraints = new QuadroupleBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
                break;
            }
            default: {
                constraints = new DefaultBetaConstraints(list.toArray(new BetaNodeFieldConstraint[list.size()]), context.getRuleBase().getConfiguration(), disableIndexing);
            }
        }
        return constraints;
    }

    public void checkUnboundDeclarations(BuildContext context, Declaration[] declarations) throws InvalidPatternException {
        ArrayList<String> list = new ArrayList<String>();
        int length = declarations.length;
        for (int i = 0; i < length; ++i) {
            boolean resolved = false;
            ListIterator<RuleConditionElement> it = context.stackIterator();
            while (it.hasPrevious()) {
                RuleConditionElement rce = it.previous();
                Declaration decl = rce.resolveDeclaration(declarations[i].getIdentifier());
                if (decl == null || decl.getPattern().getOffset() > declarations[i].getPattern().getOffset()) continue;
                resolved = true;
                break;
            }
            if (resolved) continue;
            list.add(declarations[i].getIdentifier());
        }
        if (list.size() != 0) {
            StringBuffer buffer = new StringBuffer();
            buffer.append((String)list.get(0));
            int size = list.size();
            for (int i = 1; i < size; ++i) {
                buffer.append(", " + (String)list.get(i));
            }
            throw new InvalidPatternException("Required Declarations not bound: '" + buffer + "'");
        }
    }

    public TemporalDependencyMatrix calculateTemporalDistance(GroupElement groupElement) {
        ArrayList<Pattern> events = new ArrayList<Pattern>();
        this.selectAllEventPatterns(events, groupElement);
        int size = events.size();
        if (size >= 1) {
            Interval[][] result;
            Interval[][] source = new Interval[size][];
            for (int row = 0; row < size; ++row) {
                source[row] = new Interval[size];
                for (int col = 0; col < size; ++col) {
                    source[row][col] = row == col ? new Interval(0L, 0L) : new Interval(Long.MIN_VALUE, Long.MAX_VALUE);
                }
            }
            if (size > 1) {
                ArrayList<Declaration> declarations = new ArrayList<Declaration>();
                int eventIndex = 0;
                for (Pattern event : events) {
                    declarations.add(event.getDeclaration());
                    HashMap<Declaration, Interval> temporal = new HashMap<Declaration, Interval>();
                    this.gatherTemporalRelationships(event.getConstraints(), temporal);
                    for (Map.Entry entry : temporal.entrySet()) {
                        int targetIndex = declarations.indexOf(entry.getKey());
                        Interval interval = (Interval)entry.getValue();
                        source[targetIndex][eventIndex].intersect(interval);
                        source[eventIndex][targetIndex].intersect(new Interval(-interval.getUpperBound(), -interval.getLowerBound()));
                    }
                    ++eventIndex;
                }
                result = TimeUtils.calculateTemporalDistance(source);
            } else {
                result = source;
            }
            TemporalDependencyMatrix matrix = new TemporalDependencyMatrix(result, events);
            return matrix;
        }
        return null;
    }

    private void gatherTemporalRelationships(List<?> constraints, Map<Declaration, Interval> temporal) {
        for (Object obj : constraints) {
            if (obj instanceof VariableConstraint) {
                Declaration target;
                VariableConstraint constr = (VariableConstraint)obj;
                if (!constr.isTemporal() || !(target = constr.getRequiredDeclarations()[0]).isPatternDeclaration() || !target.getPattern().getObjectType().isEvent()) continue;
                Interval interval = temporal.get(target);
                if (interval == null) {
                    interval = constr.getInterval();
                    temporal.put(target, interval);
                    continue;
                }
                interval.intersect(constr.getInterval());
                continue;
            }
            if (!(obj instanceof AbstractCompositeConstraint)) continue;
            this.gatherTemporalRelationships(Arrays.asList(((AbstractCompositeConstraint)obj).getBetaConstraints()), temporal);
        }
    }

    private void selectAllEventPatterns(List<Pattern> events, RuleConditionElement rce) {
        Pattern p;
        if (rce instanceof Pattern && (p = (Pattern)rce).getObjectType().isEvent()) {
            events.add(p);
        }
        for (RuleConditionElement child : rce.getNestedElements()) {
            this.selectAllEventPatterns(events, child);
        }
    }
}

