/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.definition.process.Process;
import org.drools.facttemplates.FactTemplate;
import org.drools.rule.DialectRuntimeRegistry;
import org.drools.rule.FactType;
import org.drools.rule.Function;
import org.drools.rule.ImportDeclaration;
import org.drools.rule.InvalidRulePackage;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Package
implements Externalizable {
    private static final long serialVersionUID = 400L;
    private String name;
    private Map rules;
    private Map<String, ImportDeclaration> imports;
    private Map<String, Function> functions;
    private Set staticImports;
    private Map<String, String> globals;
    private Map factTemplates;
    private Map<String, Process> ruleFlows;
    private DialectRuntimeRegistry dialectRuntimeRegistry;
    private Map<String, TypeDeclaration> typeDeclarations;
    private ClassFieldAccessorStore classFieldAccessorStore;
    private boolean valid = true;
    private String errorSummary;

    public Package() {
    }

    public Package(String name) {
        this.name = name;
        this.imports = new HashMap<String, ImportDeclaration>();
        this.typeDeclarations = new HashMap<String, TypeDeclaration>();
        this.staticImports = Collections.EMPTY_SET;
        this.rules = new LinkedHashMap();
        this.ruleFlows = Collections.EMPTY_MAP;
        this.globals = Collections.EMPTY_MAP;
        this.factTemplates = Collections.EMPTY_MAP;
        this.functions = Collections.EMPTY_MAP;
        this.dialectRuntimeRegistry = new DialectRuntimeRegistry();
        this.classFieldAccessorStore = new ClassFieldAccessorStore();
    }

    @Override
    public void writeExternal(ObjectOutput stream) throws IOException {
        ObjectOutput out;
        boolean isDroolsStream = stream instanceof DroolsObjectOutputStream;
        ByteArrayOutputStream bytes = null;
        if (isDroolsStream) {
            out = stream;
        } else {
            bytes = new ByteArrayOutputStream();
            out = new DroolsObjectOutputStream(bytes);
        }
        out.writeObject(this.dialectRuntimeRegistry);
        out.writeObject(this.typeDeclarations);
        out.writeObject(this.name);
        out.writeObject(this.imports);
        out.writeObject(this.staticImports);
        out.writeObject(this.functions);
        out.writeObject(this.factTemplates);
        out.writeObject(this.ruleFlows);
        out.writeObject(this.globals);
        out.writeBoolean(this.valid);
        out.writeObject(this.rules);
        out.writeObject(this.classFieldAccessorStore);
        if (!isDroolsStream) {
            bytes.flush();
            bytes.close();
            stream.writeObject(bytes.toByteArray());
        }
    }

    @Override
    public void readExternal(ObjectInput stream) throws IOException, ClassNotFoundException {
        boolean isDroolsStream = stream instanceof DroolsObjectInputStream;
        DroolsObjectInputStream in = isDroolsStream ? (DroolsObjectInputStream)stream : new DroolsObjectInputStream(new ByteArrayInputStream((byte[])stream.readObject()));
        this.dialectRuntimeRegistry = (DialectRuntimeRegistry)in.readObject();
        this.typeDeclarations = (Map)in.readObject();
        this.name = (String)in.readObject();
        this.imports = (Map)in.readObject();
        this.staticImports = (Set)in.readObject();
        this.functions = (Map)in.readObject();
        this.factTemplates = (Map)in.readObject();
        this.ruleFlows = (Map)in.readObject();
        this.globals = (Map)in.readObject();
        this.valid = in.readBoolean();
        this.rules = (Map)in.readObject();
        this.classFieldAccessorStore = (ClassFieldAccessorStore)in.readObject();
        if (!isDroolsStream) {
            in.close();
        }
    }

    public String getName() {
        return this.name;
    }

    public DialectRuntimeRegistry getDialectRuntimeRegistry() {
        return this.dialectRuntimeRegistry;
    }

    public void addImport(ImportDeclaration importDecl) {
        this.imports.put(importDecl.getTarget(), importDecl);
    }

    public void removeImport(String importEntry) {
        this.imports.remove(importEntry);
    }

    public Map<String, ImportDeclaration> getImports() {
        return this.imports;
    }

    public void addTypeDeclaration(TypeDeclaration typeDecl) {
        this.typeDeclarations.put(typeDecl.getTypeName(), typeDecl);
    }

    public void removeTypeDeclaration(String type) {
        this.typeDeclarations.remove(type);
    }

    public Map<String, TypeDeclaration> getTypeDeclarations() {
        return this.typeDeclarations;
    }

    public TypeDeclaration getTypeDeclaration(String type) {
        return this.typeDeclarations.get(type);
    }

    public void addStaticImport(String functionImport) {
        if (this.staticImports == Collections.EMPTY_SET) {
            this.staticImports = new HashSet(2);
        }
        this.staticImports.add(functionImport);
    }

    public void addFunction(Function function) {
        if (this.functions == Collections.EMPTY_MAP) {
            this.functions = new HashMap<String, Function>(1);
        }
        this.functions.put(function.getName(), function);
        this.dialectRuntimeRegistry.getDialectData(function.getDialect()).setDirty(true);
    }

    public Map<String, Function> getFunctions() {
        return this.functions;
    }

    public void removeFunctionImport(String functionImport) {
        this.staticImports.remove(functionImport);
    }

    public Set getStaticImports() {
        return this.staticImports;
    }

    public void addGlobal(String identifier, Class clazz) {
        this.addGlobal(identifier, clazz.getName());
    }

    public void addGlobal(String identifier, String className) {
        if (this.globals == Collections.EMPTY_MAP) {
            this.globals = new HashMap<String, String>(1);
        }
        this.globals.put(identifier, className);
    }

    public void removeGlobal(String identifier) {
        this.globals.remove(identifier);
    }

    public Map<String, String> getGlobals() {
        return this.globals;
    }

    public void removeFunction(String functionName) {
        Function function = this.functions.remove(functionName);
        if (function != null) {
            this.dialectRuntimeRegistry.removeFunction(this, function);
        }
    }

    public FactTemplate getFactTemplate(String name) {
        return (FactTemplate)this.factTemplates.get(name);
    }

    public void addFactTemplate(FactTemplate factTemplate) {
        if (this.factTemplates == Collections.EMPTY_MAP) {
            this.factTemplates = new HashMap(1);
        }
        this.factTemplates.put(factTemplate.getName(), factTemplate);
    }

    public void addRule(Rule rule) {
        String name = rule.getName();
        this.rules.put(name, rule);
        rule.setLoadOrder(this.rules.size());
    }

    public void addProcess(Process process) {
        if (this.ruleFlows == Collections.EMPTY_MAP) {
            this.ruleFlows = new HashMap<String, Process>();
        }
        this.ruleFlows.put(process.getId(), process);
    }

    public Map<String, Process> getRuleFlows() {
        return this.ruleFlows;
    }

    public void removeRuleFlow(String id) {
        if (!this.ruleFlows.containsKey(id)) {
            throw new IllegalArgumentException("The rule flow with id [" + id + "] is not part of this package.");
        }
        this.ruleFlows.remove(id);
    }

    public void removeRule(Rule rule) {
        this.rules.remove(rule.getName());
        this.dialectRuntimeRegistry.removeRule(this, rule);
    }

    public Rule getRule(String name) {
        return (Rule)this.rules.get(name);
    }

    public Rule[] getRules() {
        return this.rules.values().toArray(new Rule[this.rules.size()]);
    }

    public String toString() {
        return "[Package name=" + this.name + "]";
    }

    public void setError(String summary) {
        this.errorSummary = summary;
        this.valid = false;
    }

    public boolean isValid() {
        return this.valid;
    }

    public void checkValidity() {
        if (!this.isValid()) {
            throw new InvalidRulePackage(this.getErrorSummary());
        }
    }

    public String getErrorSummary() {
        return this.errorSummary;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof Package)) {
            return false;
        }
        Package other = (Package)object;
        return this.name.equals(other.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public boolean isEvent(Class clazz) {
        if (clazz == null) {
            return false;
        }
        for (TypeDeclaration type : this.typeDeclarations.values()) {
            if (!type.matches(clazz) || type.getRole() != TypeDeclaration.Role.EVENT) continue;
            return true;
        }
        return false;
    }

    public void clear() {
        this.rules.clear();
        this.dialectRuntimeRegistry.clear();
        this.ruleFlows.clear();
        this.imports.clear();
        this.functions.clear();
        this.staticImports.clear();
        this.globals.clear();
        this.factTemplates.clear();
        this.typeDeclarations.clear();
    }

    public FactType getFactType(String typeName) {
        if (this.name != null && !typeName.startsWith(this.name)) {
            return null;
        }
        String key = this.name == null ? typeName : typeName.substring(this.name.length() + 1);
        TypeDeclaration decl = this.typeDeclarations.get(key);
        return decl != null ? decl.getTypeClassDef() : null;
    }

    public ClassFieldAccessorStore getClassFieldAccessorStore() {
        return this.classFieldAccessorStore;
    }

    public void setClassFieldAccessorCache(ClassFieldAccessorCache classFieldAccessorCache) {
        this.classFieldAccessorStore.setClassFieldAccessorCache(classFieldAccessorCache);
    }
}

