/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.agent.AgentEventListener;
import org.drools.agent.IHttpClient;
import org.drools.agent.LastUpdatedPing;
import org.drools.agent.MockListener;
import org.drools.agent.PackageChangeInfo;
import org.drools.agent.PackageProvider;
import org.drools.agent.RuleBaseAssemblerTest;
import org.drools.agent.URLScanner;
import org.drools.common.DroolsObjectInputStream;
import org.drools.definition.KnowledgePackage;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.rule.Package;

public class URLScannerTest
extends TestCase {
    public void testFileURLCache() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        String url = "http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST";
        String fileName = URLEncoder.encode(url, "UTF-8");
        File f = new File(dir, fileName);
        Package p = new Package("x");
        RuleBaseAssemblerTest.writePackage(p, f);
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new FileInputStream(f));
        Package p_ = (Package)in.readObject();
        in.close();
        URLScannerTest.assertEquals((String)"x", (String)p_.getName());
    }

    public void testFileURLCacheWithKnowledgePackage() throws Exception {
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        String url = "http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST";
        String fileName = URLEncoder.encode(url, "UTF-8");
        File f = new File(dir, fileName);
        KnowledgePackageImp kpackage = new KnowledgePackageImp(new Package("x"));
        RuleBaseAssemblerTest.writePackage((KnowledgePackage)kpackage, f);
        DroolsObjectInputStream in = new DroolsObjectInputStream((InputStream)new FileInputStream(f));
        KnowledgePackage p_ = (KnowledgePackage)in.readObject();
        in.close();
        URLScannerTest.assertEquals((String)"x", (String)p_.getName());
    }

    public void testGetFiles() throws Exception {
        URL u1 = new URL("http://localhost:8080/foo/bar.bar/packages/IMINYRURL/LATEST");
        URL u2 = new URL("http://localhost:8080/foo/bar.bar/packages/IMINYRURL/PROD");
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        File[] result = scan.getFiles(new URL[]{u1, u2}, dir);
        URLScannerTest.assertEquals((int)2, (int)result.length);
        URLScannerTest.assertEquals((String)dir.getPath(), (String)result[0].getParent());
        File f1 = result[0];
        File f2 = result[1];
        URLScannerTest.assertEquals((String)"http%3A%2F%2Flocalhost%3A8080%2Ffoo%2Fbar.bar%2Fpackages%2FIMINYRURL%2FLATEST.pkg", (String)f1.getName());
        URLScannerTest.assertEquals((String)"http%3A%2F%2Flocalhost%3A8080%2Ffoo%2Fbar.bar%2Fpackages%2FIMINYRURL%2FPROD.pkg", (String)f2.getName());
    }

    public void testConfig() throws Exception {
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        URLScannerTest.assertNotNull((Object)scan.lastUpdated);
        URLScannerTest.assertEquals((int)2, (int)scan.urls.length);
        URLScannerTest.assertEquals((String)"http://goo.ber", (String)scan.urls[0].toExternalForm());
        URLScannerTest.assertEquals((String)"http://wee.waa", (String)scan.urls[1].toExternalForm());
        URLScannerTest.assertNotNull((Object)scan.localCacheFileScanner);
        URLScannerTest.assertEquals((int)2, (int)scan.localCacheFileScanner.files.length);
        URLScannerTest.assertEquals((String)"http%3A%2F%2Fgoo.ber.pkg", (String)scan.localCacheFileScanner.files[0].getName());
        URLScannerTest.assertEquals((String)"http%3A%2F%2Fwee.waa.pkg", (String)scan.localCacheFileScanner.files[1].getName());
    }

    public void testLastUpdatedError() {
        LastUpdatedPing ping = new LastUpdatedPing();
        URLScannerTest.assertTrue((boolean)ping.isError());
        ping.responseMessage = "ABC";
        ping.lastUpdated = 42L;
        URLScannerTest.assertTrue((boolean)ping.isError());
        ping.responseMessage = "200 OK";
        URLScannerTest.assertFalse((boolean)ping.isError());
    }

    public void testUpdateNoLocalCache() throws Exception {
        URLScanner scan = new URLScanner();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        int numfiles = dir.list().length;
        Properties config = new Properties();
        config.setProperty("url", "http://goo2.ber http://wee2.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 123L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url) throws IOException {
                if (url.toExternalForm().equals("http://goo2.ber")) {
                    return new Package("goo2.ber");
                }
                return new Package("wee2.waa");
            }
        };
        URLScannerTest.assertNull((Object)scan.localCacheFileScanner);
        URLScannerTest.assertNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        AgentEventListener list = this.getNilListener();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)false, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)list);
        URLScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        this.assertExists(new String[]{"goo2.ber", "wee2.waa"}, rb.getPackages());
        URLScannerTest.assertEquals((int)numfiles, (int)dir.list().length);
    }

    private AgentEventListener getNilListener() {
        return new MockListener();
    }

    private void assertExists(String[] names, Package[] packages) {
        for (int i = 0; i < packages.length; ++i) {
            String name = packages[i].getName();
            int matches = 0;
            for (int j = 0; j < names.length; ++j) {
                if (!name.equals(names[j])) continue;
                ++matches;
            }
            URLScannerTest.assertEquals((String)("Should only have one package named " + name), (int)1, (int)matches);
        }
    }

    public void testUpdateWithLocalCache() {
        URLScanner scan = new URLScanner();
        scan.listener = new MockListener();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 123L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url) throws IOException {
                if (url.toExternalForm().equals("http://goo.ber")) {
                    return new Package("goo.ber");
                }
                return new Package("wee.waa");
            }
        };
        URLScannerTest.assertNotNull((Object)scan.localCacheFileScanner);
        URLScannerTest.assertNotNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)false, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        URLScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        URLScannerTest.assertTrue(("goo.ber".equals(rb.getPackages()[0].getName()) || "goo.ber".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        URLScannerTest.assertTrue(("wee.waa".equals(rb.getPackages()[0].getName()) || "wee.waa".equals(rb.getPackages()[1].getName()) ? 1 : 0) != 0);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                if (url.toExternalForm().equals("http://wee.waa")) {
                    ping.lastUpdated = -1L;
                    ping.responseMessage = "XXX";
                } else {
                    ping.lastUpdated = 123L;
                    ping.responseMessage = "200 OK";
                }
                return ping;
            }

            public Package fetchPackage(URL url) throws IOException {
                throw new IOException("poo");
            }
        };
        rb = RuleBaseFactory.newRuleBase();
        URLScannerTest.assertEquals((int)0, (int)rb.getPackages().length);
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        URLScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
        final boolean[] fetchCalled = new boolean[]{false};
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                LastUpdatedPing ping = new LastUpdatedPing();
                ping.lastUpdated = 1234L;
                ping.responseMessage = "200 OK";
                return ping;
            }

            public Package fetchPackage(URL url) throws IOException {
                fetchCalled[0] = true;
                throw new IOException("poo");
            }
        };
        PackageChangeInfo changes = scan.loadPackageChanges();
        URLScannerTest.assertEquals((int)0, (int)changes.getChangedPackages().size());
        URLScannerTest.assertEquals((boolean)true, (boolean)fetchCalled[0]);
        URLScannerTest.assertEquals((int)2, (int)((MockListener)scan.listener).exceptions.size());
    }

    public void testColdStartWithError() throws Exception {
        URLScanner scan = new URLScanner();
        scan.listener = new MockListener();
        File dir = RuleBaseAssemblerTest.getTempDirectory();
        Package p1 = new Package("goo.ber");
        Package p2 = new Package("wee.waa");
        File f1 = URLScanner.getLocalCacheFileForURL((File)dir, (URL)new URL("http://goo.ber"));
        File f2 = URLScanner.getLocalCacheFileForURL((File)dir, (URL)new URL("http://wee.waa"));
        RuleBaseAssemblerTest.writePackage(p1, f1);
        RuleBaseAssemblerTest.writePackage(p2, f2);
        Properties config = new Properties();
        config.setProperty("localCacheDir", dir.getPath());
        config.setProperty("url", "http://goo.ber http://wee.waa");
        scan.configure(config);
        scan.httpClient = new IHttpClient(){

            public LastUpdatedPing checkLastUpdated(URL url) throws IOException {
                throw new IOException();
            }

            public Package fetchPackage(URL url) throws IOException {
                throw new IOException();
            }
        };
        URLScannerTest.assertNotNull((Object)scan.localCacheFileScanner);
        URLScannerTest.assertNotNull((Object)scan.localCacheDir);
        RuleBase rb = RuleBaseFactory.newRuleBase();
        PackageProvider.applyChanges((RuleBase)rb, (boolean)true, (Collection)scan.loadPackageChanges().getChangedPackages(), (AgentEventListener)this.getNilListener());
        URLScannerTest.assertEquals((int)2, (int)rb.getPackages().length);
    }
}

