/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.util.HashSet;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FirstClass;
import org.drools.Person;
import org.drools.SecondClass;
import org.drools.base.ClassTypeResolver;

public class ClassTypeResolverTest
extends TestCase {
    public void testResolvePrimtiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(Boolean.TYPE, (Object)resolver.resolveType("boolean"));
        ClassTypeResolverTest.assertEquals(Double.TYPE, (Object)resolver.resolveType("double"));
        ClassTypeResolverTest.assertEquals(Float.TYPE, (Object)resolver.resolveType("float"));
        ClassTypeResolverTest.assertEquals(Integer.TYPE, (Object)resolver.resolveType("int"));
        ClassTypeResolverTest.assertEquals(Character.TYPE, (Object)resolver.resolveType("char"));
        ClassTypeResolverTest.assertEquals(Long.TYPE, (Object)resolver.resolveType("long"));
        ClassTypeResolverTest.assertEquals(Byte.TYPE, (Object)resolver.resolveType("byte"));
        ClassTypeResolverTest.assertEquals(Short.TYPE, (Object)resolver.resolveType("short"));
    }

    public void testResolveArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(boolean[].class, (Object)resolver.resolveType("boolean[]"));
        ClassTypeResolverTest.assertEquals(double[].class, (Object)resolver.resolveType("double[]"));
        ClassTypeResolverTest.assertEquals(float[].class, (Object)resolver.resolveType("float[]"));
        ClassTypeResolverTest.assertEquals(int[].class, (Object)resolver.resolveType("int[]"));
        ClassTypeResolverTest.assertEquals(char[].class, (Object)resolver.resolveType("char[]"));
        ClassTypeResolverTest.assertEquals(long[].class, (Object)resolver.resolveType("long[]"));
        ClassTypeResolverTest.assertEquals(byte[].class, (Object)resolver.resolveType("byte[]"));
        ClassTypeResolverTest.assertEquals(short[].class, (Object)resolver.resolveType("short[]"));
    }

    public void testResolveMultidimensionnalArrayOfPrimitiveTypes() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(int[][].class, (Object)resolver.resolveType("int[][]"));
        ClassTypeResolverTest.assertEquals(int[][][].class, (Object)resolver.resolveType("int[][][]"));
        ClassTypeResolverTest.assertEquals(int[][][][].class, (Object)resolver.resolveType("int[][][][]"));
    }

    public void testResolveObjectNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("String"));
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        try {
            ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
            ClassTypeResolverTest.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.Cheese"));
    }

    public void testResolveObjectFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.FirstClass");
        resolver.addImport("org.drools.FirstClass.AlternativeKey");
        resolver.addImport("org.drools.SecondClass");
        resolver.addImport("org.drools.SecondClass.AlternativeKey");
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("String"));
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
        ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.Cheese"));
        ClassTypeResolverTest.assertEquals(FirstClass.class, (Object)resolver.resolveType("org.drools.FirstClass"));
        ClassTypeResolverTest.assertEquals(FirstClass.AlternativeKey.class, (Object)resolver.resolveType("org.drools.FirstClass.AlternativeKey"));
        ClassTypeResolverTest.assertEquals(SecondClass.class, (Object)resolver.resolveType("org.drools.SecondClass"));
        ClassTypeResolverTest.assertEquals(SecondClass.AlternativeKey.class, (Object)resolver.resolveType("org.drools.SecondClass.AlternativeKey"));
    }

    public void testResolveObjectFromImportNested() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.FirstClass");
        ClassTypeResolverTest.assertEquals(FirstClass.AlternativeKey.class, (Object)resolver.resolveType("FirstClass.AlternativeKey"));
    }

    public void testResolveFullTypeName() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        resolver.addImport("org.drools.FirstClass");
        ClassTypeResolverTest.assertEquals((String)"org.drools.Cheese", (String)resolver.getFullTypeName("Cheese"));
        ClassTypeResolverTest.assertEquals((String)"org.drools.FirstClass", (String)resolver.getFullTypeName("FirstClass"));
    }

    public void testResolveObjectFromImportMultipleClassesDifferentPackages() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("String"));
        ClassTypeResolverTest.assertEquals(String.class, (Object)resolver.resolveType("java.lang.String"));
        ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("Cheese"));
        ClassTypeResolverTest.assertEquals(Cheese.class, (Object)resolver.resolveType("org.drools.Cheese"));
    }

    public void testResolveArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(String[].class, (Object)resolver.resolveType("String[]"));
        ClassTypeResolverTest.assertEquals(String[].class, (Object)resolver.resolveType("java.lang.String[]"));
        try {
            ClassTypeResolverTest.assertEquals(Cheese[].class, (Object)resolver.resolveType("Cheese[]"));
            ClassTypeResolverTest.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassTypeResolverTest.assertEquals(Cheese[].class, (Object)resolver.resolveType("org.drools.Cheese[]"));
    }

    public void testResolveArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ClassTypeResolverTest.assertEquals(String[].class, (Object)resolver.resolveType("String[]"));
        ClassTypeResolverTest.assertEquals(String[].class, (Object)resolver.resolveType("java.lang.String[]"));
        ClassTypeResolverTest.assertEquals(Cheese[].class, (Object)resolver.resolveType("Cheese[]"));
        ClassTypeResolverTest.assertEquals(Cheese[].class, (Object)resolver.resolveType("org.drools.Cheese[]"));
    }

    public void testResolveMultidimensionnalArrayOfObjectsNotFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        ClassTypeResolverTest.assertEquals(String[][].class, (Object)resolver.resolveType("String[][]"));
        ClassTypeResolverTest.assertEquals(String[][].class, (Object)resolver.resolveType("java.lang.String[][]"));
        try {
            ClassTypeResolverTest.assertEquals(Cheese[][].class, (Object)resolver.resolveType("Cheese[][]"));
            ClassTypeResolverTest.fail((String)"Should raise a ClassNotFoundException");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        ClassTypeResolverTest.assertEquals(Cheese[][].class, (Object)resolver.resolveType("org.drools.Cheese[][]"));
    }

    public void testResolveMultidimensionnalArrayOfObjectsFromImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Cheese");
        ClassTypeResolverTest.assertEquals(String[][].class, (Object)resolver.resolveType("String[][]"));
        ClassTypeResolverTest.assertEquals(String[][].class, (Object)resolver.resolveType("java.lang.String[][]"));
        ClassTypeResolverTest.assertEquals(Cheese[][].class, (Object)resolver.resolveType("Cheese[][]"));
        ClassTypeResolverTest.assertEquals(Cheese[][].class, (Object)resolver.resolveType("org.drools.Cheese[][]"));
    }

    public void testDefaultPackageImport() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("Goo");
        try {
            resolver.resolveType("Goo");
            ClassTypeResolverTest.fail((String)"Can't import default namespace classes");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public void testNestedClassResolving() throws Exception {
        ClassTypeResolver resolver = new ClassTypeResolver(new HashSet(), Thread.currentThread().getContextClassLoader());
        resolver.addImport("org.drools.Person.Nested1");
        ClassTypeResolverTest.assertEquals(Person.Nested1.class, (Object)resolver.resolveType("Nested1"));
        resolver.addImport("org.drools.Person.Nested1.Nested2");
        ClassTypeResolverTest.assertEquals(Person.Nested1.Nested2.class, (Object)resolver.resolveType("Nested2"));
        resolver.addImport("org.drools.Person.Nested1.Nested2.Nested3");
        ClassTypeResolverTest.assertEquals(Person.Nested1.Nested2.Nested3.class, (Object)resolver.resolveType("Nested3"));
    }
}

