/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.Date;
import junit.framework.TestCase;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.spi.FieldValue;

public class FieldFactoryTest
extends TestCase {
    public void testBigDecimal() {
        FieldValue val = FieldFactory.getFieldValue((String)"42.42", (ValueType)ValueType.BIG_DECIMAL_TYPE);
        FieldFactoryTest.assertEquals(BigDecimal.class, val.getValue().getClass());
        FieldFactoryTest.assertTrue((boolean)val.getValue().equals(new BigDecimal("42.42")));
    }

    public void testBigInteger() {
        FieldValue val = FieldFactory.getFieldValue((String)"424242", (ValueType)ValueType.BIG_INTEGER_TYPE);
        FieldFactoryTest.assertEquals(BigInteger.class, val.getValue().getClass());
        FieldFactoryTest.assertTrue((boolean)val.getValue().equals(new BigInteger("424242")));
    }

    public void testDate() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        String s = df.format(df.parse("10-Jul-1974"));
        FieldValue val = FieldFactory.getFieldValue((String)s, (ValueType)ValueType.DATE_TYPE);
        FieldFactoryTest.assertEquals(Date.class, val.getValue().getClass());
        Date dt = (Date)val.getValue();
        FieldFactoryTest.assertEquals((String)s, (String)df.format(dt));
    }
}

