/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.evaluators;

import junit.framework.TestCase;
import org.drools.base.evaluators.TimeIntervalParser;

public class TimeIntervalParserTest
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testParse() {
        String input = "2d10h49m10s789ms";
        long expected = 211750789L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)1, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected, (long)result[0]);
    }

    public void testParse2() {
        String input = "10h49m789ms";
        long expected = 38940789L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)1, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected, (long)result[0]);
    }

    public void testParse3() {
        String input = " 10h49m789 , 12h ";
        long expected1 = 38940789L;
        long expected2 = 43200000L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)2, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected1, (long)result[0]);
        TimeIntervalParserTest.assertEquals((long)expected2, (long)result[1]);
    }

    public void testParse4() {
        String input = " 15957, 3500000 ";
        long expected1 = 15957L;
        long expected2 = 3500000L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)2, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected1, (long)result[0]);
        TimeIntervalParserTest.assertEquals((long)expected2, (long)result[1]);
    }

    public void testParse5() {
        String input = "";
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)0, (int)result.length);
    }

    public void testParse6() {
        String input = null;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)0, (int)result.length);
    }

    public void testParse7() {
        String input = "  ";
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)0, (int)result.length);
    }

    public void testParse8() {
        String input = " -15957, 3500000 ";
        long expected1 = -15957L;
        long expected2 = 3500000L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)2, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected1, (long)result[0]);
        TimeIntervalParserTest.assertEquals((long)expected2, (long)result[1]);
    }

    public void testParse9() {
        String input = " -10h49m789 , -8h ";
        long expected1 = -38940789L;
        long expected2 = -28800000L;
        Long[] result = new TimeIntervalParser().parse(input);
        TimeIntervalParserTest.assertEquals((int)2, (int)result.length);
        TimeIntervalParserTest.assertEquals((long)expected1, (long)result[0]);
        TimeIntervalParserTest.assertEquals((long)expected2, (long)result[1]);
    }
}

