/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import junit.framework.TestCase;
import org.drools.common.DroolsObjectInputStream;
import org.drools.common.DroolsObjectOutputStream;
import org.drools.rule.GroupElement;
import org.drools.rule.Package;
import org.drools.util.DroolsStreamUtils;

public class DroolsObjectIOTest
extends TestCase {
    private static final String TEST_FILE = "test.dat";
    private static final GroupElement testGroupElement = new GroupElement();

    public void testFileIO() throws Exception {
        File file = new File(((Object)((Object)this)).getClass().getResource("DroolsObjectIOTest.class").getFile());
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        new ObjectOutputStream(bytes).writeObject(new Test());
        Test t = (Test)new ObjectInputStream(new ByteArrayInputStream(bytes.toByteArray())).readObject();
        String str = TEST_FILE;
        file = new File(file.getParent().replaceAll("%20", " "), str);
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(file), (Object)testGroupElement);
        InputStream fis = ((Object)((Object)this)).getClass().getResourceAsStream(TEST_FILE);
        System.out.println(fis.available());
        GroupElement that = (GroupElement)DroolsStreamUtils.streamIn((InputStream)fis);
        DroolsObjectIOTest.assertEquals((Object)that, (Object)testGroupElement);
    }

    public void testObject() throws Exception {
        SerializableObject obj = new ExternalizableObject();
        byte[] buf = DroolsObjectIOTest.serialize(obj);
        DroolsObjectIOTest.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)obj);
        obj = new SerializableObject();
        buf = DroolsObjectIOTest.serialize(obj);
        DroolsObjectIOTest.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)obj);
    }

    private static Object deserialize(byte[] buf) throws Exception {
        return new DroolsObjectInputStream((InputStream)new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] serialize(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        DroolsObjectOutputStream out = new DroolsObjectOutputStream((OutputStream)bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    private static Object unmarshal(byte[] buf) throws Exception {
        return new ObjectInputStream(new ByteArrayInputStream(buf)).readObject();
    }

    private static byte[] marshal(Object obj) throws IOException {
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(bytes);
        out.writeObject(obj);
        out.flush();
        out.close();
        return bytes.toByteArray();
    }

    public void testStreaming() throws Exception {
        Package pkg = new Package("test");
        byte[] buf = DroolsObjectIOTest.marshal(pkg);
        DroolsObjectIOTest.assertEquals((Object)DroolsObjectIOTest.unmarshal(buf), (Object)pkg);
        buf = DroolsObjectIOTest.serialize(pkg);
        DroolsObjectIOTest.assertEquals((Object)DroolsObjectIOTest.deserialize(buf), (Object)pkg);
    }

    public static class SerializableObject
    implements Serializable {
        protected int value = 123;
        protected String name;

        public SerializableObject() {
            this("SerializableObject");
        }

        public SerializableObject(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof SerializableObject) {
                return this.value == ((SerializableObject)obj).value;
            }
            return false;
        }

        public String toString() {
            return this.name + '|' + this.value;
        }
    }

    public static class ExternalizableObject
    extends SerializableObject
    implements Externalizable {
        public ExternalizableObject() {
            super("ExternalizableObject");
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.value = in.readInt();
            this.name = (String)in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeInt(this.value);
            out.writeObject(this.name);
        }
    }

    static class Test
    implements Serializable {
        String str = "test.dat";

        Test() {
        }
    }
}

