/*
 * Decompiled with CFR 0.152.
 */
package org.drools.event;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.FactHandle;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.ComparableEvaluatorsDefinition;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.EvaluatorDefinition;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.base.evaluators.MatchesEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.evaluators.SetEvaluatorsDefinition;
import org.drools.base.evaluators.SoundslikeEvaluatorsDefinition;
import org.drools.event.ActivationCancelledEvent;
import org.drools.event.ActivationCreatedEvent;
import org.drools.event.AfterActivationFiredEvent;
import org.drools.event.AgendaEventListener;
import org.drools.event.AgendaEventSupport;
import org.drools.event.AgendaGroupPoppedEvent;
import org.drools.event.AgendaGroupPushedEvent;
import org.drools.event.BeforeActivationFiredEvent;
import org.drools.event.rule.ActivationCancelledCause;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.Consequence;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;

public class AgendaEventSupportTest
extends TestCase {
    public static EvaluatorRegistry registry = new EvaluatorRegistry();

    public void testIsSerializable() {
        AgendaEventSupportTest.assertTrue((boolean)Serializable.class.isAssignableFrom(AgendaEventSupport.class));
    }

    public void testAgendaEventListener() throws Exception {
        RuleBase rb = RuleBaseFactory.newRuleBase();
        Package pkg = new Package("org.drools.test");
        Rule rule = new Rule("test1");
        rule.setAgendaGroup("test group");
        ClassObjectType cheeseObjectType = new ClassObjectType(Cheese.class);
        Pattern pattern = new Pattern(0, (ObjectType)cheeseObjectType);
        pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg.getClassFieldAccessorStore().setEagerWire(true);
        ClassFieldReader extractor = pkg.getClassFieldAccessorStore().getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        FieldValue field = FieldFactory.getFieldValue((Object)"cheddar");
        Evaluator evaluator = registry.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL, null);
        LiteralConstraint constraint = new LiteralConstraint((InternalReadAccessor)extractor, evaluator, field);
        pattern.addConstraint((Constraint)constraint);
        rule.addPattern((RuleConditionElement)pattern);
        rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        });
        pkg.addRule(rule);
        rb.addPackage(pkg);
        StatefulSession wm = rb.newStatefulSession();
        final ArrayList agendaList = new ArrayList();
        AgendaEventListener agendaEventListener = new AgendaEventListener(){

            public void activationCancelled(ActivationCancelledEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void activationCreated(ActivationCreatedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void afterActivationFired(AfterActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPopped(AgendaGroupPoppedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void agendaGroupPushed(AgendaGroupPushedEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }

            public void beforeActivationFired(BeforeActivationFiredEvent event, WorkingMemory workingMemory) {
                agendaList.add(event);
            }
        };
        wm.addEventListener(agendaEventListener);
        Cheese cheddar = new Cheese("cheddar", 15);
        FactHandle cheddarHandle = wm.insert((Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        ActivationCreatedEvent createdEvent = (ActivationCreatedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)createdEvent.getActivation().getTuple().get(0).getObject());
        wm.clearAgenda();
        ActivationCancelledEvent cancelledEvent = (ActivationCancelledEvent)agendaList.get(1);
        AgendaEventSupportTest.assertEquals((Object)ActivationCancelledCause.CLEAR, (Object)cancelledEvent.getCause());
        agendaList.clear();
        cheddar.setPrice(14);
        wm.update((org.drools.runtime.rule.FactHandle)cheddarHandle, (Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        createdEvent = (ActivationCreatedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)createdEvent.getActivation().getTuple().get(0).getObject());
        agendaList.clear();
        cheddar.setPrice(14);
        wm.update((org.drools.runtime.rule.FactHandle)cheddarHandle, (Object)cheddar);
        AgendaEventSupportTest.assertEquals((int)2, (int)agendaList.size());
        cancelledEvent = (ActivationCancelledEvent)agendaList.get(0);
        AgendaEventSupportTest.assertEquals((Object)ActivationCancelledCause.WME_MODIFY, (Object)cancelledEvent.getCause());
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)cancelledEvent.getActivation().getTuple().get(0).getObject());
        createdEvent = (ActivationCreatedEvent)agendaList.get(1);
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)createdEvent.getActivation().getTuple().get(0).getObject());
        agendaList.clear();
        wm.retract((org.drools.runtime.rule.FactHandle)cheddarHandle);
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        cancelledEvent = (ActivationCancelledEvent)agendaList.get(0);
        AgendaEventSupportTest.assertNull((Object)cancelledEvent.getActivation().getTuple().get(0).getObject());
        cheddarHandle = wm.insert((Object)cheddar);
        agendaList.clear();
        wm.setFocus("test group");
        AgendaEventSupportTest.assertEquals((int)1, (int)agendaList.size());
        AgendaGroupPushedEvent pushedEvent = (AgendaGroupPushedEvent)agendaList.get(0);
        AgendaEventSupportTest.assertEquals((String)"test group", (String)pushedEvent.getAgendaGroup().getName());
        agendaList.clear();
        wm.fireAllRules();
        AgendaEventSupportTest.assertEquals((int)3, (int)agendaList.size());
        BeforeActivationFiredEvent beforeEvent = (BeforeActivationFiredEvent)agendaList.get(0);
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)beforeEvent.getActivation().getTuple().get(0).getObject());
        AfterActivationFiredEvent afterEvent = (AfterActivationFiredEvent)agendaList.get(1);
        AgendaEventSupportTest.assertSame((Object)cheddar, (Object)afterEvent.getActivation().getTuple().get(0).getObject());
        AgendaGroupPoppedEvent poppedEvent = (AgendaGroupPoppedEvent)agendaList.get(2);
        AgendaEventSupportTest.assertEquals((String)"test group", (String)poppedEvent.getAgendaGroup().getName());
    }

    static {
        registry.addEvaluatorDefinition((EvaluatorDefinition)new EqualityEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new ComparableEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SetEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new MatchesEvaluatorsDefinition());
        registry.addEvaluatorDefinition((EvaluatorDefinition)new SoundslikeEvaluatorsDefinition());
    }
}

