/*
 * Decompiled with CFR 0.152.
 */
package org.drools.examples.manners;

import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.StringTokenizer;
import junit.framework.TestCase;
import org.drools.FactHandle;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ClassObjectType;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.base.field.BooleanFieldImpl;
import org.drools.base.field.LongFieldImpl;
import org.drools.common.InternalWorkingMemory;
import org.drools.examples.manners.Chosen;
import org.drools.examples.manners.Context;
import org.drools.examples.manners.Count;
import org.drools.examples.manners.Guest;
import org.drools.examples.manners.Hobby;
import org.drools.examples.manners.LastSeat;
import org.drools.examples.manners.Path;
import org.drools.examples.manners.Seating;
import org.drools.examples.manners.Sex;
import org.drools.rule.Declaration;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.LiteralConstraint;
import org.drools.rule.Package;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.rule.RuleConditionElement;
import org.drools.rule.VariableConstraint;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.Consequence;
import org.drools.spi.ConsequenceException;
import org.drools.spi.Constraint;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ObjectType;
import org.drools.spi.Tuple;

public abstract class BaseMannersTest
extends TestCase {
    private final int numGuests = 16;
    private final int numSeats = 16;
    private final int minHobbies = 2;
    private final int maxHobbies = 3;
    protected Package pkg;
    private ClassObjectType contextType;
    private ClassObjectType guestType;
    private ClassObjectType seatingType;
    private ClassObjectType lastSeatType;
    private ClassObjectType countType;
    private ClassObjectType pathType;
    private ClassObjectType chosenType;
    private Evaluator objectEqualEvaluator;
    private Evaluator objectNotEqualEvaluator;
    private Evaluator integerEqualEvaluator;
    private Evaluator booleanEqualEvaluator;
    ClassFieldAccessorStore store;

    protected void setUp() throws Exception {
        this.contextType = new ClassObjectType(Context.class);
        this.guestType = new ClassObjectType(Guest.class);
        this.seatingType = new ClassObjectType(Seating.class);
        this.lastSeatType = new ClassObjectType(LastSeat.class);
        this.countType = new ClassObjectType(Count.class);
        this.pathType = new ClassObjectType(Path.class);
        this.chosenType = new ClassObjectType(Chosen.class);
        EqualityEvaluatorsDefinition evals = new EqualityEvaluatorsDefinition();
        this.integerEqualEvaluator = evals.getEvaluator(ValueType.PINTEGER_TYPE, Operator.EQUAL, null);
        this.objectEqualEvaluator = evals.getEvaluator(ValueType.OBJECT_TYPE, Operator.EQUAL, null);
        this.objectNotEqualEvaluator = evals.getEvaluator(ValueType.OBJECT_TYPE, Operator.NOT_EQUAL, null);
        this.booleanEqualEvaluator = evals.getEvaluator(ValueType.PBOOLEAN_TYPE, Operator.EQUAL, null);
        this.pkg = new Package("org.drools.examples.manners");
        this.pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store = this.pkg.getClassFieldAccessorStore();
        this.store.setEagerWire(true);
        this.pkg.addRule(this.getAssignFirstSeatRule());
        this.pkg.addRule(this.getFindSeating());
        this.pkg.addRule(this.getPathDone());
        this.pkg.addRule(this.getMakePath());
        this.pkg.addRule(this.getContinueProcessing());
        this.pkg.addRule(this.getAreWeDone());
        this.pkg.addRule(this.getAllDone());
    }

    private Rule getAssignFirstSeatRule() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("assignFirstSeat");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType, "context");
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 0, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        final Declaration contextDeclaration = rule.getDeclaration("context");
        Pattern guestPattern = new Pattern(1, (ObjectType)this.guestType, "guest");
        rule.addPattern((RuleConditionElement)guestPattern);
        final Declaration guestDeclaration = rule.getDeclaration("guest");
        Pattern countPattern = new Pattern(2, (ObjectType)this.countType, "count");
        rule.addPattern((RuleConditionElement)countPattern);
        final Declaration countDeclaration = rule.getDeclaration("count");
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Guest guest = (Guest)drools.get(guestDeclaration);
                    Context context = (Context)drools.get(contextDeclaration);
                    Count count = (Count)drools.get(countDeclaration);
                    String guestName = guest.getName();
                    Seating seating = new Seating(count.getValue(), 0, true, 1, guestName, 1, guestName);
                    drools.insert((Object)seating);
                    Path path = new Path(count.getValue(), 1, guestName);
                    drools.insert((Object)path);
                    count.setValue(count.getValue());
                    drools.update((FactHandle)tuple.get(countDeclaration), (Object)count);
                    drools.modifyRetract((Object)context);
                    context.setState(1);
                    drools.modifyInsert((Object)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getFindSeating() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("findSeating");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType, "context");
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 1, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        final Declaration contextDeclaration = rule.getDeclaration("context");
        Pattern seatingPattern = new Pattern(1, (ObjectType)this.seatingType);
        this.setFieldDeclaration(seatingPattern, "id", "seatingId");
        this.setFieldDeclaration(seatingPattern, "pid", "seatingPid");
        seatingPattern.addConstraint((Constraint)this.getLiteralConstraint(seatingPattern, "pathDone", true, this.booleanEqualEvaluator));
        this.setFieldDeclaration(seatingPattern, "rightSeat", "seatingRightSeat");
        this.setFieldDeclaration(seatingPattern, "rightGuestName", "seatingRightGuestName");
        rule.addPattern((RuleConditionElement)seatingPattern);
        final Declaration seatingIdDeclaration = rule.getDeclaration("seatingId");
        Declaration seatingPidDeclaration = rule.getDeclaration("seatingPid");
        final Declaration seatingRightGuestNameDeclaration = rule.getDeclaration("seatingRightGuestName");
        final Declaration seatingRightSeatDeclaration = rule.getDeclaration("seatingRightSeat");
        Pattern rightGuestPattern = new Pattern(2, (ObjectType)this.guestType);
        rightGuestPattern.addConstraint((Constraint)this.getBoundVariableConstraint(rightGuestPattern, "name", seatingRightGuestNameDeclaration, this.objectEqualEvaluator));
        this.setFieldDeclaration(rightGuestPattern, "sex", "rightGuestSex");
        this.setFieldDeclaration(rightGuestPattern, "hobby", "rightGuestHobby");
        rule.addPattern((RuleConditionElement)rightGuestPattern);
        Declaration rightGuestSexDeclaration = rule.getDeclaration("rightGuestSex");
        final Declaration rightGuestHobbyDeclaration = rule.getDeclaration("rightGuestHobby");
        Pattern leftGuestPattern = new Pattern(3, (ObjectType)this.guestType);
        this.setFieldDeclaration(leftGuestPattern, "name", "leftGuestName");
        leftGuestPattern.addConstraint((Constraint)this.getBoundVariableConstraint(rightGuestPattern, "hobby", rightGuestHobbyDeclaration, this.objectEqualEvaluator));
        leftGuestPattern.addConstraint((Constraint)this.getBoundVariableConstraint(leftGuestPattern, "sex", rightGuestSexDeclaration, this.objectNotEqualEvaluator));
        rule.addPattern((RuleConditionElement)leftGuestPattern);
        final Declaration leftGuestNameDeclaration = rule.getDeclaration("leftGuestName");
        Pattern count = new Pattern(4, (ObjectType)this.countType, "count");
        rule.addPattern((RuleConditionElement)count);
        final Declaration countDeclaration = rule.getDeclaration("count");
        Pattern notPathPattern = new Pattern(5, (ObjectType)this.pathType);
        notPathPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notPathPattern, "id", seatingIdDeclaration, this.integerEqualEvaluator));
        notPathPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notPathPattern, "guestName", leftGuestNameDeclaration, this.objectEqualEvaluator));
        GroupElement notPath = GroupElementFactory.newNotInstance();
        notPath.addChild((RuleConditionElement)notPathPattern);
        rule.addPattern((RuleConditionElement)notPath);
        Pattern notChosenPattern = new Pattern(6, (ObjectType)this.chosenType);
        notChosenPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notChosenPattern, "id", seatingIdDeclaration, this.integerEqualEvaluator));
        notChosenPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notChosenPattern, "guestName", leftGuestNameDeclaration, this.objectEqualEvaluator));
        notChosenPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notChosenPattern, "hobby", rightGuestHobbyDeclaration, this.objectEqualEvaluator));
        GroupElement notChosen = GroupElementFactory.newNotInstance();
        notChosen.addChild((RuleConditionElement)notChosenPattern);
        rule.addPattern((RuleConditionElement)notChosen);
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Context context = (Context)drools.get(contextDeclaration);
                    Count count = (Count)drools.get(countDeclaration);
                    int seatId = seatingIdDeclaration.getExtractor().getIntValue((InternalWorkingMemory)workingMemory, tuple.get(seatingIdDeclaration).getObject());
                    int seatingRightSeat = seatingRightSeatDeclaration.getExtractor().getIntValue((InternalWorkingMemory)workingMemory, tuple.get(seatingRightSeatDeclaration).getObject());
                    String leftGuestName = (String)drools.get(leftGuestNameDeclaration);
                    String rightGuestName = (String)drools.get(seatingRightGuestNameDeclaration);
                    Hobby rightGuestHobby = (Hobby)drools.get(rightGuestHobbyDeclaration);
                    Seating seating = new Seating(count.getValue(), seatId, false, seatingRightSeat, rightGuestName, seatingRightSeat + 1, leftGuestName);
                    drools.insert((Object)seating);
                    Path path = new Path(count.getValue(), seatingRightSeat + 1, leftGuestName);
                    drools.insert((Object)path);
                    Chosen chosen = new Chosen(seatId, leftGuestName, rightGuestHobby);
                    drools.insert((Object)chosen);
                    count.setValue(count.getValue() + 1);
                    drools.update((FactHandle)tuple.get(countDeclaration), (Object)count);
                    context.setState(2);
                    drools.update((FactHandle)tuple.get(contextDeclaration), (Object)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getMakePath() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("makePath");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType);
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 2, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        Pattern seatingPattern = new Pattern(1, (ObjectType)this.seatingType);
        this.setFieldDeclaration(seatingPattern, "id", "seatingId");
        this.setFieldDeclaration(seatingPattern, "pid", "seatingPid");
        seatingPattern.addConstraint((Constraint)this.getLiteralConstraint(seatingPattern, "pathDone", false, this.booleanEqualEvaluator));
        rule.addPattern((RuleConditionElement)seatingPattern);
        final Declaration seatingIdDeclaration = rule.getDeclaration("seatingId");
        Declaration seatingPidDeclaration = rule.getDeclaration("seatingPid");
        Pattern pathPattern = new Pattern(2, (ObjectType)this.pathType);
        pathPattern.addConstraint((Constraint)this.getBoundVariableConstraint(pathPattern, "id", seatingPidDeclaration, this.integerEqualEvaluator));
        this.setFieldDeclaration(pathPattern, "guestName", "pathGuestName");
        this.setFieldDeclaration(pathPattern, "seat", "pathSeat");
        rule.addPattern((RuleConditionElement)pathPattern);
        final Declaration pathGuestNameDeclaration = rule.getDeclaration("pathGuestName");
        final Declaration pathSeatDeclaration = rule.getDeclaration("pathSeat");
        Pattern notPathPattern = new Pattern(3, (ObjectType)this.pathType);
        notPathPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notPathPattern, "id", seatingIdDeclaration, this.integerEqualEvaluator));
        notPathPattern.addConstraint((Constraint)this.getBoundVariableConstraint(notPathPattern, "guestName", pathGuestNameDeclaration, this.objectEqualEvaluator));
        GroupElement not = GroupElementFactory.newNotInstance();
        not.addChild((RuleConditionElement)notPathPattern);
        rule.addPattern((RuleConditionElement)not);
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    int id = seatingIdDeclaration.getExtractor().getIntValue((InternalWorkingMemory)workingMemory, tuple.get(seatingIdDeclaration).getObject());
                    int seat = pathSeatDeclaration.getExtractor().getIntValue((InternalWorkingMemory)workingMemory, tuple.get(pathSeatDeclaration).getObject());
                    String guestName = (String)drools.get(pathGuestNameDeclaration);
                    Path path = new Path(id, seat, guestName);
                    drools.insert((Object)path);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getPathDone() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("pathDone");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType, "context");
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 2, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        final Declaration contextDeclaration = rule.getDeclaration("context");
        Pattern seatingPattern = new Pattern(1, (ObjectType)this.seatingType, "seating");
        seatingPattern.addConstraint((Constraint)this.getLiteralConstraint(seatingPattern, "pathDone", false, this.booleanEqualEvaluator));
        rule.addPattern((RuleConditionElement)seatingPattern);
        final Declaration seatingDeclaration = rule.getDeclaration("seating");
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Context context = (Context)drools.get(contextDeclaration);
                    Seating seating = (Seating)drools.get(seatingDeclaration);
                    drools.modifyRetract((Object)seating);
                    seating.setPathDone(true);
                    drools.modifyInsert((Object)seating);
                    context.setState(3);
                    drools.update((FactHandle)tuple.get(contextDeclaration), (Object)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getAreWeDone() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("areWeDone");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType, "context");
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 3, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        final Declaration contextDeclaration = rule.getDeclaration("context");
        Pattern lastSeatPattern = new Pattern(1, (ObjectType)this.lastSeatType);
        this.setFieldDeclaration(lastSeatPattern, "seat", "lastSeat");
        rule.addPattern((RuleConditionElement)lastSeatPattern);
        Declaration lastSeatDeclaration = rule.getDeclaration("lastSeat");
        Pattern seatingPattern = new Pattern(2, (ObjectType)this.seatingType, null);
        seatingPattern.addConstraint((Constraint)this.getBoundVariableConstraint(seatingPattern, "rightSeat", lastSeatDeclaration, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)seatingPattern);
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Context context = (Context)drools.get(contextDeclaration);
                    context.setState(4);
                    drools.update((FactHandle)tuple.get(contextDeclaration), (Object)context);
                }
                catch (Exception e) {
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getContinueProcessing() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("continueProcessng");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType, "context");
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 3, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        final Declaration contextDeclaration = rule.getDeclaration("context");
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    Rule rule = drools.getRule();
                    Tuple tuple = drools.getTuple();
                    Context context = (Context)drools.get(contextDeclaration);
                    context.setState(1);
                    drools.update((FactHandle)tuple.get(contextDeclaration), (Object)context);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    private Rule getAllDone() throws IntrospectionException, InvalidRuleException {
        Rule rule = new Rule("alldone");
        Pattern contextPattern = new Pattern(0, (ObjectType)this.contextType);
        contextPattern.addConstraint((Constraint)this.getLiteralConstraint(contextPattern, "state", 4, this.integerEqualEvaluator));
        rule.addPattern((RuleConditionElement)contextPattern);
        Declaration contextDeclaration = rule.getDeclaration("context");
        Consequence consequence = new Consequence(){

            public void evaluate(KnowledgeHelper drools, WorkingMemory workingMemory) throws ConsequenceException {
                try {
                    System.err.println("all done");
                }
                catch (Exception e) {
                    throw new ConsequenceException((Throwable)e);
                }
            }

            public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            }

            public void writeExternal(ObjectOutput out) throws IOException {
            }
        };
        rule.setConsequence(consequence);
        return rule;
    }

    protected List getInputObjects(InputStream inputStream) throws IOException {
        String line;
        ArrayList<Externalizable> list = new ArrayList<Externalizable>();
        BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        while ((line = br.readLine()) != null) {
            if (line.trim().length() == 0 || line.trim().startsWith(";")) continue;
            StringTokenizer st = new StringTokenizer(line, "() ");
            String type = st.nextToken();
            if ("guest".equals(type)) {
                if (!"name".equals(st.nextToken())) {
                    throw new IOException("expected 'name' in: " + line);
                }
                String name = st.nextToken();
                if (!"sex".equals(st.nextToken())) {
                    throw new IOException("expected 'sex' in: " + line);
                }
                String sex = st.nextToken();
                if (!"hobby".equals(st.nextToken())) {
                    throw new IOException("expected 'hobby' in: " + line);
                }
                String hobby = st.nextToken();
                Guest guest = new Guest(name, Sex.resolve(sex), Hobby.resolve(hobby));
                list.add(guest);
            }
            if ("last_seat".equals(type)) {
                if (!"seat".equals(st.nextToken())) {
                    throw new IOException("expected 'seat' in: " + line);
                }
                list.add(new LastSeat(Integer.parseInt(st.nextToken())));
            }
            if (!"context".equals(type)) continue;
            if (!"state".equals(st.nextToken())) {
                throw new IOException("expected 'state' in: " + line);
            }
            list.add(new Context(st.nextToken()));
        }
        inputStream.close();
        return list;
    }

    private InputStream generateData() {
        String LINE_SEPARATOR = System.getProperty("line.separator");
        StringWriter writer = new StringWriter();
        ((Object)((Object)this)).getClass();
        int maxMale = 16 / 2;
        ((Object)((Object)this)).getClass();
        int maxFemale = 16 / 2;
        int maleCount = 0;
        int femaleCount = 0;
        ArrayList<String> hobbyList = new ArrayList<String>();
        for (int i = 1; i <= this.maxHobbies; ++i) {
            hobbyList.add("h" + i);
        }
        Random rnd = new Random();
        int i = 1;
        while (true) {
            char sex;
            ((Object)((Object)this)).getClass();
            if (i > 16) break;
            char c = sex = rnd.nextBoolean() ? (char)'m' : 'f';
            if (sex == 'm' && maleCount == maxMale) {
                sex = 'f';
            }
            if (sex == 'f' && femaleCount == maxFemale) {
                sex = 'm';
            }
            if (sex == 'm') {
                ++maleCount;
            }
            if (sex == 'f') {
                ++femaleCount;
            }
            ArrayList guestHobbies = new ArrayList(hobbyList);
            int numHobbies = this.minHobbies + rnd.nextInt(this.maxHobbies - this.minHobbies + 1);
            for (int j = 0; j < numHobbies; ++j) {
                int hobbyIndex = rnd.nextInt(guestHobbies.size());
                String hobby = (String)guestHobbies.get(hobbyIndex);
                writer.write("(guest (name n" + i + ") (sex " + sex + ") (hobby " + hobby + "))" + LINE_SEPARATOR);
                guestHobbies.remove(hobbyIndex);
            }
            ++i;
        }
        StringBuilder stringBuilder = new StringBuilder().append("(last_seat (seat ");
        ((Object)((Object)this)).getClass();
        writer.write(stringBuilder.append(16).append("))").append(LINE_SEPARATOR).toString());
        writer.write(LINE_SEPARATOR);
        writer.write("(context (state start))" + LINE_SEPARATOR);
        return new ByteArrayInputStream(writer.getBuffer().toString().getBytes());
    }

    public static int getIndex(Class clazz, String name) throws IntrospectionException {
        PropertyDescriptor[] descriptors = Introspector.getBeanInfo(clazz).getPropertyDescriptors();
        for (int i = 0; i < descriptors.length; ++i) {
            if (!descriptors[i].getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    private AlphaNodeFieldConstraint getLiteralConstraint(Pattern pattern, String fieldName, int fieldValue, Evaluator evaluator) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        LongFieldImpl field = new LongFieldImpl((long)fieldValue);
        return new LiteralConstraint((InternalReadAccessor)extractor, evaluator, (FieldValue)field);
    }

    private AlphaNodeFieldConstraint getLiteralConstraint(Pattern pattern, String fieldName, boolean fieldValue, Evaluator evaluator) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        BooleanFieldImpl field = new BooleanFieldImpl(fieldValue);
        return new LiteralConstraint((InternalReadAccessor)extractor, evaluator, (FieldValue)field);
    }

    private void setFieldDeclaration(Pattern pattern, String fieldName, String identifier) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        pattern.addDeclaration(identifier).setReadAccessor((InternalReadAccessor)extractor);
    }

    private BetaNodeFieldConstraint getBoundVariableConstraint(Pattern pattern, String fieldName, Declaration declaration, Evaluator evaluator) throws IntrospectionException {
        Class clazz = ((ClassObjectType)pattern.getObjectType()).getClassType();
        ClassFieldReader extractor = this.store.getReader(clazz, fieldName, ((Object)((Object)this)).getClass().getClassLoader());
        return new VariableConstraint((InternalReadAccessor)extractor, declaration, evaluator);
    }
}

