/*
 * Decompiled with CFR 0.152.
 */
package org.drools.process;

import junit.framework.TestCase;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.definition.process.Node;
import org.drools.process.core.Process;
import org.drools.process.core.Work;
import org.drools.process.core.impl.WorkImpl;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.ruleflow.core.RuleFlowProcess;
import org.drools.runtime.process.WorkItem;
import org.drools.runtime.process.WorkItemHandler;
import org.drools.runtime.process.WorkItemManager;
import org.drools.spi.Action;
import org.drools.spi.KnowledgeHelper;
import org.drools.spi.ProcessContext;
import org.drools.workflow.core.DroolsAction;
import org.drools.workflow.core.impl.ConnectionImpl;
import org.drools.workflow.core.impl.DroolsConsequenceAction;
import org.drools.workflow.core.node.ActionNode;
import org.drools.workflow.core.node.EndNode;
import org.drools.workflow.core.node.StartNode;
import org.drools.workflow.core.node.SubProcessNode;
import org.drools.workflow.core.node.WorkItemNode;

public class SubProcessTest
extends TestCase {
    private boolean executed = false;
    private WorkItem workItem;

    public void setUp() {
        this.executed = false;
        this.workItem = null;
    }

    public void testSynchronousSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(3L);
        subProcessNode.setProcessId("org.drools.process.subprocess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        AbstractRuleBase ruleBase = (AbstractRuleBase)RuleBaseFactory.newRuleBase();
        ruleBase.addProcess((Process)process);
        process = new RuleFlowProcess();
        process.setId("org.drools.process.subprocess");
        process.setName("SubProcess");
        startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        ActionNode actionNode = new ActionNode();
        actionNode.setName("Action");
        DroolsConsequenceAction action = new DroolsConsequenceAction("java", null);
        action.setMetaData("Action", (Object)new Action(){

            public void execute(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory, ProcessContext context) throws Exception {
                System.out.println("Executed action");
                SubProcessTest.this.executed = true;
            }
        });
        actionNode.setAction((DroolsAction)action);
        process.addNode((Node)actionNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)actionNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)actionNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        ruleBase.addProcess((Process)process);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        workingMemory.startProcess("org.drools.process.process");
        SubProcessTest.assertTrue((boolean)this.executed);
        SubProcessTest.assertEquals((int)0, (int)workingMemory.getProcessInstances().size());
    }

    public void testAsynchronousSubProcess() {
        RuleFlowProcess process = new RuleFlowProcess();
        process.setId("org.drools.process.process");
        process.setName("Process");
        StartNode startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        EndNode endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        SubProcessNode subProcessNode = new SubProcessNode();
        subProcessNode.setName("SubProcessNode");
        subProcessNode.setId(3L);
        subProcessNode.setProcessId("org.drools.process.subprocess");
        process.addNode((Node)subProcessNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)subProcessNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)subProcessNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        AbstractRuleBase ruleBase = (AbstractRuleBase)RuleBaseFactory.newRuleBase();
        ruleBase.addProcess((Process)process);
        process = new RuleFlowProcess();
        process.setId("org.drools.process.subprocess");
        process.setName("SubProcess");
        startNode = new StartNode();
        startNode.setName("Start");
        startNode.setId(1L);
        process.addNode((Node)startNode);
        endNode = new EndNode();
        endNode.setName("EndNode");
        endNode.setId(2L);
        process.addNode((Node)endNode);
        WorkItemNode workItemNode = new WorkItemNode();
        workItemNode.setName("WorkItem");
        WorkImpl work = new WorkImpl();
        work.setName("MyWork");
        workItemNode.setWork((Work)work);
        process.addNode((Node)workItemNode);
        new ConnectionImpl((Node)startNode, "DROOLS_DEFAULT", (Node)workItemNode, "DROOLS_DEFAULT");
        new ConnectionImpl((Node)workItemNode, "DROOLS_DEFAULT", (Node)endNode, "DROOLS_DEFAULT");
        ruleBase.addProcess((Process)process);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)ruleBase);
        workingMemory.getWorkItemManager().registerWorkItemHandler("MyWork", new WorkItemHandler(){

            public void executeWorkItem(WorkItem workItem, WorkItemManager manager) {
                System.out.println("Executing work item");
                SubProcessTest.this.workItem = workItem;
            }

            public void abortWorkItem(WorkItem workItem, WorkItemManager manager) {
            }
        });
        workingMemory.startProcess("org.drools.process.process");
        SubProcessTest.assertNotNull((Object)this.workItem);
        SubProcessTest.assertEquals((int)2, (int)workingMemory.getProcessInstances().size());
        workingMemory.getWorkItemManager().completeWorkItem(this.workItem.getId(), null);
        SubProcessTest.assertEquals((int)0, (int)workingMemory.getProcessInstances().size());
    }
}

