/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.Collection;
import java.util.LinkedList;
import junit.framework.Assert;
import org.drools.DroolsTestCase;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.base.ClassObjectType;
import org.drools.common.DefaultFactHandle;
import org.drools.common.EmptyBetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.CollectNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.Collect;
import org.drools.rule.Pattern;
import org.drools.rule.Rule;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

public class CollectNodeTest
extends DroolsTestCase {
    Rule rule;
    PropagationContext contextAssert;
    PropagationContext contextRetract;
    ReteooWorkingMemory workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    BetaNode node;
    CollectNode.CollectMemory memory;
    Collect collect;

    protected void setUp() throws Exception {
        super.setUp();
        this.rule = new Rule("test-rule");
        this.contextAssert = new PropagationContextImpl(0L, 0, null, null, null);
        this.contextRetract = new PropagationContextImpl(0L, 1, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        this.tupleSource = new MockTupleSource(4);
        this.objectSource = new MockObjectSource(4);
        this.sink = new MockLeftTupleSink();
        ClassObjectType srcObjType = new ClassObjectType(String.class);
        Pattern sourcePattern = new Pattern(0, (ObjectType)srcObjType);
        ClassObjectType resultObjType = new ClassObjectType(LinkedList.class);
        Pattern resultPattern = new Pattern(1, (ObjectType)resultObjType);
        this.collect = new Collect(sourcePattern, resultPattern);
        this.node = new CollectNode(15, (LeftTupleSource)this.tupleSource, (ObjectSource)this.objectSource, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST, this.collect, false, buildContext);
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (CollectNode.CollectMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getRightTupleMemory().size());
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testUpdateNewNode() {
        this.node.updateSink((LeftTupleSink)this.sink, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"No tuple should be propagated", (int)0, (int)this.sink.getAsserted().size());
        this.node.assertLeftTuple(new LeftTuple(this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null), (LeftTupleSink)this.node, true), this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple(new LeftTuple(this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null), (LeftTupleSink)this.node, true), this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"Two tuples should have been propagated", (int)2, (int)this.sink.getAsserted().size());
        MockLeftTupleSink otherSink = new MockLeftTupleSink();
        this.node.addTupleSink((LeftTupleSink)otherSink);
        this.node.updateSink((LeftTupleSink)otherSink, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        Assert.assertEquals((String)"Two tuples should have been propagated", (int)2, (int)otherSink.getAsserted().size());
    }

    public void testAssertTuple() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getRightTupleMemory().size());
        Assert.assertTrue((String)"An empty collection should be propagated", (boolean)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).isEmpty());
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        Assert.assertTrue((String)"An empty collection should be propagated", (boolean)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(1))[0]).get(1)).getObject()).isEmpty());
        CollectNodeTest.assertTrue((boolean)this.memory.betaMemory.getLeftTupleMemory().contains(tuple0));
        CollectNodeTest.assertTrue((boolean)this.memory.betaMemory.getLeftTupleMemory().contains(tuple1));
        Assert.assertEquals((String)"Two tuples should have been propagated", (int)2, (int)this.sink.getAsserted().size());
    }

    public void testAssertTupleWithObjects() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertObject((InternalFactHandle)f1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getRightTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).size());
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(1))[0]).get(1)).getObject()).size());
        CollectNodeTest.assertTrue((boolean)this.memory.betaMemory.getLeftTupleMemory().contains(tuple0));
        CollectNodeTest.assertTrue((boolean)this.memory.betaMemory.getLeftTupleMemory().contains(tuple1));
        Assert.assertEquals((String)"Two tuples should have been propagated", (int)2, (int)this.sink.getAsserted().size());
    }

    public void testRetractTuple() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getRightTupleMemory().size());
        Assert.assertTrue((String)"An empty collection should be propagated", (boolean)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).isEmpty());
        this.node.retractLeftTuple(tuple0, this.contextRetract, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)1, (int)this.sink.getRetracted().size());
        CollectNodeTest.assertEquals((int)1, (int)this.sink.getAsserted().size());
    }

    public void testAssertObject() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)1, (int)this.sink.getAsserted().size());
        Assert.assertTrue((String)"An empty collection should be propagated", (boolean)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).isEmpty());
        this.node.assertObject((InternalFactHandle)f0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getRightTupleMemory().size());
        CollectNodeTest.assertEquals((int)2, (int)this.sink.getAsserted().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)1, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(1))[0]).get(1)).getObject()).size());
        this.node.assertObject((InternalFactHandle)f1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getRightTupleMemory().size());
        CollectNodeTest.assertEquals((int)3, (int)this.sink.getAsserted().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(2))[0]).get(1)).getObject()).size());
    }

    public void testRetractObject() {
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertObject((InternalFactHandle)f1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getRightTupleMemory().size());
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getLeftTupleMemory().size());
        CollectNodeTest.assertEquals((int)0, (int)this.sink.getRetracted().size());
        CollectNodeTest.assertEquals((int)1, (int)this.sink.getAsserted().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).size());
        this.node.retractRightTuple(f1.getRightTuple(), this.contextRetract, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)1, (int)this.memory.betaMemory.getRightTupleMemory().size());
        CollectNodeTest.assertEquals((int)1, (int)this.sink.getRetracted().size());
        CollectNodeTest.assertEquals((int)2, (int)this.sink.getAsserted().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)1, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(1))[0]).get(1)).getObject()).size());
        this.node.retractRightTuple(f0.getRightTuple(), this.contextRetract, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertEquals((int)0, (int)this.memory.betaMemory.getRightTupleMemory().size());
        CollectNodeTest.assertEquals((int)2, (int)this.sink.getRetracted().size());
        CollectNodeTest.assertEquals((int)3, (int)this.sink.getAsserted().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)0, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(2))[0]).get(1)).getObject()).size());
    }

    public void testMemory() {
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        ReteooWorkingMemory workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        MockObjectSource objectSource = new MockObjectSource(1);
        MockTupleSource tupleSource = new MockTupleSource(1);
        CollectNode collectNode = new CollectNode(2, (LeftTupleSource)tupleSource, (ObjectSource)objectSource, new AlphaNodeFieldConstraint[0], EmptyBetaConstraints.getInstance(), EmptyBetaConstraints.getInstance(), Behavior.EMPTY_BEHAVIOR_LIST, this.collect, false, buildContext);
        CollectNode.CollectMemory memory = (CollectNode.CollectMemory)workingMemory.getNodeMemory((NodeMemory)collectNode);
        CollectNodeTest.assertNotNull((Object)memory);
    }

    public void testAssertTupleSequentialMode() {
        RuleBaseConfiguration conf = new RuleBaseConfiguration();
        conf.setSequential(true);
        this.workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase((RuleBaseConfiguration)conf)));
        this.memory = (CollectNode.CollectMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
        this.node.setLeftTupleMemoryEnabled(false);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"cheese", null, null);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.getFactHandleFactory().newFactHandle((Object)"other cheese", null, null);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertObject((InternalFactHandle)f0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertObject((InternalFactHandle)f1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        this.node.assertLeftTuple(tuple0, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertNull((Object)this.memory.betaMemory.getLeftTupleMemory());
        CollectNodeTest.assertEquals((int)2, (int)this.memory.betaMemory.getRightTupleMemory().size());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(0))[0]).get(1)).getObject()).size());
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.contextAssert, (InternalWorkingMemory)this.workingMemory);
        CollectNodeTest.assertNull((Object)this.memory.betaMemory.getLeftTupleMemory());
        Assert.assertEquals((String)"Wrong number of elements in matching objects list ", (int)2, (int)((Collection)((DefaultFactHandle)((Tuple)((Object[])this.sink.getAsserted().get(1))[0]).get(1)).getObject()).size());
        Assert.assertEquals((String)"Two tuples should have been propagated", (int)2, (int)this.sink.getAsserted().size());
    }
}

