/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.beans.IntrospectionException;
import org.drools.Cheese;
import org.drools.DroolsTestCase;
import org.drools.FactException;
import org.drools.RuleBaseConfiguration;
import org.drools.RuleBaseFactory;
import org.drools.common.BetaConstraints;
import org.drools.common.DefaultBetaConstraints;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.ExistsNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.MockTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.RightInputAdapterNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.ContextEntry;
import org.drools.rule.Rule;
import org.drools.spi.BetaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;

public class ExistsNodeTest
extends DroolsTestCase {
    private final Mockery mockery = new Mockery();
    Rule rule;
    PropagationContext context;
    ReteooWorkingMemory workingMemory;
    MockObjectSource objectSource;
    MockTupleSource tupleSource;
    MockLeftTupleSink sink;
    ExistsNode node;
    RightInputAdapterNode ria;
    BetaMemory memory;
    BetaNodeFieldConstraint constraint;

    public void setUp() throws IntrospectionException {
        this.constraint = (BetaNodeFieldConstraint)this.mockery.mock(BetaNodeFieldConstraint.class);
        final ContextEntry c = (ContextEntry)this.mockery.mock(ContextEntry.class);
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).createContextEntry();
                this.will(1.returnValue((Object)c));
                ((ContextEntry)this.allowing(c)).updateFromFactHandle((InternalWorkingMemory)this.with(1.any(InternalWorkingMemory.class)), (InternalFactHandle)this.with(1.any(InternalFactHandle.class)));
                ((ContextEntry)this.allowing(c)).updateFromTuple((InternalWorkingMemory)this.with(1.any(InternalWorkingMemory.class)), (LeftTuple)this.with(1.any(LeftTuple.class)));
                ((ContextEntry)this.allowing(c)).resetTuple();
                ((ContextEntry)this.allowing(c)).resetFactHandle();
            }
        });
        this.rule = new Rule("test-rule");
        this.context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooRuleBase ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        BuildContext buildContext = new BuildContext((InternalRuleBase)ruleBase, ruleBase.getReteooBuilder().getIdGenerator());
        this.workingMemory = (ReteooWorkingMemory)ruleBase.newStatefulSession();
        RuleBaseConfiguration configuration = new RuleBaseConfiguration();
        this.node = new ExistsNode(15, (LeftTupleSource)new MockTupleSource(5), (ObjectSource)new MockObjectSource(8), (BetaConstraints)new DefaultBetaConstraints(new BetaNodeFieldConstraint[]{this.constraint}, configuration), Behavior.EMPTY_BEHAVIOR_LIST, buildContext);
        this.sink = new MockLeftTupleSink();
        this.node.addTupleSink((LeftTupleSink)this.sink);
        this.memory = (BetaMemory)this.workingMemory.getNodeMemory((NodeMemory)this.node);
    }

    public void testExistsStandard() throws FactException {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedLeft((ContextEntry)this.with(2.any(ContextEntry.class)), (InternalFactHandle)this.with(2.any(InternalFactHandle.class)));
                this.will(2.returnValue((Object)true));
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedRight((LeftTuple)this.with(2.any(LeftTuple.class)), (ContextEntry)this.with(2.any(ContextEntry.class)));
                this.will(2.returnValue((Object)true));
            }
        });
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        this.assertLength(1, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        ExistsNodeTest.assertEquals((Object)new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.sink, true), (Object)((Object[])this.sink.getAsserted().get(0))[0]);
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(2, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getRightTupleMemory().size());
        this.node.retractRightTuple(f1.getRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)2, (int)this.memory.getLeftTupleMemory().size());
        this.assertLength(2, this.sink.getAsserted());
        this.assertLength(2, this.sink.getRetracted());
    }

    public void testExistsWithConstraints() throws FactException {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedLeft((ContextEntry)this.with(3.any(ContextEntry.class)), (InternalFactHandle)this.with(3.any(InternalFactHandle.class)));
                this.will(3.returnValue((Object)false));
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedRight((LeftTuple)this.with(3.any(LeftTuple.class)), (ContextEntry)this.with(3.any(ContextEntry.class)));
                this.will(3.returnValue((Object)false));
            }
        });
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
        DefaultFactHandle f2 = (DefaultFactHandle)this.workingMemory.insert((Object)new Cheese("gouda", 10));
        LeftTuple tuple2 = new LeftTuple((InternalFactHandle)f2, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple2, this.context, (InternalWorkingMemory)this.workingMemory);
        this.assertLength(0, this.sink.getAsserted());
        this.assertLength(0, this.sink.getRetracted());
    }

    public void testExistsMemoryManagement() throws FactException {
        this.mockery.checking((ExpectationBuilder)new Expectations(){
            {
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedLeft((ContextEntry)this.with(4.any(ContextEntry.class)), (InternalFactHandle)this.with(4.any(InternalFactHandle.class)));
                this.will(4.returnValue((Object)true));
                ((BetaNodeFieldConstraint)this.allowing(ExistsNodeTest.this.constraint)).isAllowedCachedRight((LeftTuple)this.with(4.any(LeftTuple.class)), (ContextEntry)this.with(4.any(ContextEntry.class)));
                this.will(4.returnValue((Object)true));
            }
        });
        Cheese cheddar = new Cheese("cheddar", 10);
        DefaultFactHandle f0 = (DefaultFactHandle)this.workingMemory.insert((Object)cheddar);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)this.node, true);
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        Cheese brie = new Cheese("brie", 10);
        DefaultFactHandle f1 = (DefaultFactHandle)this.workingMemory.insert((Object)brie);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getRightTupleMemory().size());
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getRightTupleMemory().size());
        this.node.retractRightTuple(f1.getRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        this.node.assertObject((InternalFactHandle)f1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getRightTupleMemory().size());
        this.node.retractRightTuple(f1.getRightTuple(), this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getRightTupleMemory().size());
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        this.node.retractLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
        this.node.assertLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)1, (int)this.memory.getLeftTupleMemory().size());
        this.node.retractLeftTuple(tuple1, this.context, (InternalWorkingMemory)this.workingMemory);
        ExistsNodeTest.assertEquals((int)0, (int)this.memory.getLeftTupleMemory().size());
    }
}

