/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.lang.reflect.Field;
import java.util.List;
import org.drools.DroolsTestCase;
import org.drools.RuleBaseFactory;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.MockLeftTupleSink;
import org.drools.reteoo.MockObjectSource;
import org.drools.reteoo.ObjectSinkPropagator;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.builder.BuildContext;
import org.drools.runtime.rule.FactHandle;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;

public class LeftInputAdapterNodeTest
extends DroolsTestCase {
    private ReteooRuleBase ruleBase;
    private BuildContext buildContext;

    protected void setUp() throws Exception {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.buildContext = new BuildContext((InternalRuleBase)this.ruleBase, this.ruleBase.getReteooBuilder().getIdGenerator());
    }

    public void testLeftInputAdapterNode() {
        MockObjectSource source = new MockObjectSource(15);
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(23, (ObjectSource)source, this.buildContext);
        LeftInputAdapterNodeTest.assertEquals((int)23, (int)liaNode.getId());
        LeftInputAdapterNodeTest.assertEquals((int)0, (int)source.getAttached());
        source.attach();
        LeftInputAdapterNodeTest.assertEquals((int)1, (int)source.getAttached());
    }

    public void testAttach() throws Exception {
        MockObjectSource source = new MockObjectSource(15);
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(1, (ObjectSource)source, this.buildContext);
        Field field = ObjectSource.class.getDeclaredField("sink");
        field.setAccessible(true);
        ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get((Object)source);
        LeftInputAdapterNodeTest.assertEquals((int)1, (int)liaNode.getId());
        LeftInputAdapterNodeTest.assertNotNull((Object)sink);
        liaNode.attach();
        sink = (ObjectSinkPropagator)field.get((Object)source);
        LeftInputAdapterNodeTest.assertEquals((int)1, (int)sink.getSinks().length);
        LeftInputAdapterNodeTest.assertSame((Object)liaNode, (Object)sink.getSinks()[0]);
    }

    public void testAssertObjectWithoutMemory() throws Exception {
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        LeftInputAdapterNode liaNode = new LeftInputAdapterNode(1, (ObjectSource)new MockObjectSource(15), this.buildContext);
        MockLeftTupleSink sink = new MockLeftTupleSink();
        liaNode.addTupleSink((LeftTupleSink)sink);
        String string1 = "cheese";
        DefaultFactHandle f0 = (DefaultFactHandle)workingMemory.insert((Object)string1);
        liaNode.assertObject((InternalFactHandle)f0, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        List asserted = sink.getAsserted();
        this.assertLength(1, asserted);
        Tuple tuple0 = (Tuple)((Object[])asserted.get(0))[0];
        LeftInputAdapterNodeTest.assertSame((Object)string1, (Object)workingMemory.getObject((FactHandle)tuple0.get(0)));
    }
}

