/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.util.concurrent.ExecutorService;
import junit.framework.TestCase;
import org.drools.RuleBase;
import org.drools.RuleBaseFactory;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.PartitionTaskManager;
import org.jmock.Expectations;
import org.jmock.Mockery;
import org.jmock.internal.ExpectationBuilder;
import org.jmock.lib.concurrent.DeterministicScheduler;

public class PartitionTaskManagerTest
extends TestCase {
    Mockery context = new Mockery();
    private PartitionTaskManager manager;
    private InternalWorkingMemory workingMemory;

    public void setUp() {
        RuleBase rulebase = RuleBaseFactory.newRuleBase();
        this.workingMemory = (InternalWorkingMemory)rulebase.newStatefulSession();
        this.manager = new PartitionTaskManager(this.workingMemory);
    }

    protected void tearDown() throws Exception {
    }

    public void testEnqueueBeforeSettingExecutor() throws InterruptedException {
        final PartitionTaskManager.Action action = (PartitionTaskManager.Action)this.context.mock(PartitionTaskManager.Action.class);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PartitionTaskManager.Action)this.oneOf(action)).execute(PartitionTaskManagerTest.this.workingMemory);
            }
        });
        this.manager.enqueue(action);
        DeterministicScheduler pool = new DeterministicScheduler();
        this.manager.setPool((ExecutorService)pool);
        pool.runUntilIdle();
        this.context.assertIsSatisfied();
    }

    public void testFireCorrectly() throws InterruptedException {
        final PartitionTaskManager.Action action = (PartitionTaskManager.Action)this.context.mock(PartitionTaskManager.Action.class);
        DeterministicScheduler pool = new DeterministicScheduler();
        this.manager.setPool((ExecutorService)pool);
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PartitionTaskManager.Action)this.oneOf(action)).execute(PartitionTaskManagerTest.this.workingMemory);
            }
        });
        this.manager.enqueue(action);
        pool.runUntilIdle();
        this.context.assertIsSatisfied();
    }

    public void testActionCallbacks() throws InterruptedException {
        final PartitionTaskManager.Action action = (PartitionTaskManager.Action)this.context.mock(PartitionTaskManager.Action.class);
        DeterministicScheduler pool = new DeterministicScheduler();
        this.context.checking((ExpectationBuilder)new Expectations(){
            {
                ((PartitionTaskManager.Action)this.exactly(5).of((Object)action)).execute(PartitionTaskManagerTest.this.workingMemory);
            }
        });
        this.manager.enqueue(action);
        this.manager.enqueue(action);
        this.manager.setPool((ExecutorService)pool);
        this.manager.enqueue(action);
        this.manager.enqueue(action);
        this.manager.enqueue(action);
        pool.runUntilIdle();
        this.context.assertIsSatisfied();
    }
}

