/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import junit.framework.Assert;
import org.drools.DroolsTestCase;
import org.drools.RuleBaseFactory;
import org.drools.StatefulSession;
import org.drools.WorkingMemory;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.DialectRuntimeData;
import org.drools.rule.JavaDialectRuntimeData;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.spi.Consequence;
import org.drools.spi.KnowledgeHelper;

public class ReteooRuleBaseMultiThreadedTest
extends DroolsTestCase {
    ReteooRuleBase ruleBase;
    Rule rule;
    Package pkg;

    public void setUp() {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.pkg = new Package("org.droos.test");
        this.pkg.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        JavaDialectRuntimeData data = new JavaDialectRuntimeData();
        data.onAdd(this.pkg.getDialectRuntimeRegistry(), this.ruleBase.getRootClassLoader());
        this.pkg.getDialectRuntimeRegistry().setDialectData("java", (DialectRuntimeData)data);
        this.rule = new Rule("Test");
        this.rule.setDialect("java");
        this.rule.setConsequence(new Consequence(){

            public void evaluate(KnowledgeHelper knowledgeHelper, WorkingMemory workingMemory) throws Exception {
            }
        });
        this.pkg.addRule(this.rule);
        this.ruleBase.addPackage(this.pkg);
    }

    public void testNewSessionWhileModifyingRuleBase() throws InterruptedException {
        boolean deadlockDetected;
        PackageModifier modifier = new PackageModifier();
        SessionCreator creator = new SessionCreator();
        creator.start();
        modifier.start();
        Thread.sleep(10000L);
        boolean bl = deadlockDetected = creator.isBlocked() && modifier.isBlocked();
        if (deadlockDetected) {
            this.printThreadStatus(creator);
            this.printThreadStatus(modifier);
        }
        Assert.assertEquals((String)"Threads are deadlocked! See previous stacks for more detail", (boolean)false, (boolean)deadlockDetected);
        if (creator.isInError()) {
            creator.getError().printStackTrace();
        }
        Assert.assertEquals((String)"Exception in creator thread", (boolean)false, (boolean)creator.isInError());
        if (modifier.isInError()) {
            modifier.getError().printStackTrace();
        }
        Assert.assertEquals((String)"Exception in modifier thread", (boolean)false, (boolean)modifier.isInError());
    }

    private void printThreadStatus(Thread thread) {
        StackTraceElement[] frames = thread.getStackTrace();
        System.err.println(thread.getName() + ": " + (Object)((Object)thread.getState()));
        for (StackTraceElement frame : frames) {
            System.err.println(frame);
        }
        System.err.println();
    }

    private class SessionCreator
    extends BlockedThread {
        private SessionCreator() {
            super("Session Creator Thread");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void doOperation() {
            StatefulSession session = null;
            try {
                session = ReteooRuleBaseMultiThreadedTest.this.ruleBase.newStatefulSession();
            }
            finally {
                if (session != null) {
                    session.dispose();
                }
            }
        }
    }

    private class PackageModifier
    extends BlockedThread {
        private PackageModifier() {
            super("Rulebase Modifier Thread");
        }

        void doOperation() {
            ReteooRuleBaseMultiThreadedTest.this.ruleBase.removePackage(ReteooRuleBaseMultiThreadedTest.this.pkg.getName());
            ReteooRuleBaseMultiThreadedTest.this.ruleBase.addPackage(ReteooRuleBaseMultiThreadedTest.this.pkg);
        }
    }

    private abstract class BlockedThread
    extends Thread {
        private static final int NUMER_ATTEMPTS = 50000;
        private volatile Throwable error;

        BlockedThread(String name) {
            super(name);
            this.setDaemon(true);
        }

        public boolean isInError() {
            return this.error != null;
        }

        public Throwable getError() {
            return this.error;
        }

        public boolean isBlocked() {
            return this.getState() == Thread.State.BLOCKED;
        }

        public void run() {
            try {
                for (int numAttempts = 0; numAttempts < 50000; ++numAttempts) {
                    this.doOperation();
                }
            }
            catch (Throwable t) {
                this.error = t;
            }
        }

        abstract void doOperation();
    }
}

