/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import org.drools.DroolsTestCase;
import org.drools.RuleBaseFactory;
import org.drools.SessionConfiguration;
import org.drools.StatefulSession;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Package;

public class ReteooRuleBaseTest
extends DroolsTestCase {
    ReteooRuleBase ruleBase;
    StatefulSession wm1;
    StatefulSession wm2;
    StatefulSession wm3;
    StatefulSession wm4;

    public void setUp() {
        this.ruleBase = (ReteooRuleBase)RuleBaseFactory.newRuleBase();
        this.wm1 = this.ruleBase.newStatefulSession();
        this.wm2 = this.ruleBase.newStatefulSession();
        this.wm3 = this.ruleBase.newStatefulSession();
        this.wm4 = this.ruleBase.newStatefulSession();
    }

    public void testKeepReference() throws Exception {
        this.assertLength(4, this.ruleBase.getStatefulSessions());
        this.assertContains((Object)this.wm1, this.ruleBase.getStatefulSessions());
        this.assertContains((Object)this.wm2, this.ruleBase.getStatefulSessions());
        this.assertContains((Object)this.wm3, this.ruleBase.getStatefulSessions());
        this.assertContains((Object)this.wm4, this.ruleBase.getStatefulSessions());
    }

    public void testDispose() throws Exception {
        this.wm3.dispose();
        this.assertLength(3, this.ruleBase.getStatefulSessions());
        this.assertNotContains((Object)this.wm3, this.ruleBase.getStatefulSessions());
    }

    public void testNoKeepReference() throws Exception {
        SessionConfiguration conf = new SessionConfiguration();
        conf.setKeepReference(false);
        StatefulSession wm5 = this.ruleBase.newStatefulSession(conf, null);
        StatefulSession wm6 = this.ruleBase.newStatefulSession(conf, null);
        this.assertLength(4, this.ruleBase.getStatefulSessions());
        this.assertNotContains((Object)wm5, this.ruleBase.getStatefulSessions());
        this.assertNotContains((Object)wm6, this.ruleBase.getStatefulSessions());
    }

    public void testAddPackage() throws Exception {
        Package pkg1 = new Package("org.droos.test");
        pkg1.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg1.addGlobal("global1", Object.class);
        pkg1.addGlobal("global2", Object.class);
        Package pkg2 = new Package("org.droos.test");
        pkg2.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg2.addGlobal("global1", Object.class);
        pkg2.addGlobal("global3", Object.class);
        Package pkg3 = new Package("org.droos.test2");
        pkg3.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg3.addGlobal("global3", Object.class);
        pkg3.addGlobal("global4", Object.class);
        this.ruleBase.addPackage(pkg1);
        this.assertLength(1, this.ruleBase.getPackages());
        this.assertLength(2, this.ruleBase.getGlobals().values());
        this.assertLength(2, this.ruleBase.getPackages()[0].getGlobals().values());
        this.ruleBase.addPackage(pkg2);
        this.assertLength(1, this.ruleBase.getPackages());
        this.assertLength(3, this.ruleBase.getGlobals().values());
        this.assertLength(3, this.ruleBase.getPackages()[0].getGlobals().values());
        this.ruleBase.addPackage(pkg3);
        this.assertLength(2, this.ruleBase.getPackages());
        this.assertLength(4, this.ruleBase.getGlobals().values());
        Package[] pkgs = this.ruleBase.getPackages();
        for (int i = 0; i < pkgs.length; ++i) {
            if (!pkgs[i].getName().equals(pkg3.getName())) continue;
            this.assertLength(2, pkgs[i].getGlobals().values());
        }
    }

    public void testRemovePackage() throws Exception {
        Package pkg1 = new Package("org.droos.test");
        pkg1.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg1.addGlobal("global1", Object.class);
        pkg1.addGlobal("global2", Object.class);
        Package pkg2 = new Package("org.droos.test");
        pkg2.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg2.addGlobal("global1", Object.class);
        pkg2.addGlobal("global3", Object.class);
        Package pkg3 = new Package("org.droos.test2");
        pkg3.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        pkg3.addGlobal("global3", Object.class);
        pkg3.addGlobal("global4", Object.class);
        this.ruleBase.addPackage(pkg1);
        this.ruleBase.addPackage(pkg2);
        this.ruleBase.addPackage(pkg3);
        this.ruleBase.removePackage(pkg1.getName());
        this.assertLength(1, this.ruleBase.getPackages());
        this.assertLength(2, this.ruleBase.getGlobals().values());
        this.ruleBase.removePackage(pkg3.getName());
        this.assertLength(0, this.ruleBase.getPackages());
        this.assertLength(0, this.ruleBase.getGlobals().values());
    }
}

