/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.drools.DroolsTestCase;
import org.drools.base.ClassObjectType;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.InvalidPatternException;
import org.drools.rule.InvalidRuleException;
import org.drools.rule.LogicTransformer;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;
import org.drools.spi.ObjectType;
import org.drools.util.DroolsStreamUtils;

public class LogicTransformerTest
extends DroolsTestCase {
    public void testSingleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        GroupElement parent = GroupElementFactory.newAndInstance();
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        this.assertLength(2, parent.getChildren());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(0).getClass());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(1).getClass());
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        LogicTransformerTest.assertTrue((boolean)and1.isAnd());
        LogicTransformerTest.assertEquals((Object)a, and1.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and1.getChildren().get(1));
        GroupElement and2 = (GroupElement)parent.getChildren().get(1);
        LogicTransformerTest.assertEquals((Object)b, and2.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and2.getChildren().get(1));
    }

    public void testMultipleOrAndOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        GroupElement parent = GroupElementFactory.newAndInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        parent.addChild((RuleConditionElement)or);
        parent.addChild((RuleConditionElement)c);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        parent.addChild((RuleConditionElement)or2);
        GroupElement not = GroupElementFactory.newNotInstance();
        not.addChild((RuleConditionElement)f);
        parent.addChild((RuleConditionElement)not);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        LogicTransformerTest.assertEquals((Object)GroupElement.Type.OR, (Object)parent.getType());
        this.assertLength(4, parent.getChildren());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(0).getClass());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(1).getClass());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(2).getClass());
        LogicTransformerTest.assertEquals(GroupElement.class, parent.getChildren().get(3).getClass());
        GroupElement and1 = (GroupElement)parent.getChildren().get(0);
        LogicTransformerTest.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        LogicTransformerTest.assertEquals((Object)a, and1.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and1.getChildren().get(1));
        LogicTransformerTest.assertEquals((Object)d, and1.getChildren().get(2));
        LogicTransformerTest.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(1);
        LogicTransformerTest.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        LogicTransformerTest.assertEquals((Object)a, and1.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and1.getChildren().get(1));
        LogicTransformerTest.assertEquals((Object)e, and1.getChildren().get(2));
        LogicTransformerTest.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(2);
        LogicTransformerTest.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        LogicTransformerTest.assertEquals((Object)b, and1.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and1.getChildren().get(1));
        LogicTransformerTest.assertEquals((Object)d, and1.getChildren().get(2));
        LogicTransformerTest.assertEquals((Object)not, and1.getChildren().get(3));
        and1 = (GroupElement)parent.getChildren().get(3);
        LogicTransformerTest.assertTrue((boolean)and1.isAnd());
        this.assertLength(4, and1.getChildren());
        LogicTransformerTest.assertEquals((Object)b, and1.getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)c, and1.getChildren().get(1));
        LogicTransformerTest.assertEquals((Object)e, and1.getChildren().get(2));
        LogicTransformerTest.assertEquals((Object)not, and1.getChildren().get(3));
    }

    public void testNotOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newNotInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        LogicTransformerTest.assertTrue((boolean)parent.isAnd());
        LogicTransformerTest.assertEquals((int)2, (int)parent.getChildren().size());
        GroupElement b1 = (GroupElement)parent.getChildren().get(0);
        GroupElement b2 = (GroupElement)parent.getChildren().get(1);
        LogicTransformerTest.assertTrue((boolean)b1.isNot());
        LogicTransformerTest.assertTrue((boolean)b2.isNot());
        LogicTransformerTest.assertEquals((int)1, (int)b1.getChildren().size());
        LogicTransformerTest.assertEquals((Object)a, b1.getChildren().get(0));
        LogicTransformerTest.assertEquals((int)1, (int)b2.getChildren().size());
        LogicTransformerTest.assertEquals((Object)b, b2.getChildren().get(0));
    }

    public void testExistOrTransformation() throws InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        GroupElement parent = GroupElementFactory.newExistsInstance();
        GroupElement or = GroupElementFactory.newOrInstance();
        parent.addChild((RuleConditionElement)or);
        or.addChild((RuleConditionElement)a);
        or.addChild((RuleConditionElement)b);
        LogicTransformer.getInstance().applyOrTransformation(parent);
        LogicTransformerTest.assertTrue((boolean)parent.isOr());
        LogicTransformerTest.assertEquals((int)2, (int)parent.getChildren().size());
        GroupElement b1 = (GroupElement)parent.getChildren().get(0);
        GroupElement b2 = (GroupElement)parent.getChildren().get(1);
        LogicTransformerTest.assertTrue((boolean)b1.isExists());
        LogicTransformerTest.assertTrue((boolean)b2.isExists());
        LogicTransformerTest.assertEquals((int)1, (int)b1.getChildren().size());
        LogicTransformerTest.assertEquals((Object)a, b1.getChildren().get(0));
        LogicTransformerTest.assertEquals((int)1, (int)b2.getChildren().size());
        LogicTransformerTest.assertEquals((Object)b, b2.getChildren().get(0));
    }

    public void testEliminateEmptyBranchesAndDuplications() throws InvalidRuleException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)b);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)d);
        and1.addChild((RuleConditionElement)and2);
        GroupElement or = GroupElementFactory.newOrInstance();
        and1.addChild((RuleConditionElement)or);
        Object[] result = LogicTransformer.getInstance().transform(and1);
        this.assertLength(1, result);
        this.assertLength(4, result[0].getChildren());
        LogicTransformerTest.assertEquals((Object)a, result[0].getChildren().get(0));
        LogicTransformerTest.assertEquals((Object)b, result[0].getChildren().get(1));
        LogicTransformerTest.assertEquals((Object)c, result[0].getChildren().get(2));
        LogicTransformerTest.assertEquals((Object)d, result[0].getChildren().get(3));
    }

    public void testProcessTree() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern g = new Pattern(5, (ObjectType)type, "g");
        Pattern h = new Pattern(6, (ObjectType)type, "h");
        Pattern i = new Pattern(7, (ObjectType)type, "i");
        GroupElement and1 = GroupElementFactory.newAndInstance();
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        and1.addChild((RuleConditionElement)and2);
        and2.addChild((RuleConditionElement)b);
        GroupElement not1 = GroupElementFactory.newNotInstance();
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)not2);
        not2.addChild((RuleConditionElement)c);
        and2.addChild((RuleConditionElement)not1);
        and1.addChild((RuleConditionElement)d);
        GroupElement and3 = GroupElementFactory.newAndInstance();
        and3.addChild((RuleConditionElement)e);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        and3.addChild((RuleConditionElement)or1);
        GroupElement exist1 = GroupElementFactory.newExistsInstance();
        exist1.addChild((RuleConditionElement)g);
        or1.addChild((RuleConditionElement)h);
        or1.addChild((RuleConditionElement)exist1);
        GroupElement not3 = GroupElementFactory.newNotInstance();
        not3.addChild((RuleConditionElement)i);
        GroupElement root = GroupElementFactory.newAndInstance();
        root.addChild((RuleConditionElement)and1);
        root.addChild((RuleConditionElement)and3);
        root.addChild((RuleConditionElement)not3);
        GroupElement[] result = LogicTransformer.getInstance().transform(root);
        this.writeTree(result, "correct_processTree1.dat");
        GroupElement[] correctResultRoot = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("correct_processTree1.dat"));
        for (int j = 0; j < correctResultRoot.length; ++j) {
            LogicTransformerTest.assertEquals((Object)correctResultRoot[j], (Object)result[j]);
        }
    }

    public void testCloneable() {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        and.addChild((RuleConditionElement)a);
        and.addChild((RuleConditionElement)b);
        GroupElement or = GroupElementFactory.newOrInstance();
        or.addChild((RuleConditionElement)c);
        or.addChild((RuleConditionElement)d);
        and.addChild((RuleConditionElement)or);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)e);
        and2.addChild((RuleConditionElement)f);
        or.addChild((RuleConditionElement)and2);
        GroupElement not = GroupElementFactory.newNotInstance();
        and.addChild((RuleConditionElement)not);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        not.addChild((RuleConditionElement)or2);
        or2.addChild((RuleConditionElement)g);
        or2.addChild((RuleConditionElement)h);
        GroupElement cloned = (GroupElement)and.clone();
        LogicTransformerTest.assertEquals((Object)and, (Object)cloned);
    }

    public void testTransform() throws IOException, ClassNotFoundException, InvalidPatternException {
        ClassObjectType type = new ClassObjectType(String.class);
        Pattern a = new Pattern(0, (ObjectType)type, "a");
        Pattern b = new Pattern(1, (ObjectType)type, "b");
        Pattern c = new Pattern(2, (ObjectType)type, "c");
        Pattern d = new Pattern(3, (ObjectType)type, "d");
        Pattern e = new Pattern(4, (ObjectType)type, "e");
        Pattern f = new Pattern(5, (ObjectType)type, "f");
        Pattern g = new Pattern(6, (ObjectType)type, "g");
        Pattern h = new Pattern(7, (ObjectType)type, "h");
        GroupElement and = GroupElementFactory.newAndInstance();
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)a);
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)b);
        or1.addChild((RuleConditionElement)c);
        and1.addChild((RuleConditionElement)or1);
        and.addChild((RuleConditionElement)and1);
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)d);
        or2.addChild((RuleConditionElement)e);
        and.addChild((RuleConditionElement)or2);
        GroupElement and2 = GroupElementFactory.newAndInstance();
        GroupElement not1 = GroupElementFactory.newNotInstance();
        not1.addChild((RuleConditionElement)f);
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)g);
        GroupElement not2 = GroupElementFactory.newNotInstance();
        not2.addChild((RuleConditionElement)h);
        or3.addChild((RuleConditionElement)not2);
        and2.addChild((RuleConditionElement)not1);
        and2.addChild((RuleConditionElement)or3);
        and.addChild((RuleConditionElement)and2);
        GroupElement[] ands = LogicTransformer.getInstance().transform(and);
        this.writeTree(ands, "correct_transform1.dat");
        GroupElement[] correctResultAnds = (GroupElement[])DroolsStreamUtils.streamIn((InputStream)((Object)((Object)this)).getClass().getResourceAsStream("correct_transform1.dat"));
        for (int j = 0; j < ands.length; ++j) {
            LogicTransformerTest.assertEquals((Object)correctResultAnds[j], (Object)ands[j]);
        }
    }

    private void writeTree(Object object, String fileName) throws IOException {
        String className = ((Object)((Object)this)).getClass().getName();
        File file = new File(((Object)((Object)this)).getClass().getResource(className.substring(className.lastIndexOf(46) + 1) + ".class").getFile());
        file = new File(file.getParent().replaceAll("%20", " "), fileName);
        DroolsStreamUtils.streamOut((OutputStream)new FileOutputStream(file), (Object)object);
    }
}

