/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.base.ClassFieldReader;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EqualityEvaluatorsDefinition;
import org.drools.base.evaluators.Operator;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.RightTuple;
import org.drools.spi.InternalReadAccessor;
import org.drools.util.AbstractHashTable;
import org.drools.util.RightTupleList;

public class FieldIndexEntryTest
extends TestCase {
    EqualityEvaluatorsDefinition equals = new EqualityEvaluatorsDefinition();
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();

    protected void setUp() throws Exception {
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(Thread.currentThread().getContextClassLoader()));
        this.store.setEagerWire(true);
    }

    public void testSingleEntry() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        FieldIndexEntryTest.assertNull((Object)index.first);
        FieldIndexEntryTest.assertEquals((int)"stilton".hashCode(), (int)index.hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        index.add(h1RightTuple);
        RightTuple entry1 = index.first;
        FieldIndexEntryTest.assertSame((Object)h1, (Object)entry1.getFactHandle());
        FieldIndexEntryTest.assertNull((Object)entry1.getNext());
        FieldIndexEntryTest.assertSame((Object)entry1, (Object)index.get((InternalFactHandle)h1));
        RightTuple entry2 = index.get(new RightTuple((InternalFactHandle)h1, null));
        FieldIndexEntryTest.assertSame((Object)entry1, (Object)entry2);
        index.remove(h1RightTuple);
        FieldIndexEntryTest.assertNull((Object)index.first);
    }

    public void testTwoEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2, (Object)stilton2);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        RightTuple h2RightTuple = new RightTuple((InternalFactHandle)h2, null);
        index.add(h1RightTuple);
        index.add(h2RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)index.first.getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)index.get((InternalFactHandle)h1).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)index.get((InternalFactHandle)h2).getFactHandle());
        index.remove(h2RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h1RightTuple.getFactHandle(), (Object)index.first.getFactHandle());
        index.add(h2RightTuple);
        index.remove(h1RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h2RightTuple.getFactHandle(), (Object)index.first.getFactHandle());
        stilton1.setType("cheddar");
    }

    public void testThreeEntries() {
        ClassFieldReader extractor = this.store.getReader(Cheese.class, "type", ((Object)((Object)this)).getClass().getClassLoader());
        AbstractHashTable.FieldIndex fieldIndex = new AbstractHashTable.FieldIndex((InternalReadAccessor)extractor, null, this.equals.getEvaluator(ValueType.STRING_TYPE, Operator.EQUAL));
        AbstractHashTable.SingleIndex singleIndex = new AbstractHashTable.SingleIndex(new AbstractHashTable.FieldIndex[]{fieldIndex}, 1);
        RightTupleList index = new RightTupleList((AbstractHashTable.Index)singleIndex, "stilton".hashCode());
        Cheese stilton1 = new Cheese("stilton", 35);
        DefaultFactHandle h1 = new DefaultFactHandle(1, (Object)stilton1);
        Cheese stilton2 = new Cheese("stilton", 59);
        DefaultFactHandle h2 = new DefaultFactHandle(2, (Object)stilton2);
        Cheese stilton3 = new Cheese("stilton", 59);
        DefaultFactHandle h3 = new DefaultFactHandle(3, (Object)stilton3);
        RightTuple h1RightTuple = new RightTuple((InternalFactHandle)h1, null);
        RightTuple h2RightTuple = new RightTuple((InternalFactHandle)h2, null);
        RightTuple h3RightTuple = new RightTuple((InternalFactHandle)h3, null);
        index.add(h1RightTuple);
        index.add(h2RightTuple);
        index.add(h3RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h3, (Object)index.first.getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)((RightTuple)index.first.getNext().getNext()).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)index.get((InternalFactHandle)h1).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)index.get((InternalFactHandle)h2).getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h3, (Object)index.get((InternalFactHandle)h3).getFactHandle());
        index.remove(h3RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)index.first.getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.add(h3RightTuple);
        index.remove(h2RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h3, (Object)index.first.getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h1, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.add(h2RightTuple);
        index.remove(h1RightTuple);
        FieldIndexEntryTest.assertEquals((Object)h2, (Object)index.first.getFactHandle());
        FieldIndexEntryTest.assertEquals((Object)h3, (Object)((RightTuple)index.first.getNext()).getFactHandle());
        index.remove(index.first);
        stilton2.setType("cheddar");
    }
}

