/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import junit.framework.TestCase;
import org.drools.Cheese;
import org.drools.util.Entry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class ObjectHashMapTest
extends TestCase {
    public void testChechExistsFalse() {
        Entry entry;
        ObjectHashMap map = new ObjectHashMap();
        Cheese stilton = new Cheese("stilton", 5);
        map.put((Object)new Integer(1), (Object)stilton, false);
        Cheese c = (Cheese)map.get((Object)new Integer(1));
        ObjectHashMapTest.assertSame((Object)stilton, (Object)c);
        Cheese cheddar = new Cheese("cheddar", 5);
        map.put((Object)new Integer(1), (Object)cheddar, false);
        c = (Cheese)map.get((Object)new Integer(1));
        ObjectHashMapTest.assertSame((Object)cheddar, (Object)c);
        int size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        ObjectHashMapTest.assertEquals((int)2, (int)size);
        map.remove((Object)new Integer(1));
        size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        ObjectHashMapTest.assertEquals((int)1, (int)size);
    }

    public void testChechExistsTrue() {
        Entry entry;
        ObjectHashMap map = new ObjectHashMap();
        Cheese stilton = new Cheese("stilton", 5);
        map.put((Object)new Integer(1), (Object)stilton, true);
        Cheese c = (Cheese)map.get((Object)new Integer(1));
        ObjectHashMapTest.assertSame((Object)stilton, (Object)c);
        Cheese cheddar = new Cheese("cheddar", 5);
        map.put((Object)new Integer(1), (Object)cheddar);
        c = (Cheese)map.get((Object)new Integer(1));
        ObjectHashMapTest.assertSame((Object)cheddar, (Object)c);
        int size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        ObjectHashMapTest.assertEquals((int)1, (int)size);
        map.remove((Object)new Integer(1));
        size = 0;
        for (entry = map.getBucket((Object)new Integer(1)); entry != null; entry = entry.getNext()) {
            ++size;
        }
        ObjectHashMapTest.assertEquals((int)0, (int)size);
    }

    public void testEmptyIterator() {
        ObjectHashMap map = new ObjectHashMap();
        Iterator it = map.iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            ObjectHashMapTest.fail((String)"Map is empty, there should be no iteration");
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public void testStringData() {
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest.assertNotNull((Object)map);
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            String key = "key" + idx;
            String val = "value" + idx;
            map.put((Object)key, (Object)val);
            ObjectHashMapTest.assertEquals((Object)val, (Object)map.get((Object)key));
        }
    }

    public void testIntegerData() {
        ObjectHashMap map = new ObjectHashMap();
        ObjectHashMapTest.assertNotNull((Object)map);
        int count = 1000;
        for (int idx = 0; idx < 1000; ++idx) {
            Integer key = new Integer(idx);
            Integer val = new Integer(idx);
            map.put((Object)key, (Object)val);
            ObjectHashMapTest.assertEquals((Object)val, (Object)map.get((Object)key));
        }
    }
}

