/*
 * Decompiled with CFR 0.152.
 */
package org.drools;

import java.util.Properties;
import junit.framework.TestCase;
import org.drools.RuleBaseConfiguration;
import org.drools.SessionConfiguration;
import org.drools.common.ArrayAgendaGroupFactory;
import org.drools.common.PriorityQueueAgendaGroupFactory;
import org.drools.process.instance.impl.demo.DoNothingWorkItemHandler;
import org.drools.process.instance.impl.demo.SystemOutWorkItemHandler;
import org.drools.runtime.process.WorkItemHandler;

public class RuleBaseConfigurationTest
extends TestCase {
    public void testSystemProperties() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        System.setProperty("drools.assertBehaviour", "EQUALITY");
        cfg = new RuleBaseConfiguration();
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
        System.getProperties().remove("drools.assertBehaviour");
    }

    public void testProgrammaticPropertiesFile() {
        RuleBaseConfiguration cfg = new RuleBaseConfiguration();
        RuleBaseConfigurationTest.assertEquals((boolean)true, (boolean)cfg.isIndexLeftBetaMemory());
        Properties properties = new Properties();
        properties.setProperty("drools.indexLeftBetaMemory", "false");
        cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((boolean)false, (boolean)cfg.isIndexLeftBetaMemory());
        System.getProperties().remove("drools.indexLeftBetaMemory");
    }

    public void testAssertBehaviour() {
        Properties properties = new Properties();
        properties.setProperty("drools.assertBehaviour", "identity");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.IDENTITY, (Object)cfg.getAssertBehaviour());
        properties = new Properties();
        properties.setProperty("drools.assertBehaviour", "equality");
        cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.AssertBehaviour.EQUALITY, (Object)cfg.getAssertBehaviour());
    }

    public void testLogicalOverride() {
        Properties properties = new Properties();
        properties.setProperty("drools.logicalOverride", "preserve");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.LogicalOverride.PRESERVE, (Object)cfg.getLogicalOverride());
        properties = new Properties();
        properties.setProperty("drools.logicalOverride", "discard");
        cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.LogicalOverride.DISCARD, (Object)cfg.getLogicalOverride());
    }

    public void testSequential() {
        Properties properties = new Properties();
        properties.setProperty("drools.sequential", "false");
        RuleBaseConfiguration cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertFalse((boolean)cfg.isSequential());
        RuleBaseConfigurationTest.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "sequential");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertTrue((boolean)cfg.isSequential());
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.SEQUENTIAL, (Object)cfg.getSequentialAgenda());
        RuleBaseConfigurationTest.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof ArrayAgendaGroupFactory));
        properties = new Properties();
        properties.setProperty("drools.sequential.agenda", "dynamic");
        properties.setProperty("drools.sequential", "true");
        cfg = new RuleBaseConfiguration(properties);
        RuleBaseConfigurationTest.assertTrue((boolean)cfg.isSequential());
        RuleBaseConfigurationTest.assertEquals((Object)RuleBaseConfiguration.SequentialAgenda.DYNAMIC, (Object)cfg.getSequentialAgenda());
        RuleBaseConfigurationTest.assertTrue((boolean)(cfg.getAgendaGroupFactory() instanceof PriorityQueueAgendaGroupFactory));
    }

    public void testWorkItemHandlers() {
        Properties properties = new Properties();
        properties.setProperty("drools.workItemHandlers", "WorkItemHandlers1.conf WorkItemHandlers2.conf");
        SessionConfiguration cfg = new SessionConfiguration(properties);
        RuleBaseConfigurationTest.assertEquals((int)cfg.getWorkItemHandlers().size(), (int)3);
        RuleBaseConfigurationTest.assertEquals(((WorkItemHandler)cfg.getWorkItemHandlers().get("MyWork")).getClass(), SystemOutWorkItemHandler.class);
        RuleBaseConfigurationTest.assertEquals(((WorkItemHandler)cfg.getWorkItemHandlers().get("UIWork")).getClass(), SystemOutWorkItemHandler.class);
        RuleBaseConfigurationTest.assertEquals(((WorkItemHandler)cfg.getWorkItemHandlers().get("Log")).getClass(), DoNothingWorkItemHandler.class);
    }
}

