/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import junit.framework.TestCase;
import org.drools.base.FieldFactory;
import org.drools.base.ValueType;
import org.drools.base.evaluators.EvaluatorRegistry;
import org.drools.common.InternalWorkingMemory;
import org.drools.core.util.MathUtils;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Declaration;
import org.drools.rule.VariableRestriction;
import org.drools.spi.Evaluator;
import org.drools.spi.FieldValue;
import org.drools.spi.InternalReadAccessor;

public class EvaluatorFactoryTest
extends TestCase {
    private EvaluatorRegistry registry = new EvaluatorRegistry();

    public void testObject() {
        ArrayList<String> list = new ArrayList<String>();
        list.add("foo");
        list.add(null);
        List<String> col = Arrays.asList("foo", "bar", null);
        Object[][] data = new Object[][]{{"foo", "==", "bar", Boolean.FALSE}, {"foo", "==", "foo", Boolean.TRUE}, {"foo", "!=", "bar", Boolean.TRUE}, {list, "contains", "foo", Boolean.TRUE}, {list, "contains", "bar", Boolean.FALSE}, {list, "contains", null, Boolean.TRUE}, {null, "contains", "bar", Boolean.FALSE}, {null, "contains", null, Boolean.FALSE}, {list, "==", null, Boolean.FALSE}, {list, "!=", null, Boolean.TRUE}, {null, "==", null, Boolean.TRUE}, {null, "==", list, Boolean.FALSE}, {null, "!=", list, Boolean.TRUE}, {null, "<", new Integer(43), Boolean.FALSE}, {null, ">=", new Integer(-10), Boolean.FALSE}, {null, ">", new Integer(-10), Boolean.FALSE}, {null, "<=", new Integer(42), Boolean.FALSE}, {new BigDecimal("42.42"), "<", new BigDecimal("43"), Boolean.TRUE}, {new BigDecimal("42.42"), ">", new BigDecimal("43"), Boolean.FALSE}, {new BigDecimal("42.42"), "<=", new BigDecimal("42.42"), Boolean.TRUE}, {new BigInteger("42"), ">=", new BigInteger("43"), Boolean.FALSE}, {new BigInteger("42"), ">=", new BigInteger("43"), Boolean.FALSE}, {list, "excludes", "baz", Boolean.TRUE}, {list, "excludes", "foo", Boolean.FALSE}, {"foo", "memberOf", col, Boolean.TRUE}, {"xyz", "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.TRUE}, {"foo", "memberOf", null, Boolean.FALSE}, {"foo", "not memberOf", col, Boolean.FALSE}, {"xyz", "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.FALSE}, {"foo", "not memberOf", null, Boolean.FALSE}, {Boolean.TRUE, "==", "xyz", Boolean.FALSE}, {Boolean.TRUE, "==", "true", Boolean.TRUE}, {Boolean.FALSE, "==", "xyz", Boolean.TRUE}, {Boolean.FALSE, "==", "false", Boolean.TRUE}, {Boolean.FALSE, "==", "true", Boolean.FALSE}, {Boolean.TRUE, "!=", "xyz", Boolean.TRUE}, {Boolean.TRUE, "!=", "true", Boolean.FALSE}, {Boolean.FALSE, "!=", "xyz", Boolean.FALSE}, {Boolean.FALSE, "!=", "true", Boolean.TRUE}, {Boolean.FALSE, "!=", "false", Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.OBJECT_TYPE);
    }

    public void testArrayType() {
        Object[] field = new Object[]{"foo", "bar"};
        Object[][] data = new Object[][]{{field, "==", new Object[]{"foo"}, Boolean.FALSE}, {field, "==", field, Boolean.TRUE}, {field, "!=", new Object[]{"foo"}, Boolean.TRUE}, {field, "!=", null, Boolean.TRUE}, {field, "==", null, Boolean.FALSE}, {null, "==", field, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", field, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.ARRAY_TYPE);
    }

    public void testString() {
        List<String> col = Arrays.asList("foo", "bar", null);
        Object[][] data = new Object[][]{{"foo", "==", "bar", Boolean.FALSE}, {"foo", "==", "foo", Boolean.TRUE}, {"foo", "!=", "bar", Boolean.TRUE}, {"something foo", "matches", ".*foo", Boolean.TRUE}, {"foo", "matches", ".*foo", Boolean.TRUE}, {"foo", "matches", "bar", Boolean.FALSE}, {null, "matches", ".*foo", Boolean.FALSE}, {"something", "matches", "something", Boolean.TRUE}, {"something", "matches", "hello ;=", Boolean.FALSE}, {"something", "not matches", "something", Boolean.FALSE}, {"something", "not matches", "hello ;=", Boolean.TRUE}, {"foo", "==", null, Boolean.FALSE}, {"foo", "!=", null, Boolean.TRUE}, {null, "==", null, Boolean.TRUE}, {"foo", "!=", null, Boolean.TRUE}, {null, "!=", "foo", Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {"foo", "memberOf", col, Boolean.TRUE}, {"xyz", "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.TRUE}, {"foo", "memberOf", null, Boolean.FALSE}, {"foo", "not memberOf", col, Boolean.FALSE}, {"xyz", "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.FALSE}, {"foo", "not memberOf", null, Boolean.FALSE}, {"foobar", "soundslike", "fubar", Boolean.TRUE}, {"fubar", "soundslike", "foobar", Boolean.TRUE}, {"foobar", "soundslike", "wanklerotaryengine", Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.STRING_TYPE);
    }

    public void testInteger() {
        ArrayList<Integer> col = new ArrayList<Integer>();
        col.add(new Integer(42));
        col.add(new Integer(45));
        Object[][] data = new Object[][]{{new Integer(42), "==", new Integer(42), Boolean.TRUE}, {new Integer(42), "<", new Integer(43), Boolean.TRUE}, {new Integer(42), ">=", new Integer(41), Boolean.TRUE}, {new Integer(42), "!=", new Integer(41), Boolean.TRUE}, {new Integer(42), ">", new Integer(41), Boolean.TRUE}, {new Integer(42), "<=", new Integer(42), Boolean.TRUE}, {new Integer(42), ">", new Integer(100), Boolean.FALSE}, {new Integer(42), "!=", null, Boolean.TRUE}, {new Integer(42), "==", null, Boolean.FALSE}, {new Integer(42), ">", null, Boolean.FALSE}, {new Integer(42), ">=", null, Boolean.FALSE}, {new Integer(-42), "<", null, Boolean.FALSE}, {new Integer(-42), "<=", null, Boolean.FALSE}, {null, ">", null, Boolean.FALSE}, {null, ">=", null, Boolean.FALSE}, {null, "<", null, Boolean.FALSE}, {null, "<=", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Integer(42), Boolean.TRUE}, {null, "==", new Integer(42), Boolean.FALSE}, {null, "<", new Integer(43), Boolean.FALSE}, {null, ">=", new Integer(-10), Boolean.FALSE}, {null, ">", new Integer(-10), Boolean.FALSE}, {null, "<=", new Integer(42), Boolean.FALSE}, {new Integer(42), "memberOf", col, Boolean.TRUE}, {new Integer(43), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Integer(42), "memberOf", null, Boolean.FALSE}, {new Integer(42), "not memberOf", col, Boolean.FALSE}, {new Integer(43), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Integer(42), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PINTEGER_TYPE);
    }

    public void testBigDecimal() {
        ValueType type = ValueType.determineValueType(BigDecimal.class);
        EvaluatorFactoryTest.assertSame((Object)type, (Object)ValueType.BIG_DECIMAL_TYPE);
        ArrayList<BigDecimal> col = new ArrayList<BigDecimal>();
        col.add(new BigDecimal(42.0));
        col.add(new BigDecimal(45.0));
        Object[][] data = new Object[][]{{new BigDecimal(42), "==", new BigDecimal(42), Boolean.TRUE}, {new BigDecimal(42), "==", new BigDecimal("42.0"), Boolean.TRUE}, {new BigDecimal(42), "!=", new BigDecimal("42.0"), Boolean.FALSE}, {new BigDecimal(45), "==", new Double(45.0), Boolean.TRUE}, {new BigDecimal(45), "!=", new Double(45.0), Boolean.FALSE}, {new BigDecimal(42), "==", new BigInteger("42"), Boolean.TRUE}, {new BigDecimal(42), "!=", new BigInteger("42"), Boolean.FALSE}, {new BigDecimal(42), "<", new BigDecimal(43), Boolean.TRUE}, {new BigDecimal(42), ">=", new BigDecimal(41), Boolean.TRUE}, {new BigDecimal(42), ">=", new BigDecimal("41.0"), Boolean.TRUE}, {new BigDecimal(42), "!=", new BigDecimal(41), Boolean.TRUE}, {new BigDecimal(42), ">", new BigDecimal(41), Boolean.TRUE}, {new BigDecimal(42), "<=", new BigDecimal(42), Boolean.TRUE}, {new BigDecimal(42), ">", new BigDecimal(100), Boolean.FALSE}, {new BigDecimal(42), "<", new Double(43.0), Boolean.TRUE}, {new BigDecimal(42), ">=", new Double(41.0), Boolean.TRUE}, {new BigDecimal(42), ">", new Double(41.0), Boolean.TRUE}, {new BigDecimal(42), "<=", new Double(42.0), Boolean.TRUE}, {new BigDecimal(42), ">", new Double(100.0), Boolean.FALSE}, {new BigDecimal(42), "<", new BigInteger("43"), Boolean.TRUE}, {new BigDecimal(42), ">=", new BigInteger("41"), Boolean.TRUE}, {new BigDecimal(42), ">", new BigInteger("41"), Boolean.TRUE}, {new BigDecimal(42), "<=", new BigInteger("42"), Boolean.TRUE}, {new BigDecimal(42), ">", new BigInteger("100"), Boolean.FALSE}, {new BigDecimal(42), "==", null, Boolean.FALSE}, {new BigDecimal(42), "!=", null, Boolean.TRUE}, {null, "==", new BigDecimal(42), Boolean.FALSE}, {null, "!=", new BigDecimal(42), Boolean.TRUE}, {null, "<", new BigDecimal(43), Boolean.FALSE}, {null, ">=", new BigDecimal(-10), Boolean.FALSE}, {null, ">", new BigDecimal(-10), Boolean.FALSE}, {null, "<=", new BigDecimal(42), Boolean.FALSE}, {new BigDecimal(42), "memberOf", col, Boolean.TRUE}, {new BigDecimal(43), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new BigDecimal(42), "memberOf", null, Boolean.FALSE}, {new BigDecimal(42), "not memberOf", col, Boolean.FALSE}, {new BigDecimal(43), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new BigDecimal(42), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.BIG_DECIMAL_TYPE);
    }

    public void testBigInteger() {
        ValueType type = ValueType.determineValueType(BigInteger.class);
        EvaluatorFactoryTest.assertSame((Object)type, (Object)ValueType.BIG_INTEGER_TYPE);
        ArrayList<BigInteger> col = new ArrayList<BigInteger>();
        col.add(new BigInteger("42"));
        col.add(new BigInteger("45"));
        Object[][] data = new Object[][]{{new BigInteger("42"), "==", new BigInteger("42"), Boolean.TRUE}, {new BigInteger("42"), "==", new BigDecimal("42.0"), Boolean.TRUE}, {new BigInteger("42"), "==", new Double(42.0), Boolean.TRUE}, {new BigInteger("42"), "!=", new BigDecimal("43.0"), Boolean.TRUE}, {new BigInteger("42"), "!=", new Double(43.0), Boolean.TRUE}, {new BigInteger("42"), "<", new BigInteger("43"), Boolean.TRUE}, {new BigInteger("42"), ">=", new BigInteger("41"), Boolean.TRUE}, {new BigInteger("42"), "!=", new BigInteger("41"), Boolean.TRUE}, {new BigInteger("42"), ">", new BigInteger("41"), Boolean.TRUE}, {new BigInteger("42"), "<=", new BigInteger("42"), Boolean.TRUE}, {new BigInteger("42"), ">", new BigInteger("100"), Boolean.FALSE}, {new BigInteger("42"), "<", new Long("43"), Boolean.TRUE}, {new BigInteger("42"), ">=", new Long("41"), Boolean.TRUE}, {new BigInteger("42"), "!=", new Long("41"), Boolean.TRUE}, {new BigInteger("42"), ">", new Long("41"), Boolean.TRUE}, {new BigInteger("42"), "<=", new Long("42"), Boolean.TRUE}, {new BigInteger("42"), ">", new Long("100"), Boolean.FALSE}, {new BigInteger("42"), "==", null, Boolean.FALSE}, {new BigInteger("42"), "!=", null, Boolean.TRUE}, {null, "==", new BigInteger("42"), Boolean.FALSE}, {null, "!=", new BigInteger("42"), Boolean.TRUE}, {null, "<", new BigInteger("43"), Boolean.FALSE}, {null, ">=", new BigInteger("-10"), Boolean.FALSE}, {null, ">", new BigInteger("-10"), Boolean.FALSE}, {null, "<=", new BigInteger("42"), Boolean.FALSE}, {new BigInteger("42"), "memberOf", col, Boolean.TRUE}, {new BigInteger("43"), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new BigInteger("42"), "memberOf", null, Boolean.FALSE}, {new BigInteger("42"), "not memberOf", col, Boolean.FALSE}, {new BigInteger("43"), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new BigInteger("42"), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.BIG_INTEGER_TYPE);
    }

    public void testShort() {
        ArrayList<Short> col = new ArrayList<Short>();
        col.add(new Short(42));
        col.add(new Short(45));
        Object[][] data = new Object[][]{{new Short(42), "==", new Short(42), Boolean.TRUE}, {new Short(42), "<", new Short(43), Boolean.TRUE}, {new Short(42), ">=", new Short(41), Boolean.TRUE}, {new Short(42), "!=", new Short(41), Boolean.TRUE}, {new Short(42), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Short(42), Boolean.TRUE}, {null, "==", new Short(42), Boolean.FALSE}, {null, "<", new Short(43), Boolean.FALSE}, {null, ">=", new Short(-10), Boolean.FALSE}, {null, ">", new Short(-10), Boolean.FALSE}, {null, "<=", new Short(42), Boolean.FALSE}, {new Short(42), "memberOf", col, Boolean.TRUE}, {new Short(43), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Short(42), "memberOf", null, Boolean.FALSE}, {new Short(42), "not memberOf", col, Boolean.FALSE}, {new Short(43), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Short(42), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PSHORT_TYPE);
    }

    public void testBoolean() {
        ArrayList<Boolean> col = new ArrayList<Boolean>();
        col.add(new Boolean(true));
        col.add(new Boolean(true));
        Object[][] data = new Object[][]{{new Boolean(true), "==", new Boolean(true), Boolean.TRUE}, {new Boolean(false), "!=", new Boolean(true), Boolean.TRUE}, {new Boolean(true), "==", new Boolean(false), Boolean.FALSE}, {new Boolean(true), "!=", new Boolean(false), Boolean.TRUE}, {new Boolean(true), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Boolean(true), Boolean.TRUE}, {null, "==", new Boolean(true), Boolean.FALSE}, {new Boolean(true), "memberOf", col, Boolean.TRUE}, {new Boolean(false), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Boolean(true), "memberOf", null, Boolean.FALSE}, {new Boolean(true), "not memberOf", col, Boolean.FALSE}, {new Boolean(false), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Boolean(true), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PBOOLEAN_TYPE);
    }

    public void testDouble() {
        ArrayList<Double> col = new ArrayList<Double>();
        col.add(new Double(42.0));
        col.add(new Double(45.0));
        Object[][] data = new Object[][]{{new Double(42.0), "==", new Double(42.0), Boolean.TRUE}, {new Double(42.0), "<", new Double(43.0), Boolean.TRUE}, {new Double(42.0), ">=", new Double(41.0), Boolean.TRUE}, {new Double(42.0), "!=", new Double(41.0), Boolean.TRUE}, {new Double(42.0), ">", new Double(41.0), Boolean.TRUE}, {new Double(42.0), ">=", new Double(41.0), Boolean.TRUE}, {new Double(42.0), ">=", new Double(42.0), Boolean.TRUE}, {new Double(42.0), ">=", new Double(100.0), Boolean.FALSE}, {new Double(42.0), "<", new Double(1.0), Boolean.FALSE}, {new Double(42.0), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Double(42.0), Boolean.TRUE}, {null, "==", new Double(42.0), Boolean.FALSE}, {null, "<", new Double(43.0), Boolean.FALSE}, {null, ">=", new Double(-10.0), Boolean.FALSE}, {null, ">", new Double(-10.0), Boolean.FALSE}, {null, "<=", new Double(42.0), Boolean.FALSE}, {new Double(42.0), "memberOf", col, Boolean.TRUE}, {new Double(43.0), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Double(42.0), "memberOf", null, Boolean.FALSE}, {new Double(42.0), "not memberOf", col, Boolean.FALSE}, {new Double(43.0), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Double(42.0), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PDOUBLE_TYPE);
    }

    public void testFloat() {
        ArrayList<Float> col = new ArrayList<Float>();
        col.add(new Float(42.0f));
        col.add(new Float(45.0f));
        Object[][] data = new Object[][]{{new Float(42.0f), "==", new Float(42.0f), Boolean.TRUE}, {new Float(42.0f), "<", new Float(43.0f), Boolean.TRUE}, {new Float(42.0f), ">=", new Float(41.0f), Boolean.TRUE}, {new Float(42.0f), "!=", new Float(41.0f), Boolean.TRUE}, {new Float(42.0f), ">", new Float(41.0f), Boolean.TRUE}, {new Float(42.0f), ">=", new Float(41.0f), Boolean.TRUE}, {new Float(42.0f), ">=", new Float(42.0f), Boolean.TRUE}, {new Float(42.0f), ">=", new Float(100.0f), Boolean.FALSE}, {new Float(42.0f), "<", new Float(1.0f), Boolean.FALSE}, {new Float(42.0f), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Float(42.0f), Boolean.TRUE}, {null, "==", new Float(42.0f), Boolean.FALSE}, {null, "<", new Float(43.0f), Boolean.FALSE}, {null, ">=", new Float(-10.0f), Boolean.FALSE}, {null, ">", new Float(-10.0f), Boolean.FALSE}, {null, "<=", new Float(42.0f), Boolean.FALSE}, {new Float(42.0f), "memberOf", col, Boolean.TRUE}, {new Float(43.0f), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Float(42.0f), "memberOf", null, Boolean.FALSE}, {new Float(42.0f), "not memberOf", col, Boolean.FALSE}, {new Float(43.0f), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Float(42.0f), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PFLOAT_TYPE);
    }

    public void testLong() {
        ArrayList<Long> col = new ArrayList<Long>();
        col.add(new Long(42L));
        col.add(new Long(45L));
        Object[][] data = new Object[][]{{new Long(42L), "==", new Long(42L), Boolean.TRUE}, {new Long(42L), "<", new Long(43L), Boolean.TRUE}, {new Long(42L), ">=", new Long(41L), Boolean.TRUE}, {new Long(42L), "!=", new Long(41L), Boolean.TRUE}, {new Long(42L), ">", new Long(41L), Boolean.TRUE}, {new Long(42L), ">=", new Long(41L), Boolean.TRUE}, {new Long(42L), ">=", new Long(42L), Boolean.TRUE}, {new Long(42L), ">=", new Long(100L), Boolean.FALSE}, {new Long(42L), "<", new Long(1L), Boolean.FALSE}, {new Long(42L), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Long(42L), Boolean.TRUE}, {null, "==", new Long(42L), Boolean.FALSE}, {null, "<", new Long(43L), Boolean.FALSE}, {null, ">=", new Long(-10L), Boolean.FALSE}, {null, ">", new Long(-10L), Boolean.FALSE}, {null, "<=", new Long(42L), Boolean.FALSE}, {new Long(42L), "memberOf", col, Boolean.TRUE}, {new Long(43L), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Long(42L), "memberOf", null, Boolean.FALSE}, {new Long(42L), "not memberOf", col, Boolean.FALSE}, {new Long(43L), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Long(42L), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PLONG_TYPE);
    }

    public void testCharacter() {
        ArrayList<Character> col = new ArrayList<Character>();
        col.add(new Character('a'));
        col.add(new Character('b'));
        Object[][] data = new Object[][]{{new Character('a'), "==", new Character('a'), Boolean.TRUE}, {new Character('a'), "<", new Character('b'), Boolean.TRUE}, {new Character('a'), ">=", new Character('a'), Boolean.TRUE}, {new Character('a'), "!=", new Character('Z'), Boolean.TRUE}, {new Character('z'), ">", new Character('a'), Boolean.TRUE}, {new Character('z'), ">=", new Character('z'), Boolean.TRUE}, {new Character('z'), ">=", new Character('a'), Boolean.TRUE}, {new Character('a'), ">=", new Character('z'), Boolean.FALSE}, {new Character('z'), "<", new Character('a'), Boolean.FALSE}, {new Character('z'), "==", null, Boolean.FALSE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Character('z'), Boolean.TRUE}, {null, "==", new Character('z'), Boolean.FALSE}, {null, "<", new Character('a'), Boolean.FALSE}, {null, ">=", new Character('\u0000'), Boolean.FALSE}, {null, ">", new Character('\u0000'), Boolean.FALSE}, {null, "<=", new Character('a'), Boolean.FALSE}, {new Character('a'), "memberOf", col, Boolean.TRUE}, {new Character('z'), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Character('a'), "memberOf", null, Boolean.FALSE}, {new Character('a'), "not memberOf", col, Boolean.FALSE}, {new Character('z'), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Character('a'), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PCHAR_TYPE);
    }

    public void testDate() throws Exception {
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        ArrayList<Date> col = new ArrayList<Date>();
        col.add(df.parse("10-Jul-1974"));
        col.add(df.parse("11-Jul-1974"));
        Object[][] data = new Object[][]{{df.parse("10-Jul-1974"), "==", df.parse("10-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), "<", df.parse("11-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), ">=", df.parse("10-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), "!=", df.parse("11-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-2000"), ">", df.parse("10-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), ">=", df.parse("10-Jul-1974"), Boolean.TRUE}, {df.parse("11-Jul-1974"), ">=", df.parse("10-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), ">=", df.parse("11-Jul-1974"), Boolean.FALSE}, {df.parse("10-Jul-2000"), "<", df.parse("10-Jul-1974"), Boolean.FALSE}, {df.parse("10-Jul-1974"), "<", df.parse("11-Jul-1974"), Boolean.TRUE}, {df.parse("10-Jul-1974"), "==", null, Boolean.FALSE}, {df.parse("10-Jul-1974"), "!=", null, Boolean.TRUE}, {null, "==", null, Boolean.TRUE}, {null, "==", df.parse("10-Jul-1974"), Boolean.FALSE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", df.parse("10-Jul-1974"), Boolean.TRUE}, {null, "<", df.parse("10-Jul-1974"), Boolean.FALSE}, {null, ">=", new Date(0L), Boolean.FALSE}, {null, ">", new Date(0L), Boolean.FALSE}, {null, "<=", df.parse("10-Jul-1974"), Boolean.FALSE}, {df.parse("10-Jul-1974"), "memberOf", col, Boolean.TRUE}, {df.parse("15-Jul-1974"), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {df.parse("10-Jul-1974"), "memberOf", null, Boolean.FALSE}, {df.parse("10-Jul-1974"), "not memberOf", col, Boolean.FALSE}, {df.parse("15-Jul-1974"), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {df.parse("10-Jul-1974"), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.DATE_TYPE);
    }

    public void testByte() {
        ArrayList<Byte> col = new ArrayList<Byte>();
        col.add(new Byte("1"));
        col.add(new Byte("2"));
        Object[][] data = new Object[][]{{new Byte("1"), "==", new Byte("1"), Boolean.TRUE}, {new Byte("1"), "==", new Byte("2"), Boolean.FALSE}, {new Byte("1"), "!=", new Byte("2"), Boolean.TRUE}, {new Byte("1"), "!=", new Byte("1"), Boolean.FALSE}, {new Byte("1"), "<=", new Byte("1"), Boolean.TRUE}, {new Byte("1"), "==", null, Boolean.FALSE}, {new Byte("1"), "<", new Byte("2"), Boolean.TRUE}, {new Byte("2"), ">=", new Byte("1"), Boolean.TRUE}, {new Byte("2"), ">", new Byte("1"), Boolean.TRUE}, {new Byte("1"), "<=", new Byte("2"), Boolean.TRUE}, {null, "==", null, Boolean.TRUE}, {null, "!=", null, Boolean.FALSE}, {null, "!=", new Byte("1"), Boolean.TRUE}, {null, "==", new Byte("1"), Boolean.FALSE}, {null, "<", new Byte(127), Boolean.FALSE}, {null, ">=", new Byte(-128), Boolean.FALSE}, {null, ">", new Byte(-128), Boolean.FALSE}, {null, "<=", new Byte(127), Boolean.FALSE}, {new Byte("1"), "memberOf", col, Boolean.TRUE}, {new Byte("3"), "memberOf", col, Boolean.FALSE}, {null, "memberOf", col, Boolean.FALSE}, {new Byte("1"), "memberOf", null, Boolean.FALSE}, {new Byte("1"), "not memberOf", col, Boolean.FALSE}, {new Byte("3"), "not memberOf", col, Boolean.TRUE}, {null, "not memberOf", col, Boolean.TRUE}, {new Byte("1"), "not memberOf", null, Boolean.FALSE}};
        this.runEvaluatorTest(data, ValueType.PBYTE_TYPE);
    }

    private void runEvaluatorTest(Object[][] data, ValueType valueType) {
        MockExtractor extractor = new MockExtractor();
        for (int i = 0; i < data.length; ++i) {
            Object[] row = data[i];
            boolean isNegated = ((String)row[1]).startsWith("not ");
            String evaluatorStr = isNegated ? ((String)row[1]).substring(4) : (String)row[1];
            Evaluator evaluator = this.registry.getEvaluatorDefinition(evaluatorStr).getEvaluator(valueType, evaluatorStr, isNegated, null);
            this.checkEvaluatorMethodWithFieldValue(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedRight(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodCachedLeft(valueType, extractor, row, evaluator);
            this.checkEvaluatorMethodWith2Extractors(valueType, extractor, row, evaluator);
            EvaluatorFactoryTest.assertEquals((Object)valueType, (Object)evaluator.getValueType());
        }
    }

    private void checkEvaluatorMethodWithFieldValue(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        FieldValue value = FieldFactory.getFieldValue((Object)row[2]);
        boolean result = evaluator.evaluate((InternalWorkingMemory)new ReteooRuleBase("id1").newStatefulSession(), extractor, row[0], value);
        String message = "The evaluator type: [" + valueType + "] with FieldValue incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            EvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            EvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedRight(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedRight((InternalWorkingMemory)new ReteooRuleBase("id1").newStatefulSession(), context, row[2]);
        String message = "The evaluator type: [" + valueType + "] with CachedRight incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            EvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            EvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodCachedLeft(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        VariableRestriction.VariableContextEntry context = this.getContextEntry(evaluator, extractor, valueType, row);
        boolean result = evaluator.evaluateCachedLeft((InternalWorkingMemory)new ReteooRuleBase("id1").newStatefulSession(), context, row[0]);
        String message = "The evaluator type: [" + valueType + "] with CachedLeft incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            EvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            EvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private void checkEvaluatorMethodWith2Extractors(ValueType valueType, InternalReadAccessor extractor, Object[] row, Evaluator evaluator) {
        boolean result = evaluator.evaluate(null, extractor, row[0], extractor, row[2]);
        String message = "The evaluator type: [" + valueType + "] with 2 extractors incorrectly returned " + result + " for [" + row[0] + " " + row[1] + " " + row[2] + "]. It was asserted to return " + row[3];
        if (row[3] == Boolean.TRUE) {
            EvaluatorFactoryTest.assertTrue((String)message, (boolean)result);
        } else {
            EvaluatorFactoryTest.assertFalse((String)message, (boolean)result);
        }
    }

    private VariableRestriction.VariableContextEntry getContextEntry(Evaluator evaluator, InternalReadAccessor extractor, ValueType valueType, Object[] row) {
        Declaration declaration = new Declaration("test", extractor, null);
        ValueType coerced = evaluator.getCoercedValueType();
        if (coerced.isIntegerNumber()) {
            VariableRestriction.LongVariableContextEntry context = new VariableRestriction.LongVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).longValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).longValue();
            }
            return context;
        }
        if (coerced.isChar()) {
            VariableRestriction.CharVariableContextEntry context = new VariableRestriction.CharVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Character)row[2]).charValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Character)row[0]).charValue();
            }
            return context;
        }
        if (coerced.isBoolean()) {
            VariableRestriction.BooleanVariableContextEntry context = new VariableRestriction.BooleanVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = (Boolean)row[2];
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = (Boolean)row[0];
            }
            return context;
        }
        if (coerced.isFloatNumber()) {
            VariableRestriction.DoubleVariableContextEntry context = new VariableRestriction.DoubleVariableContextEntry(extractor, declaration, evaluator);
            if (row[2] == null) {
                context.leftNull = true;
            } else {
                context.left = ((Number)row[2]).doubleValue();
            }
            if (row[0] == null) {
                context.rightNull = true;
            } else {
                context.right = ((Number)row[0]).doubleValue();
            }
            return context;
        }
        VariableRestriction.ObjectVariableContextEntry context = new VariableRestriction.ObjectVariableContextEntry(extractor, declaration, evaluator);
        if (row[2] == null) {
            context.leftNull = true;
        } else {
            context.left = row[2];
        }
        if (row[0] == null) {
            context.rightNull = true;
        } else {
            context.right = row[0];
        }
        return context;
    }

    private static class MockExtractor
    implements InternalReadAccessor {
        private static final long serialVersionUID = 400L;

        private MockExtractor() {
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput out) throws IOException {
        }

        public boolean isSelfReference() {
            return false;
        }

        public boolean getBooleanValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? (Boolean)object : false;
        }

        public byte getByteValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).byteValue() : (byte)0;
        }

        public char getCharValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Character)object).charValue() : (char)'\u0000';
        }

        public double getDoubleValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).doubleValue() : 0.0;
        }

        public Class getExtractToClass() {
            return null;
        }

        public String getExtractToClassName() {
            return null;
        }

        public float getFloatValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).floatValue() : 0.0f;
        }

        public int getHashCode(InternalWorkingMemory workingMemory, Object object) {
            return 0;
        }

        public int getIntValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).intValue() : 0;
        }

        public long getLongValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).longValue() : 0L;
        }

        public Method getNativeReadMethod() {
            return null;
        }

        public short getShortValue(InternalWorkingMemory workingMemory, Object object) {
            return object != null ? ((Number)object).shortValue() : (short)0;
        }

        public Object getValue(InternalWorkingMemory workingMemory, Object object) {
            return object;
        }

        public boolean isNullValue(InternalWorkingMemory workingMemory, Object object) {
            return object == null;
        }

        public ValueType getValueType() {
            return null;
        }

        public int getIndex() {
            return 0;
        }

        public boolean isGlobal() {
            return false;
        }

        public boolean getBooleanValue(Object object) {
            return false;
        }

        public byte getByteValue(Object object) {
            return 0;
        }

        public char getCharValue(Object object) {
            return '\u0000';
        }

        public double getDoubleValue(Object object) {
            return 0.0;
        }

        public float getFloatValue(Object object) {
            return 0.0f;
        }

        public int getHashCode(Object object) {
            return 0;
        }

        public int getIntValue(Object object) {
            return 0;
        }

        public long getLongValue(Object object) {
            return 0L;
        }

        public short getShortValue(Object object) {
            return 0;
        }

        public Object getValue(Object object) {
            return null;
        }

        public boolean isNullValue(Object object) {
            return false;
        }

        public BigDecimal getBigDecimalValue(InternalWorkingMemory workingMemory, Object object) {
            return MathUtils.getBigDecimal((Object)object);
        }

        public BigInteger getBigIntegerValue(InternalWorkingMemory workingMemory, Object object) {
            return MathUtils.getBigInteger((Object)object);
        }

        public BigDecimal getBigDecimalValue(Object object) {
            return MathUtils.getBigDecimal((Object)object);
        }

        public BigInteger getBigIntegerValue(Object object) {
            return MathUtils.getBigInteger((Object)object);
        }
    }
}

