/*
 * Decompiled with CFR 0.152.
 */
package org.drools.factmodel;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.base.ClassFieldAccessorCache;
import org.drools.base.ClassFieldAccessorStore;
import org.drools.factmodel.ClassBuilder;
import org.drools.factmodel.ClassDefinition;
import org.drools.factmodel.FieldDefinition;

public class ClassBuilderTest
extends TestCase {
    ClassFieldAccessorStore store = new ClassFieldAccessorStore();
    private ClassLoader classLoader;

    protected void setUp() throws Exception {
        super.setUp();
        this.classLoader = ((Object)((Object)this)).getClass().getClassLoader();
        this.store.setClassFieldAccessorCache(new ClassFieldAccessorCache(this.classLoader));
        this.store.setEagerWire(true);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testBuildClass() {
        try {
            ClassBuilder builder = new ClassBuilder();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass1", null, new String[]{"java.io.Serializable"});
            FieldDefinition intDef = new FieldDefinition("intAttr", "int");
            FieldDefinition stringDef = new FieldDefinition("stringAttr", "java.lang.String");
            classDef.addField(intDef);
            classDef.addField(stringDef);
            Class clazz = builder.buildAndLoadClass(classDef);
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            stringDef.setReadWriteAccessor(this.store.getAccessor(clazz, stringDef.getName(), this.classLoader));
            byte[] data = builder.buildClass(classDef);
            Assert.assertSame((String)"Returned class should be the same", (Object)clazz, (Object)classDef.getDefinedClass());
            Assert.assertEquals((String)"Class name should be equal", (String)classDef.getClassName(), (String)clazz.getName());
            Serializable instance = (Serializable)clazz.newInstance();
            String stringValue = "Atributo String ok";
            stringDef.setValue((Object)instance, (Object)stringValue);
            Assert.assertEquals((String)"Attribute should have been correctly set", (Object)stringValue, (Object)stringDef.getValue((Object)instance));
            int intValue = 50;
            intDef.setValue((Object)instance, (Object)new Integer(intValue));
            Assert.assertEquals((String)"Attribute should have been correctly set", (int)intValue, (int)((Integer)intDef.getValue((Object)instance)));
            clazz = builder.buildAndLoadClass(classDef);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Error creating class");
        }
    }

    private void writeJar(byte[] data) throws FileNotFoundException, IOException {
        FileOutputStream out = new FileOutputStream(new File("/Users/michaelneale/edson.jar"));
        JarOutputStream jout = new JarOutputStream(out);
        JarEntry je = new JarEntry("br/com/auster/TestClass1.class");
        jout.putNextEntry(je);
        jout.write(data);
        jout.closeEntry();
        jout.close();
    }

    public void testEquals() {
        try {
            ClassBuilder builder = new ClassBuilder();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass2", null, new String[0]);
            FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
            FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
            FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
            FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
            FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
            classDef.addField(long1Def);
            classDef.addField(long2Def);
            classDef.addField(doubleDef);
            classDef.addField(intDef);
            classDef.addField(strDef);
            classDef.addField(dateDef);
            classDef.addField(str2Def);
            Class clazz = builder.buildAndLoadClass(classDef);
            long1Def.setReadWriteAccessor(this.store.getAccessor(clazz, long1Def.getName(), this.classLoader));
            long2Def.setReadWriteAccessor(this.store.getAccessor(clazz, long2Def.getName(), this.classLoader));
            doubleDef.setReadWriteAccessor(this.store.getAccessor(clazz, doubleDef.getName(), this.classLoader));
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            dateDef.setReadWriteAccessor(this.store.getAccessor(clazz, dateDef.getName(), this.classLoader));
            str2Def.setReadWriteAccessor(this.store.getAccessor(clazz, str2Def.getName(), this.classLoader));
            Object x = clazz.newInstance();
            Object y = clazz.newInstance();
            long1Def.setValue(x, (Object)new Long(20L));
            long2Def.setValue(x, (Object)new Long(30L));
            doubleDef.setValue(x, (Object)new Double(50.0));
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            dateDef.setValue(x, (Object)new Date(1000L));
            str2Def.setValue(x, (Object)"instance1");
            long1Def.setValue(y, (Object)new Long(20L));
            long2Def.setValue(y, (Object)new Long(30L));
            doubleDef.setValue(y, (Object)new Double(50.0));
            intDef.setValue(y, (Object)new Integer(10));
            strDef.setValue(y, (Object)"abc");
            dateDef.setValue(y, (Object)new Date(1000L));
            str2Def.setValue(y, (Object)"instance2");
            Object o = new Object();
            Assert.assertTrue((boolean)x.equals(x));
            Assert.assertFalse((boolean)x.equals(null));
            Assert.assertFalse((boolean)x.equals(o));
            Assert.assertTrue((boolean)x.equals(y));
            intDef.setValue(y, (Object)new Integer(1));
            Assert.assertFalse((boolean)x.equals(y));
            intDef.setValue(y, (Object)new Integer(10));
            strDef.setValue(y, (Object)"xyz");
            Assert.assertFalse((boolean)x.equals(y));
            strDef.setValue(y, null);
            Assert.assertFalse((boolean)x.equals(y));
            strDef.setValue(y, (Object)"abc");
            dateDef.setValue(y, (Object)new Date(1L));
            Assert.assertFalse((boolean)x.equals(y));
            dateDef.setValue(y, null);
            Assert.assertFalse((boolean)x.equals(y));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    public void testHashCode() {
        try {
            ClassBuilder builder = new ClassBuilder();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass3", null, new String[0]);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", false);
            classDef.addField(intDef);
            classDef.addField(strDef);
            Class clazz = builder.buildAndLoadClass(classDef);
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            Object x = clazz.newInstance();
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            Assert.assertEquals((String)"Wrong hashcode calculation", (int)41, (int)x.hashCode());
            Assert.assertEquals((String)"Wrong hashcode calculation", (int)x.hashCode(), (int)x.hashCode());
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }

    public void testToString() {
        try {
            ClassBuilder builder = new ClassBuilder();
            ClassDefinition classDef = new ClassDefinition("org.drools.TestClass4", null, new String[0]);
            FieldDefinition long1Def = new FieldDefinition("longAttr1", "long", true);
            FieldDefinition long2Def = new FieldDefinition("longAttr2", "long", true);
            FieldDefinition doubleDef = new FieldDefinition("doubleAttr", "double", true);
            FieldDefinition intDef = new FieldDefinition("intAttr", "int", true);
            FieldDefinition strDef = new FieldDefinition("stringAttr", "java.lang.String", true);
            FieldDefinition dateDef = new FieldDefinition("dateAttr", "java.util.Date", true);
            FieldDefinition str2Def = new FieldDefinition("stringAttr2", "java.lang.String");
            classDef.addField(long1Def);
            classDef.addField(long2Def);
            classDef.addField(doubleDef);
            classDef.addField(intDef);
            classDef.addField(strDef);
            classDef.addField(dateDef);
            classDef.addField(str2Def);
            Class clazz = builder.buildAndLoadClass(classDef);
            long1Def.setReadWriteAccessor(this.store.getAccessor(clazz, long1Def.getName(), this.classLoader));
            long2Def.setReadWriteAccessor(this.store.getAccessor(clazz, long2Def.getName(), this.classLoader));
            doubleDef.setReadWriteAccessor(this.store.getAccessor(clazz, doubleDef.getName(), this.classLoader));
            intDef.setReadWriteAccessor(this.store.getAccessor(clazz, intDef.getName(), this.classLoader));
            strDef.setReadWriteAccessor(this.store.getAccessor(clazz, strDef.getName(), this.classLoader));
            dateDef.setReadWriteAccessor(this.store.getAccessor(clazz, dateDef.getName(), this.classLoader));
            str2Def.setReadWriteAccessor(this.store.getAccessor(clazz, str2Def.getName(), this.classLoader));
            Object x = clazz.newInstance();
            long1Def.setValue(x, (Object)new Long(20L));
            long2Def.setValue(x, (Object)new Long(30L));
            doubleDef.setValue(x, (Object)new Double(50.0));
            intDef.setValue(x, (Object)new Integer(10));
            strDef.setValue(x, (Object)"abc");
            dateDef.setValue(x, (Object)new Date(1000L));
            str2Def.setValue(x, (Object)"instance1");
            String result = x.toString();
            Assert.assertTrue((boolean)result.contains(long1Def.getName()));
            Assert.assertTrue((boolean)result.contains(long2Def.getName()));
            Assert.assertTrue((boolean)result.contains(doubleDef.getName()));
            Assert.assertTrue((boolean)result.contains(intDef.getName()));
            Assert.assertTrue((boolean)result.contains(strDef.getName()));
            Assert.assertTrue((boolean)result.contains(dateDef.getName()));
            Assert.assertTrue((boolean)result.contains(str2Def.getName()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assert.fail((String)"Exception not expected");
        }
    }
}

