/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.List;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.spi.PropagationContext;

public class MockObjectSource
extends ObjectSource {
    private static final long serialVersionUID = 400L;
    private int attached;
    private int updated;
    private List facts;

    public MockObjectSource() {
    }

    public MockObjectSource(int id) {
        super(id, RuleBasePartitionId.MAIN_PARTITION, false);
        this.facts = new ArrayList();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.attached = in.readInt();
        this.updated = in.readInt();
        this.facts = (List)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeInt(this.attached);
        out.writeInt(this.updated);
        out.writeObject(this.facts);
    }

    public void attach() {
        ++this.attached;
    }

    public int getAttached() {
        return this.attached;
    }

    public int getUdated() {
        return this.updated;
    }

    public void addFact(InternalFactHandle handle) {
        this.facts.add(handle);
    }

    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ++this.updated;
        for (InternalFactHandle handle : this.facts) {
            sink.assertObject(handle, context, workingMemory);
        }
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
    }
}

