/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.drools.Person;
import org.drools.RuleBaseFactory;
import org.drools.WorkingMemory;
import org.drools.base.ClassObjectType;
import org.drools.common.DefaultFactHandle;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalRuleBase;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.JoinNode;
import org.drools.reteoo.LeftInputAdapterNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.reteoo.ReteooWorkingMemory;
import org.drools.reteoo.test.ReteDslTestEngine;
import org.drools.reteoo.test.dsl.DslStep;
import org.drools.reteoo.test.dsl.NodeTestCase;
import org.drools.reteoo.test.dsl.NodeTestCaseResult;
import org.drools.reteoo.test.dsl.NodeTestDef;
import org.drools.rule.Declaration;
import org.drools.spi.PropagationContext;
import org.junit.runner.notification.RunNotifier;

public class ReteDslTestEngineTest
extends TestCase {
    public void testDslCommandBuilder() {
        InputStream stream = ((Object)((Object)this)).getClass().getResourceAsStream("DslTestBuilder.testCase");
        ReteDslTestEngineTest.assertNotNull((Object)stream);
        NodeTestCase test = null;
        try {
            test = ReteDslTestEngine.compile(stream);
        }
        catch (Exception e) {
            e.printStackTrace();
            ReteDslTestEngineTest.fail((String)("Unexpected Exception: " + e.getMessage()));
        }
        ReteDslTestEngineTest.assertEquals((String)"Test Case Name", (String)test.getName());
        this.checkSetup(test);
        ReteDslTestEngineTest.assertEquals((int)0, (int)test.getTearDown().size());
        List<NodeTestDef> tests = test.getTests();
        ReteDslTestEngineTest.assertEquals((int)2, (int)tests.size());
        NodeTestDef test1 = tests.get(0);
        ReteDslTestEngineTest.assertEquals((String)"test 1", (String)test1.getName());
        ReteDslTestEngineTest.assertEquals((int)19, (int)test1.getLine());
        DslStep[] steps = test1.getSteps().toArray(new DslStep[0]);
        ReteDslTestEngineTest.assertEquals((int)6, (int)steps.length);
        int step = 0;
        ReteDslTestEngineTest.assertEquals((String)"assert", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        this.checkCommand(new String[]{"left", "[h0]"}, steps[step].getCommands().get(0));
        step = 1;
        ReteDslTestEngineTest.assertEquals((String)"col", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        this.checkCommand(new String[]{"leftMemory", "[[h0]]"}, steps[step].getCommands().get(0));
        step = 2;
        ReteDslTestEngineTest.assertEquals((String)"sink", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)2, (int)steps[step].getCommands().size());
        this.checkCommand(new String[]{"verify", "assert", "count", "1"}, steps[step].getCommands().get(0));
        this.checkCommand(new String[]{"verify", "assert", "tuple0[1]", "is(empty())"}, steps[step].getCommands().get(1));
        test1 = tests.get(1);
        ReteDslTestEngineTest.assertEquals((String)"another test", (String)test1.getName());
        ReteDslTestEngineTest.assertEquals((int)35, (int)test1.getLine());
        steps = test1.getSteps().toArray(new DslStep[0]);
        ReteDslTestEngineTest.assertEquals((int)3, (int)steps.length);
        step = 0;
        ReteDslTestEngineTest.assertEquals((String)"assert", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        this.checkCommand(new String[]{"left", "[h2]"}, steps[step].getCommands().get(0));
        step = 1;
        ReteDslTestEngineTest.assertEquals((String)"col", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        this.checkCommand(new String[]{"leftMemory", "[[h2]]"}, steps[step].getCommands().get(0));
    }

    private void checkCommand(String[] expected, String[] actual) {
        ReteDslTestEngineTest.assertEquals((int)expected.length, (int)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            ReteDslTestEngineTest.assertEquals((String)expected[i], (String)actual[i]);
        }
    }

    private void checkSetup(NodeTestCase test) {
        DslStep[] steps = test.getSetup().toArray(new DslStep[0]);
        ReteDslTestEngineTest.assertEquals((int)6, (int)steps.length);
        int step = 0;
        ReteDslTestEngineTest.assertEquals((String)"LeftTupleSource", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)4, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"left", (String)steps[step].getCommands().get(0)[0]);
        step = 1;
        ReteDslTestEngineTest.assertEquals((String)"ObjectSource", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)5, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"right", (String)steps[step].getCommands().get(0)[0]);
        step = 2;
        ReteDslTestEngineTest.assertEquals((String)"LeftTupleSink", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)6, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"sink", (String)steps[step].getCommands().get(0)[0]);
        step = 3;
        ReteDslTestEngineTest.assertEquals((String)"CollectNode", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)7, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)2, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)4, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"col", (String)steps[step].getCommands().get(0)[0]);
        ReteDslTestEngineTest.assertEquals((String)"left", (String)steps[step].getCommands().get(0)[1]);
        ReteDslTestEngineTest.assertEquals((String)"right", (String)steps[step].getCommands().get(0)[2]);
        ReteDslTestEngineTest.assertEquals((String)"java.util.ArrayList", (String)steps[step].getCommands().get(0)[3]);
        ReteDslTestEngineTest.assertEquals((int)4, (int)steps[step].getCommands().get(1).length);
        ReteDslTestEngineTest.assertEquals((String)"source", (String)steps[step].getCommands().get(1)[0]);
        ReteDslTestEngineTest.assertEquals((String)"type", (String)steps[step].getCommands().get(1)[1]);
        ReteDslTestEngineTest.assertEquals((String)"==", (String)steps[step].getCommands().get(1)[2]);
        ReteDslTestEngineTest.assertEquals((String)"l1", (String)steps[step].getCommands().get(1)[3]);
        step = 4;
        ReteDslTestEngineTest.assertEquals((String)"Binding", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)10, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)4, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"l1", (String)steps[step].getCommands().get(0)[0]);
        ReteDslTestEngineTest.assertEquals((String)"0", (String)steps[step].getCommands().get(0)[1]);
        ReteDslTestEngineTest.assertEquals((String)"org.drools.Person", (String)steps[step].getCommands().get(0)[2]);
        ReteDslTestEngineTest.assertEquals((String)"likes", (String)steps[step].getCommands().get(0)[3]);
        step = 5;
        ReteDslTestEngineTest.assertEquals((String)"Facts", (String)steps[step].getName());
        ReteDslTestEngineTest.assertEquals((int)12, (int)steps[step].getLine());
        ReteDslTestEngineTest.assertEquals((int)1, (int)steps[step].getCommands().size());
        ReteDslTestEngineTest.assertEquals((int)6, (int)steps[step].getCommands().get(0).length);
        ReteDslTestEngineTest.assertEquals((String)"org.drools.Person('darth', 35, \"brie\")", (String)steps[step].getCommands().get(0)[0]);
        ReteDslTestEngineTest.assertEquals((String)"org.drools.Cheese('brie', 12)", (String)steps[step].getCommands().get(0)[3]);
    }

    public void testObjectTypeNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode :\n";
        str = str + "otn1, java.lang.Integer;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        ObjectTypeNode otn1 = (ObjectTypeNode)result.context.get("otn1");
        ReteDslTestEngineTest.assertNotNull((Object)otn1);
        ReteDslTestEngineTest.assertEquals((Object)new ClassObjectType(Integer.class), (Object)otn1.getObjectType());
    }

    public void testLeftInputAdapterNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        ObjectTypeNode otn1 = (ObjectTypeNode)result.context.get("otn1");
        LeftInputAdapterNode lian0 = (LeftInputAdapterNode)result.context.get("lian0");
        ReteDslTestEngineTest.assertNotNull((Object)lian0);
        ReteDslTestEngineTest.assertSame((Object)lian0, (Object)otn1.getSinkPropagator().getSinks()[0]);
    }

    public void testBindingStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Declaration p1 = (Declaration)result.context.get("p1");
        ReteDslTestEngineTest.assertNotNull((Object)p1);
    }

    public void testJoinNodeStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        JoinNode join1 = (JoinNode)map.get("join1");
        ReteDslTestEngineTest.assertNotNull((Object)join1);
        PropagationContextImpl context = new PropagationContextImpl(0L, 0, null, null, null);
        ReteooWorkingMemory workingMemory = new ReteooWorkingMemory(1, (InternalRuleBase)((ReteooRuleBase)RuleBaseFactory.newRuleBase()));
        BetaMemory memory = (BetaMemory)workingMemory.getNodeMemory((NodeMemory)join1);
        DefaultFactHandle f0 = new DefaultFactHandle(0, (Object)0);
        LeftTuple tuple0 = new LeftTuple((InternalFactHandle)f0, (LeftTupleSink)join1, true);
        join1.assertLeftTuple(tuple0, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getLeftTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)0, (int)memory.getRightTupleMemory().size());
        DefaultFactHandle f1 = new DefaultFactHandle(1, (Object)0);
        LeftTuple tuple1 = new LeftTuple((InternalFactHandle)f1, (LeftTupleSink)join1, true);
        join1.assertLeftTuple(tuple1, (PropagationContext)context, (InternalWorkingMemory)workingMemory);
        ReteDslTestEngineTest.assertEquals((int)2, (int)memory.getLeftTupleMemory().size());
        LeftTuple leftTuple = memory.getLeftTupleMemory().getFirst((LeftTuple)null);
        ReteDslTestEngineTest.assertEquals((Object)tuple0, (Object)leftTuple);
        ReteDslTestEngineTest.assertEquals((Object)tuple1, (Object)leftTuple.getNext());
    }

    public void testFactsStep() throws Exception {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Facts:\n";
        str = str + "    1, 2, 'hello',\n";
        str = str + "    'good bye', new java.util.ArrayList();\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        WorkingMemory wm = (WorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        ReteDslTestEngineTest.assertNotNull((Object)wm);
        ReteDslTestEngineTest.assertNotNull((Object)handles);
        ReteDslTestEngineTest.assertEquals((int)5, (int)handles.size());
        ReteDslTestEngineTest.assertEquals((Object)1, (Object)((InternalFactHandle)handles.get(0)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)2, (Object)((InternalFactHandle)handles.get(1)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)"hello", (Object)((InternalFactHandle)handles.get(2)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)"good bye", (Object)((InternalFactHandle)handles.get(3)).getObject());
        ReteDslTestEngineTest.assertEquals(new ArrayList(), (Object)((InternalFactHandle)handles.get(4)).getObject());
    }

    public void testWithStep() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "Facts:\n";
        str = str + "    1, 2, new org.drools.Person('darth', 35),\n";
        str = str + "    'good bye', new java.util.ArrayList();\n";
        str = str + "With:\n";
        str = str + "    h2, age = 36, city = 'la',\n";
        str = str + "       state = 'ca';\n";
        str = str + "    h4, add( 2 );\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        WorkingMemory wm = (WorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        ReteDslTestEngineTest.assertNotNull((Object)wm);
        ReteDslTestEngineTest.assertNotNull((Object)handles);
        ReteDslTestEngineTest.assertEquals((int)5, (int)handles.size());
        Person p = new Person("darth", 36);
        p.setAge(36);
        p.setCity("la");
        p.setState("ca");
        ArrayList<Integer> list = new ArrayList<Integer>();
        list.add(2);
        ReteDslTestEngineTest.assertEquals((Object)1, (Object)((InternalFactHandle)handles.get(0)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)2, (Object)((InternalFactHandle)handles.get(1)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)p, (Object)((InternalFactHandle)handles.get(2)).getObject());
        ReteDslTestEngineTest.assertEquals((Object)"good bye", (Object)((InternalFactHandle)handles.get(3)).getObject());
        ReteDslTestEngineTest.assertEquals(list, (Object)((InternalFactHandle)handles.get(4)).getObject());
    }

    public void testBetaNodeAssertOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "    otn1,[h1, h3];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)2, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)2, (int)memory.getLeftTupleMemory().size());
    }

    public void testBetaNodeRetractOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn1,[h1, h3];\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "retract:\n";
        str = str + "    otn1,[h1];\n";
        str = str + "    otn2,[h2];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getLeftTupleMemory().size());
    }

    public void testBetaNodeSimpleMemoryChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3;\n";
        str = str + "assert:\n";
        str = str + "    otn1,[h1, h3];\n";
        str = str + "    otn2,[h0, h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory,[[h1], [h3]];\n";
        str = str + "    rightMemory,[h0, h2];\n";
        str = str + "retract:\n";
        str = str + "    otn1,[h1];\n";
        str = str + "    otn2,[h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory,[ [h3] ];\n";
        str = str + "    rightMemory,[h0];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getLeftTupleMemory().size());
    }

    public void testBetaNodeChainedMemoryChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    intValue, !=, p1;\n";
        str = str + "Facts:\n";
        str = str + "    0, 1, 2, 3, 4;\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "    otn3, [h4];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1], [h3]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0], [h3, h0],\n";
        str = str + "                [h1, h2], [h3, h2]];\n";
        str = str + "    rightMemory, [h4];\n";
        str = str + "retract:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "    otn2, [h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [ [h3] ];\n";
        str = str + "    rightMemory, [h0];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory,  [[h3, h0]];\n";
        str = str + "    rightMemory, [h4];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getLeftTupleMemory().size());
    }

    public void testBetaNodeChainedMemoryWithIndexChecks() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, java.lang.Integer, intValue;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    intValue, ==, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    intValue, ==, p1;\n";
        str = str + "Facts:\n";
        str = str + "    new Integer(0), new Integer(0), new Integer(0), 2, 4;\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "    otn3, [h4];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1]];\n";
        str = str + "    leftMemory, [[h3]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0],\n";
        str = str + "                [h1, h2]];\n";
        str = str + "    rightMemory, [h4];\n";
        str = str + "retract:\n";
        str = str + "    otn1, [h2];\n";
        str = str + "    otn2, [h3];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [ [h1] ];\n";
        str = str + "    rightMemory, [h0];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory,  [[h1, h0]];\n";
        str = str + "    rightMemory, [h4];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)1, (int)memory.getLeftTupleMemory().size());
    }

    public void testBetaNodeModifyOperations() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, java.lang.Integer;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn1;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn2, java.lang.Integer;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn3, java.lang.Integer;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, org.drools.Person, age;\n";
        str = str + "JoinNode:\n";
        str = str + "    join1, lian0, otn2;\n";
        str = str + "    age, ==, p1;\n";
        str = str + "JoinNode:\n";
        str = str + "    join2, join1, otn3;\n";
        str = str + "    age, ==, p1;\n";
        str = str + "Facts:\n";
        str = str + "    new org.drools.Person('darth', 35), new org.drools.Person('bobba', 35),\n";
        str = str + "    new org.drools.Person('yoda', 35), new org.drools.Person('luke', 35),\n";
        str = str + "    new org.drools.Person('dave', 36);\n";
        str = str + "assert:\n";
        str = str + "    otn1, [h1, h3, h4];\n";
        str = str + "    otn2, [h0, h2];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h1], [h3]];\n";
        str = str + "    leftMemory, [[h4]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h1, h0], [h3, h0],\n";
        str = str + "                [h1, h2], [h3, h2]];\n";
        str = str + "    rightMemory, [];\n";
        str = str + "With:\n";
        str = str + "    h1, age = 36;\n";
        str = str + "modify:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "join1:\n";
        str = str + "    leftMemory, [[h3]];\n";
        str = str + "    leftMemory, [[h4], [h1]];\n";
        str = str + "    rightMemory, [h0, h2];\n";
        str = str + "join2:\n";
        str = str + "    leftMemory, [[h3, h0],\n";
        str = str + "                [h3, h2]];\n";
        str = str + "    rightMemory, [];\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
        InternalWorkingMemory wm = (InternalWorkingMemory)map.get("WorkingMemory");
        List handles = (List)map.get("Handles");
        JoinNode join1 = (JoinNode)map.get("join1");
        BetaMemory memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join1);
        ReteDslTestEngineTest.assertEquals((int)2, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)3, (int)memory.getLeftTupleMemory().size());
        JoinNode join2 = (JoinNode)map.get("join2");
        memory = (BetaMemory)wm.getNodeMemory((NodeMemory)join2);
        ReteDslTestEngineTest.assertEquals((int)0, (int)memory.getRightTupleMemory().size());
        ReteDslTestEngineTest.assertEquals((int)2, (int)memory.getLeftTupleMemory().size());
    }

    public void testNotNodeStep() throws IOException {
        String str = "TestCase 'testOTN'\nTest 'dummy'\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn0, org.drools.Person;\n";
        str = str + "LeftInputAdapterNode:\n";
        str = str + "    lian0, otn0;\n";
        str = str + "ObjectTypeNode:\n";
        str = str + "    otn1, org.drools.Person;\n";
        str = str + "Binding:\n";
        str = str + "     p1, 0, org.drools.Person, age;\n";
        str = str + "NotNode:\n";
        str = str + "    not0, lian0, otn1;\n";
        str = str + "    age, !=, p1;\n";
        str = str + "LeftTupleSink:\n";
        str = str + "    sink, not0;\n";
        str = str + "Facts:\n";
        str = str + "    new org.drools.Person('darth', 35), new org.drools.Person('bobba', 35);\n";
        str = str + "assert:\n";
        str = str + "    otn0, [h0];\n";
        str = str + "    otn1, [h1];\n";
        str = str + "sink:\n";
        str = str + "    verify, assertLeft, count, 1;\n";
        str = str + "With:\n";
        str = str + "    h1, age = 36;\n";
        str = str + "modify:\n";
        str = str + "    otn1, [h1];\n";
        str = str + "sink:\n";
        str = str + "    verify, retractLeft, count, 1;\n";
        NodeTestCaseResult.NodeTestResult result = this.executeTest(str);
        Map<String, Object> map = result.context;
    }

    private void print(DslStep[] steps) {
        for (DslStep command : steps) {
            System.out.println(command);
        }
    }

    private NodeTestCaseResult.NodeTestResult executeTest(String str) throws IOException {
        NodeTestCase testCase = ReteDslTestEngine.compile(str);
        if (testCase.hasErrors()) {
            ReteDslTestEngineTest.fail((String)testCase.getErrors().toString());
        }
        ReteDslTestEngine tester = new ReteDslTestEngine();
        NodeTestCaseResult testCaseResult = tester.run(testCase, (RunNotifier)null);
        NodeTestCaseResult.NodeTestResult result = testCaseResult.getResults().get(0);
        if (result.result != NodeTestCaseResult.Result.SUCCESS) {
            ReteDslTestEngineTest.fail((String)result.getMessages());
        }
        return result;
    }
}

