/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo.test.dsl;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.ObjectSinkNode;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.RightTupleSink;
import org.drools.reteoo.Sink;
import org.drools.reteoo.test.dsl.DslStep;
import org.drools.reteoo.test.dsl.IsTuple;
import org.drools.spi.PropagationContext;
import org.hamcrest.CoreMatchers;
import org.junit.Assert;
import org.junit.matchers.JUnitMatchers;
import org.mockito.ArgumentCaptor;
import org.mockito.Matchers;
import org.mockito.Mockito;
import org.mockito.exceptions.base.MockitoAssertionError;
import org.mockito.internal.verification.api.VerificationMode;
import org.mvel2.MVEL;
import org.mvel2.ParserConfiguration;
import org.mvel2.ParserContext;
import org.mvel2.PropertyAccessException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockitoHelper {
    public static void process(DslStep step, Sink node, Map<String, Object> context, InternalWorkingMemory wm) {
        try {
            List<String[]> cmds = step.getCommands();
            for (Object[] objectArray : cmds) {
                if (objectArray[0].equals("verify")) {
                    if ("count".equals(objectArray[2])) {
                        MockitoHelper.verifyCount(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    if ("exec".equals(objectArray[2])) {
                        MockitoHelper.verifyExec(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    if (objectArray.length == 3 || objectArray.length == 4) {
                        MockitoHelper.verifyExpression(step, node, wm, (String[])objectArray, context);
                        continue;
                    }
                    throw new IllegalArgumentException("line " + step.getLine() + ": command '" + (String)objectArray[2] + "' does not exist in " + Arrays.toString(objectArray));
                }
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(objectArray));
            }
        }
        catch (Exception e) {
            throw new IllegalArgumentException("line " + step.getLine() + ": unable to execute step " + step, e);
        }
    }

    private static void verifyCount(DslStep step, Sink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        int times = Integer.valueOf(cmd[3]);
        VerificationMode counter = times >= 0 ? Mockito.times((int)times) : Mockito.atLeastOnce();
        try {
            ArgumentCaptor captor = null;
            if ("assertLeft".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(LeftTuple.class);
                ((LeftTupleSink)Mockito.verify((Object)((LeftTupleSink)node), (VerificationMode)counter)).assertLeftTuple((LeftTuple)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("retractLeft".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(LeftTuple.class);
                ((LeftTupleSink)Mockito.verify((Object)((LeftTupleSink)node), (VerificationMode)counter)).retractLeftTuple((LeftTuple)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("modifyLeft".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(LeftTuple.class);
                ((LeftTupleSink)Mockito.verify((Object)((LeftTupleSink)node), (VerificationMode)counter)).modifyLeftTuple((LeftTuple)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("assertRight".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(InternalFactHandle.class);
                ((ObjectSinkNode)Mockito.verify((Object)((ObjectSinkNode)node), (VerificationMode)counter)).assertObject((InternalFactHandle)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("modifyRight".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(RightTuple.class);
                ((RightTupleSink)Mockito.verify((Object)((RightTupleSink)node), (VerificationMode)counter)).modifyRightTuple((RightTuple)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else if ("retractRight".equals(cmd[1])) {
                captor = ArgumentCaptor.forClass(RightTuple.class);
                ((RightTupleSink)Mockito.verify((Object)((RightTupleSink)node), (VerificationMode)counter)).retractRightTuple((RightTuple)captor.capture(), (PropagationContext)Matchers.any(PropagationContext.class), (InternalWorkingMemory)Matchers.same((Object)wm));
            } else {
                throw new IllegalArgumentException("line " + step.getLine() + ": command does not exist " + Arrays.toString(cmd));
            }
            String key = MockitoHelper.getCaptorKey(node, cmd);
            context.put(key, captor);
        }
        catch (MockitoAssertionError e) {
            AssertionError ae = new AssertionError((Object)("line " + step.getLine() + ": verify failed: " + e.getMessage()));
            ((Throwable)((Object)ae)).setStackTrace(e.getStackTrace());
            throw ae;
        }
    }

    private static String getCaptorKey(Sink node, String[] cmd) {
        return System.identityHashCode(node) + "." + cmd[1] + ".captor";
    }

    private static void verifyExpression(DslStep step, Sink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        String expression;
        String key = MockitoHelper.getCaptorKey(node, cmd);
        ArgumentCaptor captor = (ArgumentCaptor)context.get(key);
        if (captor == null) {
            MockitoHelper.verifyCount(step, node, wm, new String[]{"verify", cmd[1], "count", "-1"}, context);
            captor = (ArgumentCaptor)context.get(key);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        MockitoHelper.populateCapturedArguments(captor, vars);
        vars.putAll(context);
        ParserConfiguration pconf = new ParserConfiguration();
        MockitoHelper.addStaticImports(pconf, CoreMatchers.class);
        MockitoHelper.addStaticImports(pconf, JUnitMatchers.class);
        try {
            pconf.addImport("isTuple", IsTuple.class.getMethod("isTuple", List.class));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        pconf.addImport("Assert", Assert.class);
        ParserContext mvelctx = new ParserContext(pconf);
        if (cmd.length == 3) {
            expression = "Assert.assertTrue( " + cmd[2].replaceAll("h(\\d+)", "Handles[$1]") + " );";
        } else {
            String val = cmd[2].replaceAll("h(\\d+)", "Handles[$1]");
            String matcher = cmd[3].replaceAll("h(\\d+)", "Handles[$1]");
            expression = "Assert.assertThat( " + val + ", " + matcher + " );";
        }
        try {
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)mvelctx);
            MVEL.executeExpression((Object)compiled, vars);
        }
        catch (PropertyAccessException e) {
            String message = e.getCause() instanceof InvocationTargetException ? ((InvocationTargetException)e.getCause()).getTargetException().toString() : e.getMessage();
            Assert.fail((String)("[ERROR] line " + step.getLine() + " - Executing expression: '" + expression + "'\n" + message));
        }
    }

    private static void populateCapturedArguments(ArgumentCaptor<?> captor, Map<String, Object> vars) {
        int i = 0;
        for (Object obj : captor.getAllValues()) {
            if (obj instanceof LeftTuple) {
                vars.put("tuple" + i++, ((LeftTuple)obj).toFactHandles());
                continue;
            }
            if (obj instanceof RightTuple) {
                vars.put("handle" + i++, ((RightTuple)obj).getFactHandle());
                continue;
            }
            if (!(obj instanceof InternalFactHandle)) continue;
            vars.put("handle" + i++, obj);
        }
    }

    private static void verifyExec(DslStep step, Sink node, InternalWorkingMemory wm, String[] cmd, Map<String, Object> context) throws AssertionError {
        String key = MockitoHelper.getCaptorKey(node, cmd);
        ArgumentCaptor captor = (ArgumentCaptor)context.get(key);
        if (captor == null) {
            MockitoHelper.verifyCount(step, node, wm, new String[]{"verify", cmd[1], "count", "-1"}, context);
            captor = (ArgumentCaptor)context.get(key);
        }
        HashMap<String, Object> vars = new HashMap<String, Object>();
        MockitoHelper.populateCapturedArguments(captor, vars);
        vars.putAll(context);
        ParserConfiguration pconf = new ParserConfiguration();
        MockitoHelper.addStaticImports(pconf, CoreMatchers.class);
        MockitoHelper.addStaticImports(pconf, JUnitMatchers.class);
        try {
            pconf.addImport("isTuple", IsTuple.class.getMethod("isTuple", List.class));
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        pconf.addImport("Assert", Assert.class);
        ParserContext mvelctx = new ParserContext(pconf);
        String expression = cmd[3].replaceAll("h(\\d+)", "Handles[$1]");
        try {
            Serializable compiled = MVEL.compileExpression((String)expression, (ParserContext)mvelctx);
            MVEL.executeExpression((Object)compiled, vars);
        }
        catch (PropertyAccessException e) {
            String message = e.getCause() instanceof InvocationTargetException ? ((InvocationTargetException)e.getCause()).getTargetException().toString() : e.getMessage();
            Assert.fail((String)("[ERROR] line " + step.getLine() + " - Executing expression: '" + expression + "'\n" + message));
        }
    }

    private static void addStaticImports(ParserConfiguration pconf, Class<?> clazz) {
        for (Method m : clazz.getMethods()) {
            if (!Modifier.isStatic(m.getModifiers())) continue;
            pconf.addImport(m.getName(), m);
        }
    }
}

