/*
 * Decompiled with CFR 0.152.
 */
package org.drools.rule;

import junit.framework.Assert;
import junit.framework.TestCase;
import org.drools.RuntimeDroolsException;
import org.drools.rule.GroupElement;
import org.drools.rule.GroupElementFactory;
import org.drools.rule.Pattern;
import org.drools.rule.RuleConditionElement;

public class GroupElementTest
extends TestCase {
    public void testPackNestedAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern1 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern2);
        GroupElementTest.assertEquals((int)2, (int)and1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, and1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, and1.getChildren().get(1));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)and1);
        and2.pack();
        GroupElementTest.assertEquals((int)2, (int)and2.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, and2.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, and2.getChildren().get(1));
    }

    public void testPackNestedOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElementTest.assertEquals((int)2, (int)or1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, or1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)or1);
        or2.pack();
        GroupElementTest.assertEquals((int)2, (int)or2.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, or2.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, or2.getChildren().get(1));
    }

    public void testPackNestedExists() {
        GroupElement exists1 = GroupElementFactory.newExistsInstance();
        Pattern pattern1 = new Pattern(0, null);
        exists1.addChild((RuleConditionElement)pattern1);
        GroupElementTest.assertEquals((int)1, (int)exists1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, exists1.getChildren().get(0));
        GroupElement exists2 = GroupElementFactory.newExistsInstance();
        exists2.addChild((RuleConditionElement)exists1);
        exists2.pack();
        GroupElementTest.assertEquals((int)1, (int)exists2.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, exists2.getChildren().get(0));
    }

    public void testAddMultipleChildsIntoNot() {
        GroupElement not = GroupElementFactory.newNotInstance();
        Pattern pattern1 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern1);
        }
        catch (RuntimeDroolsException rde) {
            Assert.fail((String)("Adding a single child is not supposed to throw Exception for NOT GE: " + rde.getMessage()));
        }
        Pattern pattern2 = new Pattern(0, null);
        try {
            not.addChild((RuleConditionElement)pattern2);
            Assert.fail((String)"Adding a second child into a NOT GE should throw Exception");
        }
        catch (RuntimeDroolsException rde) {
            // empty catch block
        }
    }

    public void testAddSingleBranchAnd() {
        GroupElement and1 = GroupElementFactory.newAndInstance();
        Pattern pattern = new Pattern(0, null);
        and1.addChild((RuleConditionElement)pattern);
        GroupElementTest.assertEquals((int)1, (int)and1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern, and1.getChildren().get(0));
        GroupElement or1 = GroupElementFactory.newOrInstance();
        or1.addChild((RuleConditionElement)and1);
        or1.pack();
        GroupElementTest.assertEquals((int)1, (int)or1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern, or1.getChildren().get(0));
    }

    public void testAddSingleBranchOr() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern);
        GroupElementTest.assertEquals((int)1, (int)or1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern, or1.getChildren().get(0));
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        and1.pack();
        GroupElementTest.assertEquals((int)1, (int)and1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern, and1.getChildren().get(0));
    }

    public void testDeepNestedStructure() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        GroupElementTest.assertEquals((int)1, (int)and1.getChildren().size());
        GroupElementTest.assertSame((Object)or1, and1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern1, or1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        GroupElementTest.assertEquals((int)1, (int)or2.getChildren().size());
        GroupElementTest.assertSame((Object)and1, or2.getChildren().get(0));
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        GroupElementTest.assertEquals((int)1, (int)or2.getChildren().size());
        GroupElementTest.assertSame((Object)or2, or3.getChildren().get(0));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        GroupElementTest.assertEquals((int)1, (int)and2.getChildren().size());
        GroupElementTest.assertSame((Object)or3, and2.getChildren().get(0));
        and2.pack();
        GroupElementTest.assertEquals((Object)GroupElement.Type.OR, (Object)and2.getType());
        GroupElementTest.assertEquals((int)2, (int)and2.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, and2.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, and2.getChildren().get(1));
    }

    public void testDeepNestedStructureWithMultipleElementsInRoot() {
        GroupElement or1 = GroupElementFactory.newOrInstance();
        Pattern pattern1 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern1);
        Pattern pattern2 = new Pattern(0, null);
        or1.addChild((RuleConditionElement)pattern2);
        GroupElement and1 = GroupElementFactory.newAndInstance();
        and1.addChild((RuleConditionElement)or1);
        GroupElementTest.assertEquals((int)1, (int)and1.getChildren().size());
        GroupElementTest.assertSame((Object)or1, and1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern1, or1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, or1.getChildren().get(1));
        GroupElement or2 = GroupElementFactory.newOrInstance();
        or2.addChild((RuleConditionElement)and1);
        GroupElementTest.assertEquals((int)1, (int)or2.getChildren().size());
        GroupElementTest.assertSame((Object)and1, or2.getChildren().get(0));
        GroupElement or3 = GroupElementFactory.newOrInstance();
        or3.addChild((RuleConditionElement)or2);
        GroupElementTest.assertEquals((int)1, (int)or2.getChildren().size());
        GroupElementTest.assertSame((Object)or2, or3.getChildren().get(0));
        GroupElement and2 = GroupElementFactory.newAndInstance();
        and2.addChild((RuleConditionElement)or3);
        Pattern pattern3 = new Pattern(0, null);
        and2.addChild((RuleConditionElement)pattern3);
        GroupElementTest.assertEquals((int)2, (int)and2.getChildren().size());
        GroupElementTest.assertSame((Object)or3, and2.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern3, and2.getChildren().get(1));
        and2.pack();
        GroupElementTest.assertTrue((boolean)and2.isAnd());
        GroupElementTest.assertEquals((int)2, (int)and2.getChildren().size());
        GroupElementTest.assertSame((Object)or1, and2.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern3, and2.getChildren().get(1));
        GroupElementTest.assertEquals((int)2, (int)or1.getChildren().size());
        GroupElementTest.assertSame((Object)pattern1, or1.getChildren().get(0));
        GroupElementTest.assertSame((Object)pattern2, or1.getChildren().get(1));
    }
}

