/*
 * Decompiled with CFR 0.152.
 */
package org.drools.util;

import java.util.Collection;
import junit.framework.TestCase;
import org.drools.core.util.PrimitiveLongMap;

public class PrimitiveLongMapTest
extends TestCase {
    public void testValues() {
        PrimitiveLongMap map = new PrimitiveLongMap();
        PrimitiveLongMapTest.assertNotNull((String)"MapNotNullTest ", (Object)map);
        Collection values = map.values();
        PrimitiveLongMapTest.assertNotNull((String)"ValuesNotNullTest ", (Object)values);
        PrimitiveLongMapTest.assertEquals((String)"ValuesZeroSizeTest ", (int)0, (int)values.size());
    }

    public void testPaging() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        for (int i = 0; i < 512; ++i) {
            Integer value = new Integer(i);
            Object oldValue = map.put((long)i, (Object)value);
            PrimitiveLongMapTest.assertNull((String)"OldValueNullTest ", (Object)oldValue);
            PrimitiveLongMapTest.assertEquals((String)"OldValueNullTest ", (Object)value, (Object)map.get((long)i));
        }
    }

    public void testGetWithNegativeKeyReturnsNull() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        PrimitiveLongMapTest.assertNull((Object)map.get(-1L));
    }

    public void testRemoveWithNegativeReturnsNull() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        PrimitiveLongMapTest.assertNull((Object)map.remove(-1L));
    }

    public void testPutWithNegativeKeyThrowsIllegalArgumentException() {
        PrimitiveLongMap map = new PrimitiveLongMap(2, 1);
        try {
            map.put(-1L, new Object());
            PrimitiveLongMapTest.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testMaxKey() {
        PrimitiveLongMap map = new PrimitiveLongMap(8, 4);
        map.put(0L, (Object)new Integer(0));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(0), (Object)map.get(0L));
        PrimitiveLongMapTest.assertNull((Object)map.remove(1L));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(0), (Object)map.get(0L));
        PrimitiveLongMapTest.assertNotNull((Object)map.remove(0L));
        PrimitiveLongMapTest.assertNull((Object)map.get(0L));
        map.put(1L, (Object)new Integer(1));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(1), (Object)map.get(1L));
        PrimitiveLongMapTest.assertNull((Object)map.remove(2L));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(1), (Object)map.get(1L));
        PrimitiveLongMapTest.assertNotNull((Object)map.remove(1L));
        PrimitiveLongMapTest.assertNull((Object)map.get(1L));
        map.put(127L, (Object)new Integer(127));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(127), (Object)map.get(127L));
        PrimitiveLongMapTest.assertNull((Object)map.remove(128L));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(127), (Object)map.get(127L));
        PrimitiveLongMapTest.assertNotNull((Object)map.remove(127L));
        PrimitiveLongMapTest.assertNull((Object)map.get(127L));
        map.put(128L, (Object)new Integer(128));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(128), (Object)map.get(128L));
        PrimitiveLongMapTest.assertNull((Object)map.remove(129L));
        PrimitiveLongMapTest.assertEquals((Object)new Integer(128), (Object)map.get(128L));
        PrimitiveLongMapTest.assertNotNull((Object)map.remove(128L));
        PrimitiveLongMapTest.assertNull((Object)map.get(128L));
    }

    public void testLastIndexBoundary() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        map.put(8192L, new Object());
        map.remove(8192L);
        map.put(8192L, new Object());
        map.put(8191L, new Object());
    }

    public void testSize() {
        PrimitiveLongMap map = new PrimitiveLongMap(32, 8);
        Object object = new Object();
        map.put(231L, object);
        Object string = new Object();
        map.put(211L, string);
        map.put(99822L, null);
        PrimitiveLongMapTest.assertEquals((int)3, (int)map.size());
        map.put(211L, null);
        map.put(99822L, string);
        PrimitiveLongMapTest.assertEquals((int)3, (int)map.size());
        map.remove(211L);
        PrimitiveLongMapTest.assertEquals((int)2, (int)map.size());
        map.remove(99822L);
        PrimitiveLongMapTest.assertEquals((int)1, (int)map.size());
        map.remove(231L);
        PrimitiveLongMapTest.assertEquals((int)0, (int)map.size());
    }
}

