/*
 * Decompiled with CFR 0.152.
 */
package org.drools.agent.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import org.drools.ChangeSet;
import org.drools.KnowledgeBase;
import org.drools.KnowledgeBaseConfiguration;
import org.drools.KnowledgeBaseFactory;
import org.drools.RuleBase;
import org.drools.SystemEventListener;
import org.drools.SystemEventListenerFactory;
import org.drools.agent.KnowledgeAgent;
import org.drools.agent.KnowledgeAgentConfiguration;
import org.drools.agent.impl.BinaryResourceDiffProducerImpl;
import org.drools.agent.impl.KnowledgeAgentConfigurationImpl;
import org.drools.agent.impl.ResourceDiffResult;
import org.drools.builder.KnowledgeBuilder;
import org.drools.builder.KnowledgeBuilderConfiguration;
import org.drools.builder.KnowledgeBuilderFactory;
import org.drools.builder.ResourceType;
import org.drools.common.AbstractRuleBase;
import org.drools.common.InternalRuleBase;
import org.drools.core.util.DroolsStreamUtils;
import org.drools.definition.KnowledgeDefinition;
import org.drools.definition.KnowledgePackage;
import org.drools.definition.process.Process;
import org.drools.definitions.impl.KnowledgePackageImp;
import org.drools.event.KnowledgeAgentEventSupport;
import org.drools.event.io.ResourceChangeListener;
import org.drools.event.knowledgeagent.KnowledgeAgentEventListener;
import org.drools.impl.KnowledgeBaseImpl;
import org.drools.impl.StatelessKnowledgeSessionImpl;
import org.drools.io.Resource;
import org.drools.io.ResourceChangeMonitor;
import org.drools.io.ResourceFactory;
import org.drools.io.impl.ClassPathResource;
import org.drools.io.impl.ResourceChangeNotifierImpl;
import org.drools.io.internal.InternalResource;
import org.drools.reteoo.ReteooRuleBase;
import org.drools.rule.Function;
import org.drools.rule.Package;
import org.drools.rule.Rule;
import org.drools.rule.TypeDeclaration;
import org.drools.runtime.KnowledgeSessionConfiguration;
import org.drools.runtime.StatelessKnowledgeSession;
import org.drools.xml.ChangeSetSemanticModule;
import org.drools.xml.SemanticModules;
import org.drools.xml.XmlChangeSetReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnowledgeAgentImpl
implements KnowledgeAgent,
ResourceChangeListener {
    private String name;
    private Set<Resource> resourceDirectories;
    private KnowledgeBase kbase;
    private ResourceChangeNotifierImpl notifier;
    private boolean newInstance;
    private SystemEventListener listener;
    private boolean scanDirectories;
    private boolean useKBaseClassLoaderForCompiling;
    private LinkedBlockingQueue<ChangeSet> queue;
    private Thread thread;
    private ChangeSetNotificationDetector changeSetNotificationDetector;
    private SemanticModules semanticModules;
    private final RegisteredResourceMap registeredResources = new RegisteredResourceMap();
    private Map<Resource, String> dslResources = new HashMap<Resource, String>();
    private KnowledgeAgentEventSupport eventSupport = new KnowledgeAgentEventSupport();
    private KnowledgeBuilderConfiguration builderConfiguration;

    public KnowledgeAgentImpl(String name, KnowledgeBase kbase, KnowledgeAgentConfiguration configuration, KnowledgeBuilderConfiguration builderConfiguration) {
        this.name = name;
        this.kbase = kbase;
        this.builderConfiguration = builderConfiguration;
        this.resourceDirectories = new HashSet<Resource>();
        this.listener = SystemEventListenerFactory.getSystemEventListener();
        this.queue = new LinkedBlockingQueue();
        boolean scanResources = false;
        boolean monitor = false;
        if (configuration != null) {
            this.newInstance = ((KnowledgeAgentConfigurationImpl)configuration).isNewInstance();
            this.useKBaseClassLoaderForCompiling = ((KnowledgeAgentConfigurationImpl)configuration).isUseKBaseClassLoaderForCompiling();
            this.notifier = (ResourceChangeNotifierImpl)ResourceFactory.getResourceChangeNotifierService();
            if (((KnowledgeAgentConfigurationImpl)configuration).isMonitorChangeSetEvents()) {
                monitor = true;
            }
            if (((KnowledgeAgentConfigurationImpl)configuration).isScanDirectories()) {
                this.scanDirectories = true;
            }
            if (scanResources = ((KnowledgeAgentConfigurationImpl)configuration).isScanResources()) {
                this.notifier.addResourceChangeMonitor((ResourceChangeMonitor)ResourceFactory.getResourceChangeScannerService());
                monitor = true;
            }
        }
        this.monitorResourceChangeEvents(monitor);
        this.autoBuildResourceMapping();
        this.listener.info("KnowledgeAgent created, with configuration:\nmonitorChangeSetEvents=" + monitor + " scanResources=" + scanResources + " scanDirectories=" + this.scanDirectories + " newInstance=" + this.newInstance);
    }

    public void setSystemEventListener(SystemEventListener listener) {
        this.listener = listener;
    }

    public Set<Resource> getResourceDirectories() {
        return this.resourceDirectories;
    }

    public boolean isNewInstance() {
        return this.newInstance;
    }

    public void applyChangeSet(Resource resource) {
        this.applyChangeSet(this.getChangeSet(resource));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void applyChangeSet(ChangeSet changeSet) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            this.eventSupport.fireBeforeChangeSetApplied(changeSet);
            this.listener.info("KnowledgeAgent applying ChangeSet");
            ChangeSetState changeSetState = new ChangeSetState();
            changeSetState.scanDirectories = this.scanDirectories;
            changeSetState.incrementalBuild = !this.newInstance;
            this.processChangeSet(changeSet, changeSetState);
            this.buildKnowledgeBase(changeSetState);
            this.eventSupport.fireAfterChangeSetApplied(changeSet);
        }
    }

    public void processChangeSet(Resource resource, ChangeSetState changeSetState) {
        this.processChangeSet(this.getChangeSet(resource), changeSetState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processChangeSet(ChangeSet changeSet, ChangeSetState changeSetState) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            this.eventSupport.fireBeforeChangeSetProcessed(changeSet);
            for (Resource resource : changeSet.getResourcesAdded()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_ADDED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    this.notifier.subscribeResourceChangeListener(this, resource);
                    try {
                        this.retrieveDSLResource(resource);
                    }
                    catch (IOException ex) {
                        this.listener.exception("KnowledgeAgent Fails trying to read DSL Resource: " + resource, (Throwable)ex);
                    }
                } else if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) {
                    this.listener.debug("KnowledgeAgent processing sub ChangeSet=" + resource);
                    this.processChangeSet(resource, changeSetState);
                } else if (((InternalResource)resource).isDirectory()) {
                    this.resourceDirectories.add(resource);
                    this.listener.debug("KnowledgeAgent subscribing to directory=" + resource);
                    this.notifier.subscribeResourceChangeListener(this, resource);
                    for (Resource child : ((InternalResource)resource).listResources()) {
                        if (((InternalResource)child).isDirectory()) continue;
                        ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                        this.addDefinitionMapping(child, null, true);
                        if (!this.addResourceMapping(child, true) || !changeSetState.incrementalBuild) continue;
                        changeSetState.addedResources.add(child);
                    }
                } else if (this.addResourceMapping(resource, true) && changeSetState.incrementalBuild) {
                    changeSetState.addedResources.add(resource);
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_ADDED);
            }
            for (Resource resource : changeSet.getResourcesRemoved()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_MODIFIED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    this.notifier.unsubscribeResourceChangeListener(this, resource);
                    this.dslResources.remove(resource);
                } else if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) {
                    this.processChangeSet(resource, changeSetState);
                } else if (changeSetState.scanDirectories && ((InternalResource)resource).isDirectory()) {
                    this.listener.debug("KnowledgeAgent unsubscribing from directory resource=" + resource);
                    this.resourceDirectories.remove(resource);
                    this.notifier.unsubscribeResourceChangeListener(this, resource);
                } else {
                    Set<KnowledgeDefinition> definitions = this.removeResourceMapping(resource, true);
                    if (definitions != null && changeSetState.incrementalBuild) {
                        changeSetState.removedResourceMappings.put(resource, definitions);
                    }
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_MODIFIED);
            }
            for (Resource resource : changeSet.getResourcesModified()) {
                this.eventSupport.fireBeforeResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_REMOVED);
                if (((InternalResource)resource).getResourceType() == ResourceType.DSL) {
                    try {
                        this.retrieveDSLResource(resource);
                    }
                    catch (IOException ex) {
                        this.listener.exception("KnowledgeAgent Fails trying to read DSL Resource: " + resource, (Throwable)ex);
                    }
                } else {
                    if (((InternalResource)resource).getResourceType() == ResourceType.CHANGE_SET) continue;
                    if (((InternalResource)resource).isDirectory()) {
                        if (this.resourceDirectories.add(resource)) {
                            this.listener.warning("KnowledgeAgent is subscribing to a modified directory=" + resource + " when it should have already been subscribed");
                            this.notifier.subscribeResourceChangeListener(this, resource);
                        }
                        for (Resource child : ((InternalResource)resource).listResources()) {
                            if (((InternalResource)child).isDirectory() || !this.addResourceMapping(child, true)) continue;
                            ((InternalResource)child).setResourceType(((InternalResource)resource).getResourceType());
                            if (!changeSetState.incrementalBuild) continue;
                            changeSetState.addedResources.add(child);
                        }
                    } else {
                        boolean isResourceMapped = this.registeredResources.isResourceMapped(resource);
                        if (!isResourceMapped) {
                            this.listener.warning("KnowledgeAgent subscribing to new resource=" + resource + ", though it was marked as modified.");
                            this.addResourceMapping(resource, true);
                            if (changeSetState.incrementalBuild) {
                                changeSetState.addedResources.add(resource);
                            }
                        } else if (changeSetState.incrementalBuild) {
                            Set<KnowledgeDefinition> definitions = this.removeResourceMapping(resource, true);
                            changeSetState.modifiedResourceMappings.put(resource, definitions);
                            this.addResourceMapping(resource, false);
                        }
                    }
                }
                this.eventSupport.fireAfterResourceProcessed(changeSet, resource, ((InternalResource)resource).getResourceType(), KnowledgeAgent.ResourceStatus.RESOURCE_REMOVED);
            }
            this.eventSupport.fireAfterChangeSetProcessed(changeSet, changeSetState.addedResources, changeSetState.modifiedResourceMappings, changeSetState.removedResourceMappings);
        }
    }

    public ChangeSet getChangeSet(Resource resource) {
        if (this.semanticModules == null) {
            this.semanticModules = new SemanticModules();
            this.semanticModules.addSemanticModule(new ChangeSetSemanticModule());
        }
        XmlChangeSetReader reader = new XmlChangeSetReader(this.semanticModules);
        if (resource instanceof ClassPathResource) {
            reader.setClassLoader(((ClassPathResource)resource).getClassLoader(), null);
        } else {
            reader.setClassLoader(((AbstractRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration().getClassLoader(), null);
        }
        ChangeSet changeSet = null;
        try {
            changeSet = reader.read(resource.getReader());
        }
        catch (Exception e) {
            this.listener.exception((Throwable)new RuntimeException("Unable to parse ChangeSet", e));
        }
        if (changeSet == null) {
            this.listener.exception((Throwable)new RuntimeException("Unable to parse ChangeSet"));
        }
        return changeSet;
    }

    private void buildResourceMapping(Package pkg, Resource resource) {
        if (resource == null) {
            this.listener.warning("KnowledgeAgent: trying to build a resource map for a null resource!");
            return;
        }
        this.buildResourceMapping(pkg, resource, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildResourceMapping(Package pkg, Resource resource, boolean autoDiscoverResource) {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            if (!autoDiscoverResource && resource == null) {
                this.listener.warning("KnowledgeAgent: Impossible to map to a null resource! Use autoDiscoverResource = true ");
                return;
            }
            if (autoDiscoverResource && resource != null) {
                this.listener.warning("KnowledgeAgent: building resource map with resource set and autoDiscoverResource=true. Resource value wil be overwritten!");
            }
            for (Rule rule : pkg.getRules()) {
                if (resource != null && !((InternalResource)resource).hasURL()) {
                    this.listener.debug("KnowledgeAgent no resource mapped for rule=" + rule);
                }
                if (autoDiscoverResource) {
                    resource = rule.getResource();
                }
                this.addDefinitionMapping(resource, (KnowledgeDefinition)rule, true);
            }
            for (Process process : pkg.getRuleFlows().values()) {
                if (resource != null && !((InternalResource)resource).hasURL()) {
                    this.listener.debug("KnowledgeAgent no resource mapped for rule=" + process);
                }
                if (autoDiscoverResource) {
                    resource = ((org.drools.process.core.Process)process).getResource();
                }
                this.addDefinitionMapping(resource, (KnowledgeDefinition)process, true);
            }
            for (TypeDeclaration typeDeclaration : pkg.getTypeDeclarations().values()) {
                if (resource != null && !((InternalResource)resource).hasURL()) {
                    this.listener.debug("KnowledgeAgent no resource mapped for rule=" + typeDeclaration);
                }
                if (autoDiscoverResource) {
                    resource = typeDeclaration.getResource();
                }
                this.addDefinitionMapping(resource, typeDeclaration, true);
            }
            for (Function function : pkg.getFunctions().values()) {
                if (resource != null && !((InternalResource)resource).hasURL()) {
                    this.listener.debug("KnowledgeAgent no resource mapped for rule=" + function);
                }
                if (autoDiscoverResource) {
                    resource = function.getResource();
                }
                this.addDefinitionMapping(resource, function, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void autoBuildResourceMapping() {
        this.listener.debug("KnowledgeAgent building resource map");
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            RuleBase rbase = ((KnowledgeBaseImpl)this.kbase).ruleBase;
            for (Package pkg : rbase.getPackages()) {
                this.buildResourceMapping(pkg, null, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public KnowledgeBase getKnowledgeBase() {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            return this.kbase;
        }
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession() {
        return new StatelessKnowledgeSessionImpl(null, this, null);
    }

    public StatelessKnowledgeSession newStatelessKnowledgeSession(KnowledgeSessionConfiguration conf) {
        return new StatelessKnowledgeSessionImpl(null, this, conf);
    }

    public void resourcesChanged(ChangeSet changeSet) {
        try {
            this.listener.debug("KnowledgeAgent received ChangeSet changed notification");
            this.queue.put(changeSet);
        }
        catch (InterruptedException e) {
            this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent error while adding ChangeSet notification to queue", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildKnowledgeBase(ChangeSetState changeSetState) {
        this.listener.debug("KnowledgeAgent rebuilding KnowledgeBase using ChangeSet");
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            if (this.newInstance) {
                this.rebuildResources(changeSetState);
            } else {
                this.incrementalBuildResources(changeSetState);
            }
            InternalRuleBase ruleBase = (InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase;
            Map map = ruleBase.getPackagesMap();
            synchronized (map) {
                if (ruleBase.getConfiguration().isSequential()) {
                    ruleBase.getReteooBuilder().order();
                }
            }
        }
        this.eventSupport.fireKnowledgeBaseUpdated(this.kbase);
        this.listener.debug("KnowledgeAgent finished rebuilding KnowledgeBase using ChangeSet");
    }

    private KnowledgePackageImp createPackageFromResource(Resource resource) {
        return this.createPackageFromResource(resource, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KnowledgePackageImp createPackageFromResource(Resource resource, KnowledgeBuilder kbuilder) {
        if (kbuilder == null) {
            kbuilder = this.createKBuilder();
        }
        if (((InternalResource)resource).getResourceType() != ResourceType.PKG) {
            kbuilder.add(resource, ((InternalResource)resource).getResourceType());
            if (kbuilder.hasErrors()) {
                this.eventSupport.fireResourceCompilationFailed(kbuilder, resource, ((InternalResource)resource).getResourceType());
                this.listener.warning("KnowledgeAgent has KnowledgeBuilder errors ", (Object)kbuilder.getErrors());
            }
            if (kbuilder.getKnowledgePackages().iterator().hasNext()) {
                return (KnowledgePackageImp)kbuilder.getKnowledgePackages().iterator().next();
            }
            return null;
        }
        InputStream is = null;
        KnowledgePackageImp kpkg = null;
        try {
            is = resource.getInputStream();
            Object object = DroolsStreamUtils.streamIn(is);
            kpkg = object instanceof KnowledgePackageImp ? (KnowledgePackageImp)object : new KnowledgePackageImp((Package)object);
            for (Rule rule : kpkg.pkg.getRules()) {
                rule.setResource(resource);
            }
        }
        catch (Exception ex) {
            this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to deserialize KnowledgeDefinitionsPackage  ", ex));
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException e) {
                this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to close KnowledgeDefinitionsPackage  ", e));
            }
        }
        return kpkg;
    }

    private void rebuildResources(ChangeSetState changeSetState) {
        if (!this.newInstance) {
            this.listener.warning("KnowledgeAgent rebuilding KnowledgeBase when newInstance is false");
        }
        this.kbase = this.kbase != null ? KnowledgeBaseFactory.newKnowledgeBase((KnowledgeBaseConfiguration)((InternalRuleBase)((KnowledgeBaseImpl)this.kbase).ruleBase).getConfiguration()) : KnowledgeBaseFactory.newKnowledgeBase();
        changeSetState.addedResources.clear();
        changeSetState.addedResources.addAll(this.registeredResources.getAllResources());
        this.addResourcesToKnowledgeBase(changeSetState);
        this.listener.info("KnowledgeAgent new KnowledgeBase now built and in use");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void incrementalBuildResources(ChangeSetState changeSetState) {
        if (this.newInstance) {
            this.listener.warning("KnowledgeAgent incremental build of KnowledgeBase when newInstance is true");
        }
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            KnowledgePackageImp kpkg;
            this.listener.info("KnowledgeAgent performing an incremental build of the ChangeSet");
            if (this.kbase == null) {
                this.kbase = KnowledgeBaseFactory.newKnowledgeBase();
            }
            for (Map.Entry<Resource, Set<KnowledgeDefinition>> entry : changeSetState.removedResourceMappings.entrySet()) {
                for (KnowledgeDefinition kd : entry.getValue()) {
                    this.removeKnowledgeDefinitionFromBase(kd);
                }
            }
            for (Map.Entry<Resource, Set<KnowledgeDefinition>> entry : changeSetState.modifiedResourceMappings.entrySet()) {
                kpkg = this.createPackageFromResource(entry.getKey());
                if (kpkg == null) {
                    this.listener.warning("KnowledgeAgent: The resource didn't create any package: " + entry.getKey());
                    continue;
                }
                this.listener.debug("KnowledgeAgent: Diffing: " + entry.getKey());
                BinaryResourceDiffProducerImpl rdp = new BinaryResourceDiffProducerImpl();
                ResourceDiffResult diff = rdp.diff(entry.getValue(), kpkg, (KnowledgePackageImp)this.kbase.getKnowledgePackage(kpkg.getName()));
                for (KnowledgeDefinition kd : diff.getRemovedDefinitions()) {
                    this.listener.debug("KnowledgeAgent: Removing: " + kd);
                    this.removeKnowledgeDefinitionFromBase(kd);
                }
                for (KnowledgeDefinition knowledgeDefinition : diff.getUnmodifiedDefinitions()) {
                    this.addDefinitionMapping(entry.getKey(), knowledgeDefinition, false);
                }
                changeSetState.createdPackages.put(entry.getKey(), diff.getPkg());
            }
            for (Resource resource : changeSetState.addedResources) {
                kpkg = this.createPackageFromResource(resource);
                if (kpkg == null) {
                    this.listener.warning("KnowledgeAgent: The resource didn't create any package: " + resource);
                    continue;
                }
                changeSetState.createdPackages.put(resource, kpkg);
            }
            changeSetState.addedResources.clear();
            changeSetState.modifiedResourceMappings.clear();
            this.addResourcesToKnowledgeBase(changeSetState);
        }
        this.listener.info("KnowledgeAgent incremental build of KnowledgeBase finished and in use");
    }

    private void removeKnowledgeDefinitionFromBase(KnowledgeDefinition kd) {
        try {
            if (kd instanceof Rule) {
                Rule rule = (Rule)kd;
                this.listener.debug("KnowledgeAgent removing Rule=" + rule + " from package=" + rule.getPackageName());
                this.kbase.removeRule(rule.getPackageName(), rule.getName());
            } else if (kd instanceof Process) {
                Process process = (Process)kd;
                this.listener.debug("KnowledgeAgent removing Process=" + process);
                this.kbase.removeProcess(process.getId());
            } else if (!(kd instanceof TypeDeclaration) && kd instanceof Function) {
                Function function = (Function)kd;
                this.kbase.removeFunction(function.getNamespace(), function.getName());
            }
        }
        catch (IllegalArgumentException e) {
            this.listener.warning(e.getMessage());
        }
    }

    private void addResourcesToKnowledgeBase(ChangeSetState changeSetState) {
        KnowledgeBuilder kbuilder = this.createKBuilder();
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Resource resource : changeSetState.addedResources) {
            KnowledgePackageImp createdPackage = this.createPackageFromResource(resource, kbuilder);
            changeSetState.createdPackages.put(resource, createdPackage);
        }
        for (Map.Entry entry : changeSetState.createdPackages.entrySet()) {
            Resource resource = (Resource)entry.getKey();
            this.listener.debug("KnowledgeAgent obtaining pkg resource=" + resource);
            try {
                Package pkg = ((KnowledgePackageImp)entry.getValue()).pkg;
                for (Rule rule : pkg.getRules()) {
                    rule.setResource(resource);
                }
                packages.add(pkg);
                this.buildResourceMapping(pkg, resource);
            }
            catch (Exception e) {
                this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent exception while trying to deserialize KnowledgeDefinitionsPackage  ", e));
            }
        }
        for (Package package_ : packages) {
            this.listener.debug("KnowledgeAgent adding KnowledgeDefinitionsPackage " + package_.getName());
            ((KnowledgeBaseImpl)this.kbase).ruleBase.addPackage(package_);
        }
    }

    public String getName() {
        return this.name;
    }

    public void monitorResourceChangeEvents(boolean monitor) {
        HashSet<Resource> allResources = new HashSet<Resource>();
        allResources.addAll(this.resourceDirectories);
        allResources.addAll(this.registeredResources.getAllResources());
        allResources.addAll(this.dslResources.keySet());
        for (Resource resource : allResources) {
            if (monitor) {
                this.listener.debug("KnowledgeAgent subscribing from resource=" + resource);
                this.notifier.subscribeResourceChangeListener(this, resource);
                continue;
            }
            this.listener.debug("KnowledgeAgent unsubscribing from resource=" + resource);
            this.notifier.unsubscribeResourceChangeListener(this, resource);
        }
        if (!monitor && this.changeSetNotificationDetector != null) {
            this.changeSetNotificationDetector.stop();
            this.thread.interrupt();
            this.changeSetNotificationDetector = null;
        } else if (monitor && this.changeSetNotificationDetector == null) {
            this.changeSetNotificationDetector = new ChangeSetNotificationDetector(this, this.queue, this.listener);
            this.thread = new Thread(this.changeSetNotificationDetector);
            this.thread.start();
        }
    }

    public boolean addResourceMapping(Resource resource, boolean notify) {
        boolean newMapping = this.registeredResources.createNewResourceEntry(resource);
        if (notify && newMapping) {
            this.listener.debug("KnowledgeAgent notifier subscribing to resource=" + resource);
            this.notifier.subscribeResourceChangeListener(this, resource);
            return true;
        }
        return false;
    }

    public boolean addDefinitionMapping(Resource resource, KnowledgeDefinition definition, boolean notify) {
        if (resource == null) {
            this.listener.warning("KnowledgeAgent: impossible to add a map for a null resource! skiping.");
            return false;
        }
        this.listener.debug("KnowledgeAgent mapping resource=" + resource + " to KnowledgeDefinition=" + definition);
        boolean isNewResource = this.registeredResources.isResourceMapped(resource);
        boolean isNewDefinition = true;
        if (definition != null) {
            isNewDefinition = this.registeredResources.putDefinition(resource, definition);
        }
        if (notify && isNewResource) {
            this.listener.debug("KnowledgeAgent notifier subscribing to resource=" + resource);
            this.notifier.subscribeResourceChangeListener(this, resource);
        }
        return isNewDefinition;
    }

    public Set<KnowledgeDefinition> removeResourceMapping(Resource resource, boolean unsubscribe) {
        this.listener.debug("KnowledgeAgent removing mappings for resource=" + resource + " with unsubscribe=" + unsubscribe);
        Set<KnowledgeDefinition> definitions = this.registeredResources.removeDefinitions(resource);
        if (definitions != null && unsubscribe) {
            this.listener.debug("KnowledgeAgent notifier unsubscribing to resource=" + resource);
            this.notifier.unsubscribeResourceChangeListener(this, resource);
        }
        return definitions;
    }

    private KnowledgeBuilder createKBuilder() {
        KnowledgeBuilder kbuilder = null;
        kbuilder = this.builderConfiguration != null ? KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)this.builderConfiguration) : (this.useKBaseClassLoaderForCompiling ? KnowledgeBuilderFactory.newKnowledgeBuilder((KnowledgeBuilderConfiguration)KnowledgeBuilderFactory.newKnowledgeBuilderConfiguration(null, (ClassLoader)((ReteooRuleBase)((KnowledgeBaseImpl)this.getKnowledgeBase()).getRuleBase()).getRootClassLoader())) : KnowledgeBuilderFactory.newKnowledgeBuilder());
        if (this.dslResources != null) {
            for (Map.Entry<Resource, String> entry : this.dslResources.entrySet()) {
                kbuilder.add(ResourceFactory.newByteArrayResource((byte[])entry.getValue().getBytes()), ResourceType.DSL);
            }
        }
        return kbuilder;
    }

    private void retrieveDSLResource(Resource resource) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(resource.getReader());
        String line = null;
        StringBuilder content = new StringBuilder();
        while ((line = bufferedReader.readLine()) != null) {
            content.append(line);
            content.append("\n");
        }
        this.dslResources.put(resource, content.toString());
    }

    public void addEventListener(KnowledgeAgentEventListener listener) {
        this.eventSupport.addEventListener(listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        RegisteredResourceMap registeredResourceMap = this.registeredResources;
        synchronized (registeredResourceMap) {
            Collection statefulSessions;
            if (this.kbase != null && (statefulSessions = this.kbase.getStatefulKnowledgeSessions()) != null && statefulSessions.size() > 0) {
                String message = "The kbase still contains " + statefulSessions.size() + " stateful sessions. You must dispose them first.";
                this.listener.warning(message);
                throw new IllegalStateException(message);
            }
            this.monitorResourceChangeEvents(false);
        }
    }

    protected void finalize() throws Throwable {
        if (this.changeSetNotificationDetector != null) {
            this.changeSetNotificationDetector.monitor = false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RegisteredResourceMap {
        private Map<Resource, Set<KnowledgeDefinition>> map = new HashMap<Resource, Set<KnowledgeDefinition>>();

        private RegisteredResourceMap() {
        }

        public boolean createNewResourceEntry(Resource resource) {
            if (!this.isResourceMapped(resource)) {
                this.map.put(resource, new HashSet());
                return true;
            }
            return false;
        }

        public boolean putDefinition(Resource resource, KnowledgeDefinition definition) {
            Set<KnowledgeDefinition> defList = this.map.get(resource);
            if (defList == null) {
                defList = new HashSet<KnowledgeDefinition>();
                this.map.put(resource, defList);
            }
            if (definition != null) {
                boolean isNew = defList.add(definition);
                return isNew;
            }
            return false;
        }

        public Set<KnowledgeDefinition> removeDefinitions(Resource resource) {
            return this.map.remove(resource);
        }

        public Set<KnowledgeDefinition> getDefinitions(Resource resource) {
            return this.getDefinitions(resource, false);
        }

        public Set<KnowledgeDefinition> getDefinitions(Resource resource, boolean returnEmptyIfNull) {
            Set<KnowledgeDefinition> definitions = this.map.get(resource);
            if (returnEmptyIfNull && definitions == null) {
                definitions = new HashSet<KnowledgeDefinition>();
            }
            return definitions;
        }

        public boolean isResourceMapped(Resource resource) {
            return this.map.containsKey(resource);
        }

        public Set<Resource> getAllResources() {
            return this.map.keySet();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ChangeSetNotificationDetector
    implements Runnable {
        private LinkedBlockingQueue<ChangeSet> queue;
        private volatile boolean monitor;
        private KnowledgeAgentImpl kagent;
        private SystemEventListener listener;

        public ChangeSetNotificationDetector(KnowledgeAgentImpl kagent, LinkedBlockingQueue<ChangeSet> queue, SystemEventListener listener) {
            this.queue = queue;
            this.kagent = kagent;
            this.listener = listener;
            this.monitor = true;
        }

        public void stop() {
            this.monitor = false;
        }

        @Override
        public void run() {
            if (this.monitor) {
                this.listener.info("KnowledegAgent has started listening for ChangeSet notifications");
            }
            while (this.monitor) {
                InterruptedException exception = null;
                try {
                    this.kagent.applyChangeSet(this.queue.take());
                }
                catch (InterruptedException e) {
                    exception = e;
                }
                Thread.yield();
                if (!this.monitor || exception == null) continue;
                this.listener.exception((Throwable)new RuntimeException("KnowledgeAgent ChangeSet notification thread has been interrupted, but shutdown was not scheduled", exception));
            }
            this.listener.info("KnowledegAgent has stopped listening for ChangeSet notifications");
        }
    }

    public static class ChangeSetState {
        List<Resource> addedResources = new ArrayList<Resource>();
        Map<Resource, Set<KnowledgeDefinition>> removedResourceMappings = new HashMap<Resource, Set<KnowledgeDefinition>>();
        Map<Resource, Set<KnowledgeDefinition>> modifiedResourceMappings = new HashMap<Resource, Set<KnowledgeDefinition>>();
        Map<Resource, KnowledgePackage> createdPackages = new LinkedHashMap<Resource, KnowledgePackage>();
        boolean scanDirectories;
        boolean incrementalBuild;
    }
}

