/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base.dataproviders;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import org.drools.WorkingMemory;
import org.drools.base.mvel.DroolsMVELFactory;
import org.drools.base.mvel.MVELCompilationUnit;
import org.drools.base.mvel.MVELCompileable;
import org.drools.core.util.ArrayIterator;
import org.drools.rule.Declaration;
import org.drools.spi.DataProvider;
import org.drools.spi.PropagationContext;
import org.drools.spi.Tuple;
import org.mvel2.MVEL;
import org.mvel2.integration.VariableResolverFactory;

public class MVELDataProvider
implements DataProvider,
MVELCompileable,
Externalizable {
    private static final long serialVersionUID = 1901006343031798173L;
    private MVELCompilationUnit unit;
    private String id;
    private Serializable expr;
    private DroolsMVELFactory prototype;
    private transient Declaration[] requiredDeclarations;

    public MVELDataProvider() {
    }

    public MVELDataProvider(MVELCompilationUnit unit, String id) {
        this.unit = unit;
        this.id = id;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.id = in.readUTF();
        this.unit = (MVELCompilationUnit)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.id);
        out.writeObject(this.unit);
    }

    public void compile(ClassLoader classLoader) {
        this.expr = this.unit.getCompiledExpression(classLoader);
        this.prototype = this.unit.getFactory();
        Map previousDeclarations = this.unit.getFactory().getPreviousDeclarations();
        this.requiredDeclarations = previousDeclarations.values().toArray(new Declaration[previousDeclarations.size()]);
    }

    public Declaration[] getRequiredDeclarations() {
        return this.requiredDeclarations;
    }

    public void replaceDeclaration(Declaration declaration, Declaration resolved) {
        for (int i = 0; i < this.requiredDeclarations.length; ++i) {
            if (!this.requiredDeclarations[i].equals(declaration)) continue;
            this.requiredDeclarations[i] = resolved;
        }
        this.unit.replaceDeclaration(declaration, resolved);
        this.prototype = this.unit.getFactory();
    }

    public Object createContext() {
        return this.prototype.clone();
    }

    public Iterator getResults(Tuple tuple, WorkingMemory wm, PropagationContext ctx, Object executionContext) {
        DroolsMVELFactory factory = (DroolsMVELFactory)executionContext;
        factory.setContext(tuple, null, null, wm, null);
        Object result = MVEL.executeExpression((Object)this.expr, (VariableResolverFactory)factory);
        if (result == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        if (result instanceof Collection) {
            return ((Collection)result).iterator();
        }
        if (result instanceof Iterator) {
            return (Iterator)result;
        }
        if (result.getClass().isArray()) {
            return new ArrayIterator(result);
        }
        return Collections.singletonList(result).iterator();
    }

    public DataProvider clone() {
        return this;
    }
}

