/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.drools.common.EqualityKey;
import org.drools.common.InternalFactHandle;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.RightTuple;
import org.drools.runtime.rule.WorkingMemoryEntryPoint;

@XmlRootElement(name="fact-handle")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFactHandle
implements InternalFactHandle {
    private static final long serialVersionUID = 400L;
    private int id;
    private long recency;
    private Object object;
    private EqualityKey key;
    private int objectHashCode;
    public RightTuple firstRightTuple;
    public RightTuple lastRightTuple;
    public LeftTuple firstLeftTuple;
    public LeftTuple lastLeftTuple;
    private WorkingMemoryEntryPoint entryPoint;

    public DefaultFactHandle() {
    }

    public DefaultFactHandle(int id, Object object) {
        this(id, object, (long)id);
    }

    public DefaultFactHandle(int id, Object object, long recency) {
        this.id = id;
        this.recency = recency;
        this.object = object;
        this.objectHashCode = object.hashCode();
    }

    public DefaultFactHandle(int id, int objectHashCode, long recency) {
        this.id = id;
        this.recency = recency;
        this.objectHashCode = objectHashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DefaultFactHandle)) {
            return false;
        }
        return this.id == ((DefaultFactHandle)object).id;
    }

    public int getObjectHashCode() {
        return this.objectHashCode;
    }

    public int getIdentityHashCode() {
        return System.identityHashCode(this.object);
    }

    protected void setObjectHashCode(int hashCode) {
        this.objectHashCode = hashCode;
    }

    public int hashCode() {
        return this.id;
    }

    public String toExternalForm() {
        return "0:" + this.id + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency();
    }

    @XmlAttribute(name="external-form")
    public String getExternalForm() {
        return this.toExternalForm();
    }

    public String toString() {
        return "[fact " + this.toExternalForm() + ":" + this.object + "]";
    }

    public long getRecency() {
        return this.recency;
    }

    public void setRecency(long recency) {
        this.recency = recency;
    }

    public int getId() {
        return this.id;
    }

    public void invalidate() {
        this.id = -1;
        this.object = null;
        this.entryPoint = null;
    }

    public boolean isValid() {
        return this.id != -1;
    }

    public Object getObject() {
        return this.object;
    }

    public void setObject(Object object) {
        this.object = object;
    }

    public EqualityKey getEqualityKey() {
        return this.key;
    }

    public void setEqualityKey(EqualityKey key) {
        this.key = key;
    }

    public boolean isEvent() {
        return false;
    }

    public RightTuple getFirstRightTuple() {
        return this.firstRightTuple;
    }

    public void setFirstRightTuple(RightTuple firstRightTuple) {
        this.firstRightTuple = firstRightTuple;
    }

    public RightTuple getLastRightTuple() {
        return this.lastRightTuple;
    }

    public void setLastRightTuple(RightTuple lastRightTuple) {
        this.lastRightTuple = lastRightTuple;
    }

    public void setFirstLeftTuple(LeftTuple firstLeftTuple) {
        this.firstLeftTuple = firstLeftTuple;
    }

    public LeftTuple getFirstLeftTuple() {
        return this.firstLeftTuple;
    }

    public void setLastLeftTuple(LeftTuple lastLeftTuple) {
        this.lastLeftTuple = lastLeftTuple;
    }

    public LeftTuple getLastLeftTuple() {
        return this.lastLeftTuple;
    }

    public WorkingMemoryEntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void setEntryPoint(WorkingMemoryEntryPoint sourceNode) {
        this.entryPoint = sourceNode;
    }

    public DefaultFactHandle clone() {
        DefaultFactHandle clone = new DefaultFactHandle(this.id, this.object, this.recency);
        clone.entryPoint = this.entryPoint;
        clone.key = this.key;
        clone.firstLeftTuple = this.firstLeftTuple;
        clone.lastLeftTuple = this.lastLeftTuple;
        clone.firstRightTuple = this.firstRightTuple;
        clone.lastRightTuple = this.lastRightTuple;
        clone.objectHashCode = this.objectHashCode;
        return clone;
    }

    public String toTupleTree(int indent) {
        StringBuilder buf = new StringBuilder();
        char[] spaces = new char[indent];
        Arrays.fill(spaces, ' ');
        String istr = new String(spaces);
        buf.append(istr);
        buf.append(this.toExternalString());
        buf.append("\n");
        for (LeftTuple leftTuple = this.firstLeftTuple; leftTuple != null; leftTuple = leftTuple.getLeftParentNext()) {
            buf.append(leftTuple.toTupleTree(indent + 4));
        }
        return buf.toString();
    }

    private Object toExternalString() {
        return "[F:" + this.getId() + " first=" + System.identityHashCode(this.firstLeftTuple) + " last=" + System.identityHashCode(this.lastLeftTuple) + " ]";
    }
}

