/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.SingleBetaConstraints;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.LeftTupleIndexHashTable;
import org.drools.core.util.LeftTupleList;
import org.drools.core.util.LinkedList;
import org.drools.core.util.LinkedListEntry;
import org.drools.core.util.RightTupleIndexHashTable;
import org.drools.core.util.RightTupleList;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleMemory;
import org.drools.reteoo.RightTupleMemory;
import org.drools.rule.ContextEntry;
import org.drools.rule.VariableConstraint;
import org.drools.spi.BetaNodeFieldConstraint;

public class DoubleBetaConstraints
implements BetaConstraints {
    private static final long serialVersionUID = 400L;
    private BetaNodeFieldConstraint constraint0;
    private BetaNodeFieldConstraint constraint1;
    private boolean indexed0;
    private boolean indexed1;

    public DoubleBetaConstraints() {
    }

    public DoubleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf) {
        this(constraints, conf, false);
    }

    public DoubleBetaConstraints(BetaNodeFieldConstraint[] constraints, RuleBaseConfiguration conf, boolean disableIndexing) {
        if (disableIndexing || !conf.isIndexLeftBetaMemory() && !conf.isIndexRightBetaMemory()) {
            this.indexed0 = false;
            this.indexed1 = false;
        } else {
            int depth = conf.getCompositeKeyDepth();
            boolean i0 = this.isIndexable(constraints[0]);
            boolean i1 = this.isIndexable(constraints[1]);
            if (depth >= 1 && i0) {
                this.indexed0 = true;
            }
            if (i1) {
                if (depth >= 1 && !i0) {
                    this.indexed0 = true;
                    this.swap(constraints, 1, 0);
                } else if (depth >= 2) {
                    this.indexed1 = true;
                }
            }
        }
        this.constraint0 = constraints[0];
        this.constraint1 = constraints[1];
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.constraint0 = (BetaNodeFieldConstraint)in.readObject();
        this.constraint1 = (BetaNodeFieldConstraint)in.readObject();
        this.indexed0 = in.readBoolean();
        this.indexed1 = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.constraint0);
        out.writeObject(this.constraint1);
        out.writeBoolean(this.indexed0);
        out.writeBoolean(this.indexed1);
    }

    private void swap(BetaNodeFieldConstraint[] constraints, int p1, int p2) {
        BetaNodeFieldConstraint temp = constraints[p2];
        constraints[p2] = constraints[p1];
        constraints[p1] = temp;
    }

    private boolean isIndexable(BetaNodeFieldConstraint constraint) {
        return SingleBetaConstraints.isIndexable(constraint);
    }

    public void updateFromTuple(ContextEntry[] context, InternalWorkingMemory workingMemory, LeftTuple tuple) {
        context[0].updateFromTuple(workingMemory, tuple);
        context[1].updateFromTuple(workingMemory, tuple);
    }

    public void updateFromFactHandle(ContextEntry[] context, InternalWorkingMemory workingMemory, InternalFactHandle handle) {
        context[0].updateFromFactHandle(workingMemory, handle);
        context[1].updateFromFactHandle(workingMemory, handle);
    }

    public void resetTuple(ContextEntry[] context) {
        context[0].resetTuple();
        context[1].resetTuple();
    }

    public void resetFactHandle(ContextEntry[] context) {
        context[0].resetFactHandle();
        context[1].resetFactHandle();
    }

    public boolean isAllowedCachedLeft(ContextEntry[] context, InternalFactHandle handle) {
        return !(!this.indexed0 && !this.constraint0.isAllowedCachedLeft(context[0], handle) || !this.indexed1 && !this.constraint1.isAllowedCachedLeft(context[1], handle));
    }

    public boolean isAllowedCachedRight(ContextEntry[] context, LeftTuple tuple) {
        return this.constraint0.isAllowedCachedRight(tuple, context[0]) && this.constraint1.isAllowedCachedRight(tuple, context[1]);
    }

    public boolean isIndexed() {
        return this.indexed0;
    }

    public int getIndexCount() {
        int count = 0;
        if (this.indexed0) {
            ++count;
        }
        if (this.indexed1) {
            ++count;
        }
        return count;
    }

    public boolean isEmpty() {
        return false;
    }

    public BetaMemory createBetaMemory(RuleBaseConfiguration config) {
        BetaMemory memory;
        AbstractHashTable.FieldIndex index;
        VariableConstraint variableConstraint;
        ArrayList<AbstractHashTable.FieldIndex> list = new ArrayList<AbstractHashTable.FieldIndex>(2);
        if (this.indexed0) {
            variableConstraint = (VariableConstraint)this.constraint0;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (this.indexed1) {
            variableConstraint = (VariableConstraint)this.constraint1;
            index = new AbstractHashTable.FieldIndex(variableConstraint.getFieldExtractor(), variableConstraint.getRequiredDeclarations()[0], variableConstraint.getEvaluator());
            list.add(index);
        }
        if (!list.isEmpty()) {
            AbstractHashTable.FieldIndex[] indexes = list.toArray(new AbstractHashTable.FieldIndex[list.size()]);
            LeftTupleMemory tupleMemory = config.isIndexLeftBetaMemory() ? new LeftTupleIndexHashTable(indexes) : new LeftTupleList();
            RightTupleMemory factHandleMemory = config.isIndexRightBetaMemory() ? new RightTupleIndexHashTable(indexes) : new RightTupleList();
            memory = new BetaMemory(config.isSequential() ? null : tupleMemory, factHandleMemory, this.createContext());
        } else {
            memory = new BetaMemory(config.isSequential() ? null : new LeftTupleList(), new RightTupleList(), this.createContext());
        }
        return memory;
    }

    public int hashCode() {
        return this.constraint0.hashCode() ^ this.constraint1.hashCode();
    }

    public LinkedList getConstraints() {
        LinkedList list = new LinkedList();
        list.add(new LinkedListEntry(this.constraint0));
        list.add(new LinkedListEntry(this.constraint1));
        return list;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof DoubleBetaConstraints)) {
            return false;
        }
        DoubleBetaConstraints other = (DoubleBetaConstraints)object;
        if (this.constraint0 != other.constraint0 && !this.constraint0.equals(other.constraint0)) {
            return false;
        }
        return this.constraint1 == other.constraint1 || this.constraint1.equals(other.constraint1);
    }

    public ContextEntry[] createContext() {
        return new ContextEntry[]{this.constraint0.createContextEntry(), this.constraint1.createContextEntry()};
    }
}

