/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import org.drools.common.DefaultFactHandle;

public class EventFactHandle
extends DefaultFactHandle {
    private static final long serialVersionUID = 5997141759543399455L;
    private long startTimestamp;
    private long duration;
    private boolean expired;
    private long activationsCount;

    public EventFactHandle() {
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object) {
        super(id, object);
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency) {
        super(id, object, recency);
        this.startTimestamp = 0L;
        this.duration = 0L;
    }

    public EventFactHandle(int id, Object object, long recency, long timestamp, long duration) {
        super(id, object, recency);
        this.startTimestamp = timestamp;
        this.duration = duration;
    }

    public String toExternalForm() {
        return "1:" + this.getId() + ":" + this.getIdentityHashCode() + ":" + this.getObjectHashCode() + ":" + this.getRecency();
    }

    public String toString() {
        return this.toExternalForm();
    }

    public boolean isEvent() {
        return true;
    }

    public long getStartTimestamp() {
        return this.startTimestamp;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEndTimestamp() {
        return this.startTimestamp + this.duration;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public long getActivationsCount() {
        return this.activationsCount;
    }

    public void increaseActivationsCount() {
        ++this.activationsCount;
    }

    public void decreaseActivationsCount() {
        --this.activationsCount;
    }

    public EventFactHandle clone() {
        EventFactHandle clone = new EventFactHandle(this.getId(), this.getObject(), this.getRecency(), this.startTimestamp, this.duration);
        clone.activationsCount = this.activationsCount;
        clone.expired = this.expired;
        clone.setEntryPoint(this.getEntryPoint());
        clone.setEqualityKey(this.getEqualityKey());
        clone.setFirstLeftTuple(this.getLastLeftTuple());
        clone.setLastLeftTuple(this.getLastLeftTuple());
        clone.setFirstRightTuple(this.getFirstRightTuple());
        clone.setLastRightTuple(this.getLastRightTuple());
        clone.setObjectHashCode(this.getObjectHashCode());
        return clone;
    }
}

