/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Map;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.definition.rule.Rule;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkAdapter;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EvalCondition;
import org.drools.spi.PropagationContext;
import org.drools.spi.RuleComponent;

public class EvalConditionNode
extends LeftTupleSource
implements LeftTupleSinkNode,
NodeMemory {
    private static final long serialVersionUID = 400L;
    private EvalCondition condition;
    private LeftTupleSource tupleSource;
    protected boolean tupleMemoryEnabled;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public EvalConditionNode() {
    }

    public EvalConditionNode(int id, LeftTupleSource tupleSource, EvalCondition eval, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.condition = eval;
        this.tupleSource = tupleSource;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.condition = (EvalCondition)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.tupleMemoryEnabled = in.readBoolean();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.condition);
        out.writeObject(this.tupleSource);
        out.writeBoolean(this.tupleMemoryEnabled);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    public EvalCondition getCondition() {
        return this.condition;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean allowed = this.condition.isAllowed(leftTuple, workingMemory, memory.context);
        if (allowed) {
            this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
        }
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        if (leftTuple.firstChild != null) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this);
        boolean wasPropagated = leftTuple.firstChild != null;
        boolean allowed = this.condition.isAllowed(leftTuple, workingMemory, memory.context);
        if (allowed) {
            if (wasPropagated) {
                this.sink.propagateModifyChildLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            } else {
                this.sink.propagateAssertLeftTuple(leftTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
        } else if (wasPropagated) {
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
        }
    }

    public String toString() {
        return "[EvalConditionNode: cond=" + this.condition + "]";
    }

    public int hashCode() {
        return this.tupleSource.hashCode() ^ this.condition.hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || object.getClass() != EvalConditionNode.class) {
            return false;
        }
        EvalConditionNode other = (EvalConditionNode)object;
        return this.tupleSource.equals(other.tupleSource) && this.condition.equals(other.condition);
    }

    public Object createMemory(RuleBaseConfiguration config) {
        return new EvalMemory(this.condition.createContext());
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTupleSinkUpdateAdapter adapter = new LeftTupleSinkUpdateAdapter(this, sink, this.condition);
        this.tupleSource.updateSink(adapter, context, workingMemory);
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        if (!node.isInUse()) {
            this.removeTupleSink((LeftTupleSink)((Object)node));
        }
        if (!this.isInUse()) {
            for (InternalWorkingMemory workingMemory : workingMemories) {
                workingMemory.clearNodeMemory(this);
            }
        } else {
            Map.Entry<Rule, RuleComponent> next = this.getAssociations().entrySet().iterator().next();
            this.condition = (EvalCondition)next.getValue();
        }
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isLeftTupleMemoryEnabled() {
        return this.tupleMemoryEnabled;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
        this.tupleMemoryEnabled = tupleMemoryEnabled;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public short getType() {
        return 3;
    }

    private static class LeftTupleSinkUpdateAdapter
    implements LeftTupleSink,
    LeftTupleSinkAdapter {
        private final EvalConditionNode node;
        private final LeftTupleSink sink;
        private final EvalCondition constraint;

        public LeftTupleSinkUpdateAdapter(EvalConditionNode node, LeftTupleSink sink, EvalCondition constraint) {
            this.node = node;
            this.sink = sink;
            this.constraint = constraint;
        }

        public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            EvalMemory memory = (EvalMemory)workingMemory.getNodeMemory(this.node);
            leftTuple.setLeftTupleSink(this.node);
            boolean allowed = this.constraint.isAllowed(leftTuple, workingMemory, memory.context);
            if (allowed) {
                LeftTuple tuple = new LeftTuple(leftTuple, this.sink, false);
                this.sink.assertLeftTuple(tuple, context, workingMemory);
            }
        }

        public short getType() {
            return 0;
        }

        public boolean isLeftTupleMemoryEnabled() {
            return false;
        }

        public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
            throw new UnsupportedOperationException("LeftTupleSinkUpdateAdapter onlys supports assertLeftTuple method calls");
        }

        public void readExternal(ObjectInput arg0) throws IOException, ClassNotFoundException {
        }

        public void writeExternal(ObjectOutput arg0) throws IOException {
        }

        public int getId() {
            return 0;
        }

        public RuleBasePartitionId getPartitionId() {
            return this.sink.getPartitionId();
        }

        public LeftTupleSink getRealSink() {
            return this.node;
        }
    }

    public static class EvalMemory
    implements Externalizable {
        private static final long serialVersionUID = -2754669682742843929L;
        public Object context;

        public EvalMemory() {
        }

        public EvalMemory(Object context) {
            this.context = context;
        }

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.context = in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.context);
        }
    }
}

