/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.base.DroolsQuery;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSinkNode;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ModifyPreviousTuples;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.TerminalNode;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.GroupElement;
import org.drools.rule.Query;
import org.drools.rule.Rule;
import org.drools.spi.PropagationContext;

public final class QueryTerminalNode
extends BaseNode
implements LeftTupleSinkNode,
TerminalNode {
    private static final long serialVersionUID = 400L;
    public static final short type = 8;
    private Rule rule;
    private GroupElement subrule;
    private LeftTupleSource tupleSource;
    private LeftTupleSinkNode previousTupleSinkNode;
    private LeftTupleSinkNode nextTupleSinkNode;

    public QueryTerminalNode() {
    }

    public QueryTerminalNode(int id, LeftTupleSource source, Rule rule, GroupElement subrule, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation());
        this.rule = rule;
        this.subrule = subrule;
        this.tupleSource = source;
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.rule = (Rule)in.readObject();
        this.subrule = (GroupElement)in.readObject();
        this.tupleSource = (LeftTupleSource)in.readObject();
        this.previousTupleSinkNode = (LeftTupleSinkNode)in.readObject();
        this.nextTupleSinkNode = (LeftTupleSinkNode)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.rule);
        out.writeObject(this.subrule);
        out.writeObject(this.tupleSource);
        out.writeObject(this.previousTupleSinkNode);
        out.writeObject(this.nextTupleSinkNode);
    }

    public Rule getRule() {
        return this.rule;
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery((Query)this.rule);
        query.getQueryResultCollector().rowAdded(this.rule, leftTuple, context, workingMemory);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery((Query)this.rule);
        query.getQueryResultCollector().rowRemoved(this.rule, leftTuple, context, workingMemory);
    }

    public void modifyLeftTuple(InternalFactHandle factHandle, ModifyPreviousTuples modifyPreviousTuples, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple leftTuple = modifyPreviousTuples.removeLeftTuple(this);
        if (leftTuple != null) {
            leftTuple.reAdd();
            this.modifyLeftTuple(leftTuple, context, workingMemory);
        } else {
            this.assertLeftTuple(new LeftTuple(factHandle, (LeftTupleSink)this, true), context, workingMemory);
        }
    }

    public void modifyLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        LeftTuple entry = leftTuple;
        while (entry.getParent() != null) {
            entry = entry.getParent();
        }
        DroolsQuery query = (DroolsQuery)entry.getLastHandle().getObject();
        query.setQuery((Query)this.rule);
        query.getQueryResultCollector().rowUpdated(this.rule, leftTuple, context, workingMemory);
    }

    public String toString() {
        return "[QueryTerminalNode(" + this.getId() + "): query=" + this.rule.getName() + "]";
    }

    public void ruleAttached() {
    }

    public void attach() {
        this.tupleSource.addTupleSink(this);
    }

    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.tupleSource.updateSink(this, propagationContext, workingMemory);
        }
    }

    public void networkUpdated() {
        this.tupleSource.networkUpdated();
    }

    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        this.tupleSource.remove(context, builder, this, workingMemories);
    }

    public boolean isInUse() {
        return false;
    }

    public void updateNewNode(InternalWorkingMemory workingMemory, PropagationContext context) {
    }

    public boolean isLeftTupleMemoryEnabled() {
        return false;
    }

    public void setLeftTupleMemoryEnabled(boolean tupleMemoryEnabled) {
    }

    public GroupElement getSubrule() {
        return this.subrule;
    }

    public LeftTupleSinkNode getPreviousLeftTupleSinkNode() {
        return this.previousTupleSinkNode;
    }

    public void setPreviousLeftTupleSinkNode(LeftTupleSinkNode previous) {
        this.previousTupleSinkNode = previous;
    }

    public LeftTupleSinkNode getNextLeftTupleSinkNode() {
        return this.nextTupleSinkNode;
    }

    public void setNextLeftTupleSinkNode(LeftTupleSinkNode next) {
        this.nextTupleSinkNode = next;
    }

    public short getType() {
        return 8;
    }
}

