/*
 * Decompiled with CFR 0.152.
 */
package org.drools.time.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.drools.runtime.Calendars;
import org.drools.time.Trigger;
import org.drools.time.impl.CompositeMaxDurationTrigger;
import org.drools.time.impl.DurationTimer;
import org.drools.time.impl.Timer;

public class CompositeMaxDurationTimer
implements Timer {
    private List<DurationTimer> durations;
    private Timer timer;

    public void addDurationTimer(DurationTimer durationTimer) {
        if (this.durations == null) {
            this.durations = new LinkedList<DurationTimer>();
        }
        this.durations.add(durationTimer);
    }

    public void setTimer(Timer timer) {
        this.timer = timer;
    }

    public Trigger createTrigger(long timestamp, String[] calendarNames, Calendars calendars) {
        return new CompositeMaxDurationTrigger(new Date(this.getMaxDuration() + timestamp), this.timer.createTrigger(timestamp, calendarNames, calendars), calendarNames, calendars);
    }

    private long getMaxDuration() {
        long result = 0L;
        for (DurationTimer durationTimer : this.durations) {
            result = Math.max(result, durationTimer.getDuration());
        }
        return result;
    }
}

