/*
 * Decompiled with CFR 0.152.
 */
package org.drools.base;

import java.util.Date;
import org.drools.base.ValueType;
import org.drools.base.field.BooleanFieldImpl;
import org.drools.base.field.DoubleFieldImpl;
import org.drools.base.field.LongFieldImpl;
import org.drools.base.field.ObjectFieldImpl;
import org.drools.spi.FieldValue;
import org.drools.util.DateUtils;
import org.drools.util.MathUtils;

public class FieldFactory {
    private static final FieldFactory INSTANCE = new FieldFactory();

    public static FieldFactory getInstance() {
        return INSTANCE;
    }

    private FieldFactory() {
    }

    public static FieldValue getFieldValue(String value, ValueType valueType) {
        FieldValue field = null;
        if (value == null) {
            valueType = ValueType.NULL_TYPE;
        }
        if (valueType == ValueType.NULL_TYPE) {
            field = new ObjectFieldImpl(null);
        } else if (valueType == ValueType.PCHAR_TYPE) {
            field = new LongFieldImpl(value.charAt(0));
        } else if (valueType == ValueType.PBYTE_TYPE) {
            field = new LongFieldImpl(Long.parseLong(value));
        } else if (valueType == ValueType.PSHORT_TYPE) {
            field = new LongFieldImpl(Long.parseLong(value));
        } else if (valueType == ValueType.PINTEGER_TYPE) {
            field = new LongFieldImpl(Long.parseLong(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.PLONG_TYPE) {
            field = new LongFieldImpl(Long.parseLong(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.PFLOAT_TYPE) {
            field = new DoubleFieldImpl(Float.parseFloat(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.PDOUBLE_TYPE) {
            field = new DoubleFieldImpl(Double.parseDouble(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.PBOOLEAN_TYPE) {
            field = new BooleanFieldImpl(Boolean.valueOf(value));
        } else if (valueType == ValueType.CHAR_TYPE) {
            field = new ObjectFieldImpl(new Character(value.charAt(0)));
        } else if (valueType == ValueType.BYTE_TYPE) {
            field = new ObjectFieldImpl(new Byte(value));
        } else if (valueType == ValueType.SHORT_TYPE) {
            field = new ObjectFieldImpl(new Short(value));
        } else if (valueType == ValueType.INTEGER_TYPE) {
            field = new ObjectFieldImpl(new Integer(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.LONG_TYPE) {
            field = new ObjectFieldImpl(new Long(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.FLOAT_TYPE) {
            field = new ObjectFieldImpl(new Float(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.DOUBLE_TYPE) {
            field = new ObjectFieldImpl(new Double(FieldFactory.stripNumericType(value)));
        } else if (valueType == ValueType.BOOLEAN_TYPE) {
            field = new ObjectFieldImpl(Boolean.valueOf(value));
        } else if (valueType == ValueType.STRING_TYPE) {
            field = new ObjectFieldImpl(value.intern());
        } else if (valueType == ValueType.DATE_TYPE) {
            Date date = DateUtils.parseDate(value);
            field = new ObjectFieldImpl(date);
        } else if (valueType == ValueType.ARRAY_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.OBJECT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BIG_DECIMAL_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigDecimal(value));
        } else if (valueType == ValueType.BIG_INTEGER_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigInteger(value));
        }
        return field;
    }

    public static FieldValue getFieldValue(Object value, ValueType valueType) {
        FieldValue field = null;
        if (value == null) {
            valueType = ValueType.NULL_TYPE;
        }
        if (valueType == ValueType.NULL_TYPE) {
            field = new ObjectFieldImpl(null);
        } else if (valueType == ValueType.PCHAR_TYPE) {
            field = value instanceof String && ((String)value).length() == 1 ? new LongFieldImpl(((String)value).charAt(0)) : new LongFieldImpl(((Character)value).charValue());
        } else if (valueType == ValueType.PBYTE_TYPE) {
            field = value instanceof String ? new LongFieldImpl(Byte.parseByte((String)value)) : new LongFieldImpl(((Number)value).byteValue());
        } else if (valueType == ValueType.PSHORT_TYPE) {
            field = value instanceof String ? new LongFieldImpl(Short.parseShort((String)value)) : new LongFieldImpl(((Number)value).shortValue());
        } else if (valueType == ValueType.PINTEGER_TYPE) {
            field = value instanceof String ? new LongFieldImpl(Integer.parseInt(FieldFactory.stripNumericType((String)value))) : new LongFieldImpl(((Number)value).intValue());
        } else if (valueType == ValueType.PLONG_TYPE) {
            field = value instanceof String ? new LongFieldImpl(Long.parseLong(FieldFactory.stripNumericType((String)value))) : new LongFieldImpl(((Number)value).longValue());
        } else if (valueType == ValueType.PFLOAT_TYPE) {
            field = value instanceof String ? new DoubleFieldImpl(Float.parseFloat(FieldFactory.stripNumericType((String)value))) : new DoubleFieldImpl(((Number)value).floatValue());
        } else if (valueType == ValueType.PDOUBLE_TYPE) {
            field = value instanceof String ? new DoubleFieldImpl(Double.parseDouble(FieldFactory.stripNumericType((String)value))) : new DoubleFieldImpl(((Number)value).doubleValue());
        } else if (valueType == ValueType.PBOOLEAN_TYPE) {
            field = value instanceof String ? new BooleanFieldImpl(Boolean.valueOf((String)value)) : new BooleanFieldImpl((Boolean)value);
        } else if (valueType == ValueType.CHAR_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BYTE_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.SHORT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.INTEGER_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.LONG_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.FLOAT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.DOUBLE_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BOOLEAN_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.STRING_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.DATE_TYPE) {
            if (value instanceof String) {
                Date date = DateUtils.parseDate((String)value);
                field = new ObjectFieldImpl(date);
            } else {
                field = new ObjectFieldImpl(value);
            }
        } else if (valueType == ValueType.ARRAY_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.OBJECT_TYPE) {
            field = new ObjectFieldImpl(value);
        } else if (valueType == ValueType.BIG_DECIMAL_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigDecimal(value));
        } else if (valueType == ValueType.BIG_INTEGER_TYPE) {
            field = new ObjectFieldImpl(MathUtils.getBigInteger(value));
        }
        return field;
    }

    public static FieldValue getFieldValue(Object value) {
        return new ObjectFieldImpl(value);
    }

    public static FieldValue getFieldValue(byte value) {
        return new LongFieldImpl(value);
    }

    public static FieldValue getFieldValue(short value) {
        return new LongFieldImpl(value);
    }

    public static FieldValue getFieldValue(char value) {
        return new LongFieldImpl(value);
    }

    public static FieldValue getFieldValue(int value) {
        return new LongFieldImpl(value);
    }

    public static FieldValue getFieldValue(long value) {
        return new LongFieldImpl(value);
    }

    public static FieldValue getFieldValue(boolean value) {
        return new BooleanFieldImpl(value);
    }

    public static FieldValue getFieldValue(float value) {
        return new DoubleFieldImpl(value);
    }

    public static FieldValue getFieldValue(double value) {
        return new DoubleFieldImpl(value);
    }

    private static String stripNumericType(String value) {
        if (Character.getType(value.charAt(value.length() - 1)) != 9) {
            value = value.substring(0, value.length() - 1);
        }
        return value;
    }
}

