/*
 * Decompiled with CFR 0.152.
 */
package org.drools.common;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.drools.common.ActivationNode;
import org.drools.common.AgendaItem;
import org.drools.common.InternalAgendaGroup;
import org.drools.common.InternalRuleBase;
import org.drools.spi.Activation;
import org.drools.util.AbstractBaseLinkedListNode;
import org.drools.util.LinkedList;

public class SimpleAgendaGroup
implements InternalAgendaGroup {
    private static final long serialVersionUID = 400L;
    private String name;
    private LinkedList salienceGroups;
    private int size;
    private boolean active;

    public SimpleAgendaGroup() {
    }

    public SimpleAgendaGroup(String name, InternalRuleBase ruleBase) {
        this.name = name;
        this.salienceGroups = new LinkedList();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = (String)in.readObject();
        this.active = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.name);
        out.writeBoolean(this.active);
    }

    public String getName() {
        return this.name;
    }

    public void clear() {
        this.salienceGroups.clear();
    }

    public int size() {
        return this.size;
    }

    public void add(Activation activation) {
        int salience = activation.getSalience();
        SalienceGroup group = null;
        if (!this.salienceGroups.isEmpty()) {
            SalienceGroup newGroup;
            SalienceGroup lastGroup = (SalienceGroup)this.salienceGroups.getLast();
            if (salience <= lastGroup.getSalience()) {
                if (salience == lastGroup.getSalience()) {
                    group = lastGroup;
                } else {
                    newGroup = new SalienceGroup(salience);
                    this.salienceGroups.insertAfter(lastGroup, newGroup);
                    group = newGroup;
                }
            }
            if (group == null) {
                for (group = (SalienceGroup)this.salienceGroups.getFirst(); group != null && salience < group.getSalience(); group = (SalienceGroup)group.getNext()) {
                }
                if (salience != group.getSalience()) {
                    newGroup = new SalienceGroup(salience);
                    this.salienceGroups.insertAfter(group.getPrevious(), newGroup);
                    group = newGroup;
                }
            }
        } else {
            SalienceGroup newGroup = new SalienceGroup(salience);
            this.salienceGroups.add(newGroup);
            group = newGroup;
        }
        group.getList().add(new ActivationNode(activation, this));
    }

    public void remove(AgendaItem agendaItem) {
        int salience = agendaItem.getSalience();
        SalienceGroup group = null;
        SalienceGroup lastGroup = (SalienceGroup)this.salienceGroups.getLast();
        if (salience == lastGroup.getSalience()) {
            group = lastGroup;
        } else {
            for (group = (SalienceGroup)this.salienceGroups.getFirst(); group != null && group.getSalience() != salience; group = (SalienceGroup)group.getNext()) {
            }
        }
        if (group == null) {
            throw new RuntimeException("SalienceGroup does not exist, This should not be possible.");
        }
        group.getList().remove(agendaItem.getActivationNode());
    }

    public Activation getNext() {
        SalienceGroup group = (SalienceGroup)this.salienceGroups.getFirst();
        while (!this.salienceGroups.isEmpty() && (group == null || group != null && group.getList().isEmpty())) {
            this.salienceGroups.removeFirst();
            group = (SalienceGroup)this.salienceGroups.getFirst();
        }
        if (group != null) {
            ActivationNode node = (ActivationNode)group.getList().removeFirst();
            if (group.getList().isEmpty()) {
                this.salienceGroups.removeFirst();
            }
            return node.getActivation();
        }
        return null;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean activate) {
        this.active = activate;
    }

    public boolean isEmpty() {
        return this.salienceGroups.isEmpty();
    }

    public Activation[] getActivations() {
        return null;
    }

    public Activation[] getQueue() {
        return null;
    }

    public String toString() {
        return "AgendaGroup '" + this.name + "'";
    }

    public boolean equal(Object object) {
        if (object == null || !(object instanceof SimpleAgendaGroup)) {
            return false;
        }
        return ((SimpleAgendaGroup)object).name.equals(this.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void setFocus() {
        throw new UnsupportedOperationException();
    }

    public static class SalienceGroup
    extends AbstractBaseLinkedListNode {
        private int salience;
        private LinkedList list;

        public SalienceGroup(int salience) {
            this.salience = salience;
            this.list = new LinkedList();
        }

        public int getSalience() {
            return this.salience;
        }

        public LinkedList getList() {
            return this.list;
        }
    }
}

