/*
 * Decompiled with CFR 0.152.
 */
package org.drools.management;

import java.lang.management.ManagementFactory;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.drools.management.DroolsManagementAgentMBean;
import org.drools.management.KnowledgeBaseMonitoring;
import org.drools.reteoo.ReteooRuleBase;

public class DroolsManagementAgent
implements DroolsManagementAgentMBean {
    private static final String MBEAN_NAME = "org.drools:type=DroolsManagementAgent";
    private static DroolsManagementAgent INSTANCE;
    private static MBeanServer mbs;
    private long kbases = 0L;
    private long ksessions = 0L;
    private Map<Object, List<ObjectName>> mbeans = new HashMap<Object, List<ObjectName>>();

    private DroolsManagementAgent() {
    }

    public static synchronized DroolsManagementAgent getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new DroolsManagementAgent();
            try {
                MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
                ObjectName mbName = DroolsManagementAgent.createObjectName(MBEAN_NAME);
                if (!mbs.isRegistered(mbName)) {
                    mbs.registerMBean(INSTANCE, mbName);
                }
            }
            catch (Exception e) {
                System.err.println("Unable to register DroolsManagementAgent into the platform MBean Server");
                e.printStackTrace();
            }
        }
        return INSTANCE;
    }

    public synchronized long getKnowledgeBaseCount() {
        return this.kbases;
    }

    public synchronized long getSessionCount() {
        return this.ksessions;
    }

    public synchronized long getNextKnowledgeBaseId() {
        return ++this.kbases;
    }

    public synchronized long getNextKnowledgeSessionId() {
        return ++this.ksessions;
    }

    public void registerKnowledgeBase(ReteooRuleBase kbase) {
        KnowledgeBaseMonitoring mbean = new KnowledgeBaseMonitoring(kbase);
        this.registerMBean(kbase, mbean, mbean.getName());
    }

    public void registerMBean(Object owner, Object mbean, ObjectName name) {
        try {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            if (!mbs.isRegistered(name)) {
                mbs.registerMBean(mbean, name);
                List<ObjectName> mbl = this.mbeans.get(owner);
                if (mbl == null) {
                    mbl = new LinkedList<ObjectName>();
                    this.mbeans.put(owner, mbl);
                }
                mbl.add(name);
            }
        }
        catch (Exception e) {
            System.err.println("Unable to register mbean " + name + " into the platform MBean Server");
            e.printStackTrace();
        }
    }

    public void unregisterMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.remove(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl) {
                try {
                    mbs.unregisterMBean(name);
                }
                catch (Exception e) {
                    System.err.println("Exception unregistering mbean: " + name);
                    e.printStackTrace();
                }
            }
        }
    }

    public void unregisterDependentsMBeansFromOwner(Object owner) {
        List<ObjectName> mbl = this.mbeans.get(owner);
        if (mbl != null) {
            MBeanServer mbs = DroolsManagementAgent.getMBeanServer();
            for (ObjectName name : mbl.subList(1, mbl.size())) {
                try {
                    mbs.unregisterMBean(name);
                }
                catch (Exception e) {
                    System.err.println("Exception unregistering mbean: " + name);
                    e.printStackTrace();
                }
            }
            mbl.subList(1, mbl.size()).clear();
        }
    }

    public static ObjectName createObjectName(String name) {
        try {
            return new ObjectName(name);
        }
        catch (Exception e) {
            System.err.println("This is a bug. Error creating ObjectName for MBean: " + name);
            System.err.println("Please contact the development team and provide the following stack trace: " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static MBeanServer getMBeanServer() {
        if (mbs == null) {
            mbs = ManagementFactory.getPlatformMBeanServer();
        }
        return mbs;
    }
}

