/*
 * Decompiled with CFR 0.152.
 */
package org.drools.management;

import javax.management.ObjectName;
import org.drools.base.ClassObjectType;
import org.drools.management.DroolsManagementAgent;
import org.drools.management.KBaseConfigurationMonitor;
import org.drools.management.KnowledgeBaseMonitoringMBean;
import org.drools.management.ObjectTypeNodeMonitor;
import org.drools.reteoo.EntryPointNode;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooRuleBase;

public class KnowledgeBaseMonitoring
implements KnowledgeBaseMonitoringMBean {
    private static final String KBASE_PREFIX = "org.drools.kbases";
    private ReteooRuleBase kbase;
    private ObjectName name;

    public KnowledgeBaseMonitoring(ReteooRuleBase kbase) {
        this.kbase = kbase;
        this.name = DroolsManagementAgent.createObjectName("org.drools.kbases:id=" + kbase.getId());
    }

    public ObjectName getName() {
        return this.name;
    }

    public String getGlobals() {
        return this.kbase.getGlobals().toString();
    }

    public String getId() {
        return this.kbase.getId();
    }

    public String getPackages() {
        return this.kbase.getPackagesMap().keySet().toString();
    }

    public long getSessionCount() {
        return this.kbase.getWorkingMemoryCounter();
    }

    public String getEntryPoints() {
        return this.kbase.getRete().getEntryPointNodes().keySet().toString();
    }

    public void startInternalMBeans() {
        for (EntryPointNode epn : this.kbase.getRete().getEntryPointNodes().values()) {
            for (ObjectTypeNode otn : epn.getObjectTypeNodes().values()) {
                ObjectTypeNodeMonitor otnm = new ObjectTypeNodeMonitor(otn);
                ObjectName name = DroolsManagementAgent.createObjectName(this.name.getCanonicalName() + ",type=EntryPoints,EntryPoint=" + otnm.getNameSufix() + ",ObjectType=" + ((ClassObjectType)otn.getObjectType()).getClassName());
                DroolsManagementAgent.getInstance().registerMBean(this.kbase, otnm, name);
            }
        }
        KBaseConfigurationMonitor kbcm = new KBaseConfigurationMonitor(this.kbase.getConfiguration());
        ObjectName name = DroolsManagementAgent.createObjectName(this.name.getCanonicalName() + ",type=Configuration");
        DroolsManagementAgent.getInstance().registerMBean(this.kbase, kbcm, name);
    }

    public void stopInternalMBeans() {
        DroolsManagementAgent.getInstance().unregisterDependentsMBeansFromOwner(this.kbase);
    }
}

