/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import org.drools.RuleBaseConfiguration;
import org.drools.common.BetaConstraints;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.reteoo.BetaMemory;
import org.drools.reteoo.BetaNode;
import org.drools.reteoo.LeftTuple;
import org.drools.reteoo.LeftTupleSink;
import org.drools.reteoo.LeftTupleSource;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.RightTuple;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.Behavior;
import org.drools.rule.Collect;
import org.drools.rule.ContextEntry;
import org.drools.spi.AlphaNodeFieldConstraint;
import org.drools.spi.PropagationContext;
import org.drools.util.ArrayUtils;
import org.drools.util.Entry;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashMap;

public class CollectNode
extends BetaNode {
    private static final long serialVersionUID = 400L;
    private Collect collect;
    private AlphaNodeFieldConstraint[] resultConstraints;
    private BetaConstraints resultsBinder;
    private boolean unwrapRightObject;

    public CollectNode() {
    }

    public CollectNode(int id, LeftTupleSource leftInput, ObjectSource rightInput, AlphaNodeFieldConstraint[] resultConstraints, BetaConstraints sourceBinder, BetaConstraints resultsBinder, Behavior[] behaviors, Collect collect, boolean unwrapRight, BuildContext context) {
        super(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), leftInput, rightInput, sourceBinder, behaviors);
        this.resultsBinder = resultsBinder;
        this.resultConstraints = resultConstraints;
        this.collect = collect;
        this.unwrapRightObject = unwrapRight;
        this.tupleMemoryEnabled = context.isTupleMemoryEnabled();
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.collect = (Collect)in.readObject();
        this.resultConstraints = (AlphaNodeFieldConstraint[])in.readObject();
        this.resultsBinder = (BetaConstraints)in.readObject();
        this.unwrapRightObject = in.readBoolean();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.collect);
        out.writeObject(this.resultConstraints);
        out.writeObject(this.resultsBinder);
        out.writeBoolean(this.unwrapRightObject);
    }

    public void assertLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        Collection result = this.collect.instantiateResultObject(workingMemory);
        InternalFactHandle resultHandle = workingMemory.getFactHandleFactory().newFactHandle(result, workingMemory.getObjectTypeConfigurationRegistry().getObjectTypeConf(context.getEntryPoint(), result), workingMemory);
        CollectContext colctx = new CollectContext();
        colctx.resultTuple = new RightTuple(resultHandle, this);
        if (this.tupleMemoryEnabled) {
            memory.betaMemory.getLeftTupleMemory().add(leftTuple);
            memory.betaMemory.getCreatedHandles().put(leftTuple, colctx, false);
        }
        this.constraints.updateFromTuple(memory.betaMemory.getContext(), workingMemory, leftTuple);
        for (RightTuple rightTuple = memory.betaMemory.getRightTupleMemory().getFirst(leftTuple); rightTuple != null; rightTuple = (RightTuple)rightTuple.getNext()) {
            InternalFactHandle handle = rightTuple.getFactHandle();
            if (!this.constraints.isAllowedCachedLeft(memory.betaMemory.getContext(), handle)) continue;
            if (this.unwrapRightObject) {
                handle = ((LeftTuple)handle.getObject()).getLastHandle();
            }
            result.add(handle.getObject());
            if (!this.tupleMemoryEnabled) continue;
            new LeftTuple(leftTuple, rightTuple, this, this.tupleMemoryEnabled);
        }
        this.constraints.resetTuple(memory.betaMemory.getContext());
        this.evaluateResultConstraints(leftTuple, context, workingMemory, memory, colctx);
    }

    public void retractLeftTuple(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        memory.betaMemory.getLeftTupleMemory().remove(leftTuple);
        CollectContext colctx = (CollectContext)memory.betaMemory.getCreatedHandles().remove(leftTuple);
        LeftTuple child = this.getFirstMatch(leftTuple, colctx);
        while (child != null) {
            LeftTuple tmp = child.getLeftParentNext();
            child.unlinkFromLeftParent();
            child.unlinkFromRightParent();
            child = tmp;
        }
        if (colctx.propagated) {
            this.sink.propagateRetractLeftTupleDestroyRightTuple(leftTuple, context, workingMemory);
        }
    }

    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        RightTuple rightTuple = new RightTuple(factHandle, this);
        if (!this.behavior.assertRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory)) {
            rightTuple.unlinkFromRightParent();
            return;
        }
        memory.betaMemory.getRightTupleMemory().add(rightTuple);
        if (!this.tupleMemoryEnabled) {
            return;
        }
        this.constraints.updateFromFactHandle(memory.betaMemory.getContext(), workingMemory, factHandle);
        Entry[] tuples = memory.betaMemory.getLeftTupleMemory().toArray();
        for (int i = 0; i < tuples.length; ++i) {
            LeftTuple tuple = (LeftTuple)tuples[i];
            if (!this.constraints.isAllowedCachedRight(memory.betaMemory.getContext(), tuple)) continue;
            this.modifyTuple(true, tuple, rightTuple, context, workingMemory, memory);
        }
        this.constraints.resetFactHandle(memory.betaMemory.getContext());
    }

    public void retractRightTuple(RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        InternalFactHandle origin = (InternalFactHandle)context.getFactHandleOrigin();
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(null);
        }
        this.behavior.retractRightTuple(memory.betaMemory.getBehaviorContext(), rightTuple, workingMemory);
        memory.betaMemory.getRightTupleMemory().remove(rightTuple);
        LeftTuple leftTuple = rightTuple.getBetaChildren();
        while (leftTuple != null) {
            LeftTuple tmp = leftTuple.getRightParentNext();
            this.modifyTuple(false, leftTuple.getParent(), rightTuple, context, workingMemory, memory);
            leftTuple = tmp;
        }
        if (context.getType() == 5) {
            ((PropagationContextImpl)context).setFactHandle(origin);
        }
    }

    public void modifyTuple(boolean isAssert, LeftTuple leftTuple, RightTuple rightTuple, PropagationContext context, InternalWorkingMemory workingMemory, CollectMemory memory) {
        CollectContext colctx = (CollectContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
        if (colctx.propagated) {
            LeftTuple firstMatch = this.getFirstMatch(leftTuple, colctx);
            if (firstMatch != null) {
                firstMatch.getLeftParentPrevious().setLeftParentNext(null);
                firstMatch.setLeftParentPrevious(null);
            }
            this.sink.propagateRetractLeftTuple(leftTuple, context, workingMemory);
            leftTuple.setBetaChildren(firstMatch);
            colctx.propagated = false;
        }
        if (isAssert) {
            new LeftTuple(leftTuple, rightTuple, this, this.tupleMemoryEnabled);
        } else if (leftTuple.getBetaChildren() != null) {
            LeftTuple match = leftTuple.getBetaChildren();
            while (match.getRightParent() != rightTuple) {
                match = match.getLeftParentNext();
            }
            match.unlinkFromLeftParent();
            match.unlinkFromRightParent();
        }
        InternalFactHandle handle = rightTuple.getFactHandle();
        if (this.unwrapRightObject) {
            handle = ((LeftTuple)handle.getObject()).getLastHandle();
        }
        if (context.getType() == 0) {
            ((Collection)colctx.resultTuple.getFactHandle().getObject()).add(handle.getObject());
        } else if (context.getType() == 1 || context.getType() == 5) {
            ((Collection)colctx.resultTuple.getFactHandle().getObject()).remove(handle.getObject());
        } else if (context.getType() == 2 || context.getType() == 3 || context.getType() == 4) {
            if (isAssert) {
                ((Collection)colctx.resultTuple.getFactHandle().getObject()).add(handle.getObject());
            } else {
                ((Collection)colctx.resultTuple.getFactHandle().getObject()).remove(handle.getObject());
            }
        }
        this.evaluateResultConstraints(leftTuple, context, workingMemory, memory, colctx);
    }

    private void evaluateResultConstraints(LeftTuple leftTuple, PropagationContext context, InternalWorkingMemory workingMemory, CollectMemory memory, CollectContext colctx) {
        boolean isAllowed = true;
        int length = this.resultConstraints.length;
        for (int i = 0; i < length; ++i) {
            if (this.resultConstraints[i].isAllowed(colctx.resultTuple.getFactHandle(), workingMemory, memory.alphaContexts[i])) continue;
            isAllowed = false;
            break;
        }
        if (isAllowed) {
            this.resultsBinder.updateFromTuple(memory.resultsContext, workingMemory, leftTuple);
            if (this.resultsBinder.isAllowedCachedLeft(memory.resultsContext, colctx.resultTuple.getFactHandle())) {
                colctx.propagated = true;
                this.sink.propagateAssertLeftTuple(leftTuple, colctx.resultTuple, context, workingMemory, this.tupleMemoryEnabled);
            }
            this.resultsBinder.resetTuple(memory.resultsContext);
        }
    }

    private LeftTuple getFirstMatch(LeftTuple leftTuple, CollectContext colctx) {
        LeftTuple child = leftTuple.getBetaChildren();
        if (colctx.propagated) {
            for (int i = 0; i < this.sink.size(); ++i) {
                child = child.getLeftParentNext();
            }
        }
        return child;
    }

    public void updateSink(LeftTupleSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        CollectMemory memory = (CollectMemory)workingMemory.getNodeMemory(this);
        Iterator tupleIter = memory.betaMemory.getLeftTupleMemory().iterator();
        LeftTuple leftTuple = (LeftTuple)tupleIter.next();
        while (leftTuple != null) {
            CollectContext colctx = (CollectContext)memory.betaMemory.getCreatedHandles().get(leftTuple);
            if (colctx.propagated) {
                sink.assertLeftTuple(new LeftTuple(leftTuple, colctx.resultTuple, sink, this.tupleMemoryEnabled), context, workingMemory);
            }
            leftTuple = (LeftTuple)tupleIter.next();
        }
    }

    protected void doRemove(InternalWorkingMemory workingMemory, CollectMemory memory) {
        Iterator it = memory.betaMemory.getCreatedHandles().iterator();
        ObjectHashMap.ObjectEntry entry = (ObjectHashMap.ObjectEntry)it.next();
        while (entry != null) {
            CollectContext ctx = (CollectContext)entry.getValue();
            workingMemory.getFactHandleFactory().destroyFactHandle(ctx.resultTuple.getFactHandle());
            entry = (ObjectHashMap.ObjectEntry)it.next();
        }
    }

    public int hashCode() {
        return this.leftInput.hashCode() ^ this.rightInput.hashCode() ^ this.collect.hashCode() ^ this.resultsBinder.hashCode() ^ ArrayUtils.hashCode(this.resultConstraints);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !(object instanceof CollectNode)) {
            return false;
        }
        CollectNode other = (CollectNode)object;
        if (!(this.getClass() == other.getClass() && this.leftInput.equals(other.leftInput) && this.rightInput.equals(other.rightInput) && this.constraints.equals(other.constraints))) {
            return false;
        }
        return this.collect.equals(other.collect) && this.resultsBinder.equals(other.resultsBinder) && Arrays.equals(this.resultConstraints, other.resultConstraints);
    }

    public String toString() {
        return "[ " + this.getClass().getName() + "(" + this.id + ") ]";
    }

    public Object createMemory(RuleBaseConfiguration config) {
        CollectMemory memory = new CollectMemory();
        memory.betaMemory = this.constraints.createBetaMemory(config);
        memory.resultsContext = this.resultsBinder.createContext();
        memory.alphaContexts = new ContextEntry[this.resultConstraints.length];
        for (int i = 0; i < this.resultConstraints.length; ++i) {
            memory.alphaContexts[i] = this.resultConstraints[i].createContextEntry();
        }
        memory.betaMemory.setBehaviorContext(this.behavior.createBehaviorContext());
        return memory;
    }

    public short getType() {
        return 5;
    }

    public static class CollectContext
    implements Externalizable {
        private static final long serialVersionUID = -3076306175989410574L;
        public RightTuple resultTuple;
        public boolean propagated;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.resultTuple = (RightTuple)in.readObject();
            this.propagated = in.readBoolean();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.resultTuple);
            out.writeBoolean(this.propagated);
        }
    }

    public static class CollectMemory
    implements Externalizable {
        private static final long serialVersionUID = 400L;
        public BetaMemory betaMemory;
        public ContextEntry[] resultsContext;
        public ContextEntry[] alphaContexts;

        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            this.betaMemory = (BetaMemory)in.readObject();
            this.resultsContext = (ContextEntry[])in.readObject();
            this.alphaContexts = (ContextEntry[])in.readObject();
        }

        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.betaMemory);
            out.writeObject(this.resultsContext);
            out.writeObject(this.alphaContexts);
        }
    }
}

