/*
 * Decompiled with CFR 0.152.
 */
package org.drools.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashMap;
import java.util.Map;
import org.drools.base.ShadowProxy;
import org.drools.common.BaseNode;
import org.drools.common.InternalFactHandle;
import org.drools.common.InternalWorkingMemory;
import org.drools.common.InternalWorkingMemoryEntryPoint;
import org.drools.common.NodeMemory;
import org.drools.common.PropagationContextImpl;
import org.drools.common.RuleBasePartitionId;
import org.drools.reteoo.ObjectSink;
import org.drools.reteoo.ObjectSource;
import org.drools.reteoo.ObjectTypeConf;
import org.drools.reteoo.ObjectTypeNode;
import org.drools.reteoo.ReteooBuilder;
import org.drools.reteoo.RuleRemovalContext;
import org.drools.reteoo.builder.BuildContext;
import org.drools.rule.EntryPoint;
import org.drools.spi.ObjectType;
import org.drools.spi.PropagationContext;
import org.drools.util.Iterator;
import org.drools.util.ObjectHashSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntryPointNode
extends ObjectSource
implements Externalizable,
ObjectSink {
    private static final long serialVersionUID = 420L;
    private EntryPoint entryPoint;
    private Map<ObjectType, ObjectTypeNode> objectTypeNodes;

    public EntryPointNode() {
    }

    public EntryPointNode(int id, ObjectSource objectSource, BuildContext context) {
        this(id, context.getPartitionId(), context.getRuleBase().getConfiguration().isMultithreadEvaluation(), objectSource, context.getCurrentEntryPoint());
    }

    public EntryPointNode(int id, RuleBasePartitionId partitionId, boolean partitionsEnabled, ObjectSource objectSource, EntryPoint entryPoint) {
        super(id, partitionId, partitionsEnabled, objectSource, 999);
        this.entryPoint = entryPoint;
        this.objectTypeNodes = new HashMap<ObjectType, ObjectTypeNode>();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.entryPoint = (EntryPoint)in.readObject();
        this.objectTypeNodes = (Map)in.readObject();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.entryPoint);
        out.writeObject(this.objectTypeNodes);
    }

    public EntryPoint getEntryPoint() {
        return this.entryPoint;
    }

    public void assertObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        if (objectTypeConf.isShadowEnabled()) {
            ((ShadowProxy)handle.getObject()).updateProxy();
        }
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        int length = cachedNodes.length;
        for (int i = 0; i < length; ++i) {
            cachedNodes[i].assertObject(handle, context, workingMemory);
        }
    }

    @Override
    public void assertObject(InternalFactHandle factHandle, PropagationContext context, InternalWorkingMemory workingMemory) {
        throw new UnsupportedOperationException("This method should NEVER EVER be called");
    }

    public void retractObject(InternalFactHandle handle, PropagationContext context, ObjectTypeConf objectTypeConf, InternalWorkingMemory workingMemory) {
        Object object = handle.getObject();
        ObjectTypeNode[] cachedNodes = objectTypeConf.getObjectTypeNodes();
        if (cachedNodes == null) {
            return;
        }
        for (int i = 0; i < cachedNodes.length; ++i) {
            cachedNodes[i].retractObject(handle, context, workingMemory);
        }
    }

    @Override
    protected void addObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.put(node.getObjectType(), node);
    }

    @Override
    protected void removeObjectSink(ObjectSink objectSink) {
        ObjectTypeNode node = (ObjectTypeNode)objectSink;
        this.objectTypeNodes.remove(node.getObjectType());
    }

    @Override
    public void attach() {
        this.source.addObjectSink(this);
    }

    @Override
    public void attach(InternalWorkingMemory[] workingMemories) {
        this.attach();
        for (InternalWorkingMemory workingMemory : workingMemories) {
            workingMemory.updateEntryPointsCache();
            PropagationContextImpl propagationContext = new PropagationContextImpl(workingMemory.getNextPropagationIdCounter(), 3, null, null, null);
            this.source.updateSink(this, propagationContext, workingMemory);
        }
    }

    @Override
    protected void doRemove(RuleRemovalContext context, ReteooBuilder builder, BaseNode node, InternalWorkingMemory[] workingMemories) {
        ObjectTypeNode objectTypeNode = (ObjectTypeNode)node;
        this.removeObjectSink(objectTypeNode);
        for (int i = 0; i < workingMemories.length; ++i) {
            workingMemories[i].clearNodeMemory((NodeMemory)((Object)node));
        }
    }

    public Map<ObjectType, ObjectTypeNode> getObjectTypeNodes() {
        return this.objectTypeNodes;
    }

    @Override
    public int hashCode() {
        return this.entryPoint.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof EntryPointNode)) {
            return false;
        }
        EntryPointNode other = (EntryPointNode)object;
        return this.entryPoint.equals(other.entryPoint);
    }

    @Override
    public void updateSink(ObjectSink sink, PropagationContext context, InternalWorkingMemory workingMemory) {
        ObjectTypeNode node = (ObjectTypeNode)sink;
        ObjectType newObjectType = node.getObjectType();
        InternalWorkingMemoryEntryPoint wmEntryPoint = (InternalWorkingMemoryEntryPoint)((Object)workingMemory.getWorkingMemoryEntryPoint(this.entryPoint.getEntryPointId()));
        for (ObjectTypeConf objectTypeConf : wmEntryPoint.getObjectTypeConfigurationRegistry().values()) {
            if (!newObjectType.isAssignableFrom(objectTypeConf.getConcreteObjectTypeNode().getObjectType())) continue;
            objectTypeConf.resetCache();
            ObjectTypeNode sourceNode = objectTypeConf.getConcreteObjectTypeNode();
            Iterator it = ((ObjectHashSet)workingMemory.getNodeMemory(sourceNode)).iterator();
            ObjectHashSet.ObjectEntry entry = (ObjectHashSet.ObjectEntry)it.next();
            while (entry != null) {
                sink.assertObject((InternalFactHandle)entry.getValue(), context, workingMemory);
                entry = (ObjectHashSet.ObjectEntry)it.next();
            }
        }
    }

    public boolean isObjectMemoryEnabled() {
        return false;
    }

    public void setObjectMemoryEnabled(boolean objectMemoryEnabled) {
        throw new UnsupportedOperationException("Entry Point Node has no Object memory");
    }

    @Override
    public String toString() {
        return "[EntryPointNode(" + this.id + ") " + this.entryPoint + " ]";
    }
}

